---
title: Language engines
subtitle: Use other languages in knitr
date: '2012-05-04'
slug: engines
---

We can use any languages in **knitr**, including but not limited to R. Here
are some simple demos with Python, Awk, Ruby, Haskell, Bash, Perl, Graphviz,
TikZ, SAS, Scala, and CoffeeScript, etc:

- [python.Rmd](https://github.com/yihui/knitr-examples/blob/master/023-engine-python.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/023-engine-python.md))
- [c.Rmd](https://github.com/yihui/knitr-examples/blob/master/090-engine-c.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/090-engine-c.md))
- [fortran.Rmd](https://github.com/yihui/knitr-examples/blob/master/111-engine-fortran.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/111-engine-fortran.md))
- [sql.Rmd](https://github.com/yihui/knitr-examples/blob/master/115-engine-sql.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/115-engine-sql.md)) 
- [awk.Rmd](https://github.com/yihui/knitr-examples/blob/master/024-engine-awk.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/024-engine-awk.md))
- [ruby.Rmd](https://github.com/yihui/knitr-examples/blob/master/025-engine-ruby.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/025-engine-ruby.md))
- [haskell.Rmd](https://github.com/yihui/knitr-examples/blob/master/026-engine-haskell.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/026-engine-haskell.md))
- [bash.Rmd](https://github.com/yihui/knitr-examples/blob/master/027-engine-bash.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/027-engine-bash.md))
- [perl.Rmd](https://github.com/yihui/knitr-examples/blob/master/028-engine-perl.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/028-engine-perl.md))
- [dot.Rmd](https://github.com/yihui/knitr-examples/blob/master/057-engine-dot.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/057-engine-dot.md))
- [tikz.Rmd](https://github.com/yihui/knitr-examples/blob/master/058-engine-tikz.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/058-engine-tikz.md))
- [sas.Rmd](https://github.com/yihui/knitr-examples/blob/master/060-engine-sas.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/060-engine-sas.md))
- [coffeescript.Rmd](https://github.com/yihui/knitr-examples/blob/master/080-engine-coffeescript.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/080-engine-coffeescript.md))
- [polyglot.Rmd](https://github.com/yihui/knitr-examples/blob/master/106-polyglot.Rmd) ([output](https://github.com/yihui/knitr-examples/blob/master/106-polyglot.md))
    - Scala, Python, and Bash

These languages are easy to deal with because they can be called by pure
command line, e.g. `python -c` can execute the code passed in as a character
string.

The `Rcpp` engine is different, however. The C++ code is compiled through the
**Rcpp** package. See [Rcpp.Rmd](https://github.com/yihui/knitr-examples/blob/master/029-engine-Rcpp.Rmd)
([output](https://github.com/yihui/knitr-examples/blob/master/029-engine-Rcpp.md))
for example. Similarly, `C` code is compiled via `R CMD SHLIB`
([example](https://github.com/yihui/knitr-examples/blob/master/090-engine-c.Rmd)/[output](https://github.com/yihui/knitr-examples/blob/master/090-engine-c.md)).

A special engine `cat` can be used to save the content of a code chunk to a
file using the `cat()` function; see the
[example 095](https://github.com/yihui/knitr-examples/blob/master/095-pandoc-header.Rmd)
for an application.

The [object](../../objects) `knit_engines` stores a series of named
functions to handle code from different languages, and you are free to
define a function to deal with a custom language. See
[engine.R](https://github.com/yihui/knitr/blob/master/R/engine.R) for
examples on how I deal with Python and Awk.

I do not really know much about other languages, so please feel free to
[contribute](https://github.com/yihui/knitr/) more language
engines to **knitr**.

Note these languages work not only in Markdown, but also in other formats
like LaTeX.

Except `engine='R'` (default), all chunks are executed in separate sessions,
so the variables cannot be directly shared. If we want to make use of
objects created in previous chunks, we usually have to write them to files
(as side effects). For the `bash` engine, we can use `Sys.setenv()` to
export variables from R to bash ([example](https://github.com/yihui/knitr-examples/blob/master/061-bash-variable.md)).
For the `sql` and the `stan` engines, we can store the object as a variable
whose name is specified to the `output.var` chunk option. Another approach is to
use the (experimental) [**runr** package](https://github.com/yihui/runr).

Additional arguments can be passed to the engines via the `engine.opts` chunk
option. The option can be specified as a string (e.g., `'-p'`) or as a list of
strings named by engines (e.g., `list(perl = '-Mstrict -Mwarnings', bash = '-o errexit')`).
The latter is useful to template arguments via `knitr::opts_chunk$set()`.
For the `cat` engine, the code chunk can be displayed in the output if the chunk
language is specified via the `engine.opts` chunk option, e.g. `engine.opts = list(lang = 'makefile')`.
For the `tikz` engine, the path to the convert utility of ImageMagick can be
specified via the `engine.opts` chunk option, e.g. `engine.opts = list(convert = 'path/to/convert')`.
Similarly, more command line arguments to convert can be specified via, for
example, `engine.opts = list(convert.opts = '-density 300')`.
