---
title: Editors for knitr
subtitle: Work with Emacs, Texmaker, TeXShop, WinEdt and TextMate, etc
date: '2012-03-16'
slug: editors
---

I have written about [LyX](../lyx/), [RStudio](../rstudio/), [Emacs Org-mode](../org/) and [Eclipse](../eclipse/). There are still other editors that we can use with **knitr**, such as [Texmaker](http://www.xm1math.net/texmaker/) and WinEdt. The key is that you call R and load the **knitr** package, then call the function `knit()` or `knit2pdf()`.

## Texmaker

You can define a custom command to process Rnw documents by `User --> User Commands --> Edit User Commands`:

![Define user commands in Texmaker](https://db.yihui.org/imgur/ddIBH.png)

Note if you have not added R's bin path to the `PATH` variable, you need to use the full path to `Rscript.exe` in the above command like:

```bash
"C:/Program Files/R/R-2.14.2/bin/Rscript.exe" -e "knitr::knit2pdf('%.Rnw')"
```

If you do know where is `Rscript.exe`, simply open R and use `R.home('bin')` to find it. Then for an Rnw document, you can use this `knitr` command to compile it:

![Compile Rnw in Texmaker with knitr](https://db.yihui.org/imgur/xKoeT.png)

Click the arrow on the left to compile the document, and the right arrow to view PDF. Of course the above configuration is for Windows, but it is straightforward for other systems as well: change `Rscript.exe` to `Rscript` (in fact you can use `Rscript` under Windows as well).

## TeXStudio

For one, you can do basically the same thing as in Texmaker (thanks, Henrik Nyhus and [Paul J. Hurtado](https://twitter.com/MathBioPaul/status/691446297304272897)):

![knitr in TeXStudio](https://db.yihui.org/imgur/VFcvTUB.png)

If you reveal Advanced Options (bottom left), you'll also see `Commands ($PATH)` at the bottom, where you can input the path to your `R` folder (e.g. `C:\Program Files\R\R-3.3.2\bin\x64`, no quotes); then the user command (and other calls to knitr that you might want in other commands) can just be `Rscript.exe -e "knitr::knit2pdf('%.Rnw')"`.

Every time you run this user command (hotkey Alt-Shift-F1), you'll run knitr and silently generate the PDF; you'll need to hit F7 every time to refresh the viewer. Alternatively, you can add `| txs:///view-pdf` to the end of the command - the pipe character separates different commands you want to run one after another, so it'll basically hit F7 for you.

This is still pretty inefficient, however, if you're using a citation package like BibLaTeX; you'll need to keep running the bib file manually before compiling, and you may need to manually compile at least twice (and you might not be able to tell how many times you need), which will also call the viewer unnecessarily in the middle. TeXstudio is already great at compiling and/or running the bib tool and repeating however many times is needed when you hit Build & View (F5), and you can continue to make use of that with knitr by replacing the default compiler with the `Rscript.exe -e "knitr::knit2pdf('%.Rnw')"` command (assuming you already set the `R` folder `$PATH`). Make sure the "Repeat contained compilation commands" button next to it remains pressed.

This, of course, will make TeXstudio run off knitr instead of the standard LaTeX compilers by default, at least when you hit F5 (or F6); probably the only downside to this, for most people, is that it can make debugging your LaTeX code more difficult, as most errors will only give you the ambiguous warning that `texify.exe` "had status 1" (running `knitr` via user command doesn't improve that either). The log file is sometimes still useful, though even when it is, it refers to lines in the `.tex` file that knitr produced, and not the `.Rnw` file, so you need to open that file up and try and figure out what's wrong.

Overall, though, TeXstudio does allow you to use `knitr` while taking advantage of all its other LaTeX-writing perks; moreover, it makes it a lot easier to use `Biber`-based citation packages like `BibLaTeX-Chicago`, compared to RStudio which requires some awkward workarounds.

## WinEdt

The WinEdt mode [R-Sweave](http://www.winedt.org/Config/modes/R-Sweave.php) supports **knitr** now. Please read on if you want to configure WinEdt by yourself instead.

The following instructions were from [Phil Chalmers](https://github.com/philchalmers), and I did not test them at all, but I feel it should be in the ballpark.

1. Go to `Options -> Execution Modes -> PDFTeXify`. Then look for executable `Rscript.exe` (e.g. `C:\Program Files\R\R-2.14.2\bin\Rscript.exe`) and select that.
2. under `Switches` put `-e`, and under `Parameters` put `"knitr::knit2pdf('%n%t')"`

Now hitting `F9` will run everything for you at once, including opening up the PDF.

Thanks, Phil.

## Emacs/ESS

Since 12.09, **knitr** has been officially supported in [ESS](http://ess.r-project.org). If you are using Debian/Ubuntu, you can install it by

```bash 
sudo apt-get install ess
```

[Here is a short video](https://web.archive.org/web/20161225094148im_/http://cdn.screenr.com/video/d4307511-dfb6-48e0-8f1d-d80f46dc80ab.mp4) showing how to use **knitr** in ESS.

(For historic interest only) Both [Simon Potter](http://sjp.co.nz/posts/emacs-ess-knitr/) and [lucialam](https://constantmindmapping.wordpress.com/2012/06/12/knitr-and-emacs/) have blog posts about Emacs/**knitr**.

## Gedit

You can define external tools in [gedit](https://en.wikipedia.org/wiki/Gedit). Thanks to the tip from David Allen below, you may knit a document via

```bash
Rscript -e "library(knitr); knit('$GEDIT_CURRENT_DOCUMENT_NAME')"
```

## Sublime

The [KnitrSublime](https://github.com/andrewheiss/KnitrSublime) package by Andrew Heiss provides very rudimentary LaTeX support for **knitr** in Sublime Text 2.

## Vim

The [Vim-R-Plugin](http://www.vim.org/scripts/script.php?script_id=2628) has comprehensive support to **knitr** thanks to Jakson Aquino.

## TextMate

See [#252](https://github.com/yihui/knitr/issues/252#issuecomment-6034068) for one approach with Applescript for TextMate 2, and the [knitr.tmbundle](https://github.com/fonnesbeck/knitr.tmbundle) repository by Chris Fonnesbeck.

## TeXShop

It is easy to configure [TeXShop](http://pages.uoregon.edu/koch/texshop/) to work with **knitr**; just save the code below as a file `Knitr.engine` under the `Engines` directory of TeXShop (usually `~/Library/TeXShop/Engines/`):

```bash 
#!/bin/bash
export PATH=$PATH:/usr/texbin:/usr/local/bin
Rscript -e "library(knitr); knit('$1')"
latexmk -pdf "${1%.*}"
```

Courtesy of [Cameron Bracken](http://cameron.bracken.bz/sweave-for-texshop) and [Fabian Greimel](http://yihui.org/en/2012/06/enjoyable-reproducible-research/#comment-601032753).

## TeXworks

TeXworks is similar to Texmaker in terms of configuration for additional tools. Below is a screenshot of the configuration under Ubuntu, thanks to [Speravir](http://tex.stackexchange.com/a/85165/9128) for the answer on StackExchange (Windows/Mac OS should be similar, as long as `Rscript` is in `PATH`).

![TeXworks with knitr](https://db.yihui.org/imgur/d6tE6.png)

## Kile

The following method was pointed out by tirip01 in the comments below:

1. Open the `Build` tab, select `New..`, type `knitr` and press `Finish`. In the `General` tab enter `Rscript` in the `Command` field. Below, in the `Options` field type: `-e "knitr::knit2pdf('%source')"`

    ![](https://securecdn.disqus.com/uploads/mediaembed/images/564/4837/original.jpg)

1. Go to `Advanced` tab and set Rnw as `Source extension` and pdf as `Target extension`.

    ![](https://securecdn.disqus.com/uploads/mediaembed/images/564/4838/original.jpg)

1. In menu select `Compile`

Dr Marek Gągolewski also has a blog post [Configure Kile for knitr under GNU/Linux](http://www.rexamine.com/2013/04/configure-kile-for-knitr/), which describes a more complicated approach.

## Tinn-R

Tinn-R started to support **knitr** since v2.3.7.3.
