---
title: Upload images
subtitle: Publish images from chunks in the web
date: '2012-02-12'
slug: upload
---

The function `imgur_upload()` in the **knitr** package enables one to upload images to the image host <http://imgur.com> in R using the **RCurl** package. If the package [option](../../options/) `upload.fun` is a function (e.g. `imgur_upload`) that uploads files to a certain server/host, all plots generated in chunks will be uploaded automatically when the output format is HTML or Markdown.

- A simple example
  - source: [knitr-upload.Rmd](https://github.com/yihui/knitr-examples/blob/master/010-upload.Rmd)
  - output: [knitr-upload.md](https://github.com/yihui/knitr-examples/blob/master/010-upload.md)
- Two blog posts by Carl Boettiger on how to publish a post to Wordpress.com with knitr and RWordPress purely in R, with images uploaded to
  - [Imgur](http://www.carlboettiger.info/archives/3974) 
  - or [Flickr](http://www.carlboettiger.info/archives/3988)

This allows you to publish web pages quickly without worrying about image files; you only need to upload a single HTML (to any web servers) or Markdown file (to GitHub, for example).

Brave professors may encourage their brave students to write homeworks with a simple Markdown file, instead of MS Word (which is usually difficult to reproduce and frustrating to format elegantly).

The package option `opts_knit$get('upload.fun')` is customizable so that you can use your own function to upload an image. See the script [custom_knit.R](https://github.com/cboettig/socialR/blob/master/R/custom_knit.R) by Carl for examples.

