---
title: RStudio
subtitle: knitr support in RStudio
date: '2012-02-02'
slug: rstudio
---

The **knitr** support in RStudio was added since 0.96. You can download the [latest version](http://www.rstudio.org/download/) and enjoy the one-click PDF compilation in RStudio through **knitr**.

You are free to choose different engines to knit or weave the document, such as `Sweave` or `knitr` (please note the default is `Sweave` and you may want to [change it to `knitr`](http://stackoverflow.com/q/27592837/559676)), and you can also use different LaTeX backends such as `pdflatex` or `xelatex`.

Remember you do not have to use LaTeX; I encourage you to try [R Markdown](http://rmarkdown.rstudio.com) there, which is much easier to learn and use than LaTeX.

Be aware also that, as of now, RStudio does not support `biber` or packages that basically require it such as `biblatex-chicago`. A number of workarounds have been thrown around (see comments [here](https://texblog.org/2013/08/20/rknitr-automatic-bibliography-generation-with-biblatex-in-rstudio/) for example) but one reliable one, as proposed [here](http://tex.stackexchange.com/a/71574/125859), is to put the following in a chunk after `\end{document}`:

```r
system(paste(
  "biber", xfun::sans_ext(knitr::current_input()), "--isbn-normalise"
))
```

The only downside with this one is that it will fail the first time you compile a new file, before you have the auxiliary files generated; it'll work after that though. The `isbn-normalise` option, by the way, is optional but generally very useful: it automatically inserts hyphens in the right places in ISBNs.
