---
title: Org-mode
subtitle: Use knitr in Org-mode
date: '2012-02-01'
slug: org
---

> Update: [ravel.org](https://github.com/chasberry/orgmode-accessories) looks like a better solution for **knitr** in Org-mode. Thanks, Charles Berry.

The syntax of **knitr**/Sweave is not compatible with the Org-mode in Emacs. Ideally we should be able to write an R code chunk like this:

```r 
#+begin_src R chunk options...
x = rnorm(10)
plot(x)
#+end_src
```

If we want to use **knitr** in the Org-mode, we have to cheat a little bit by putting the R code chunks in `#+begin_LATEX` and `#+end_LATEX`, then convert the org document to tex, then rename to rnw, and finally process with **knitr** to get the real tex output.

```r 
#+begin_LATEX
<<demo-chunk, echo=TRUE>>= 
x = rnorm(10)
plot(x)
@
#+end_LATEX
```

Prasad Chalasani experimented with the above idea and put up a repository [OrgKnitr](https://github.com/pchalasani/OrgKnitr) on GitHub so that you can use his script to quickly compile an org document to PDF. Thanks, Prasad!

Actually I do not know much about Org-mode. If you have other ideas about the Org-mode, I'd love to hear about them too.
