---
title: Beamer
subtitle: Using knitr in beamer slides
date: '2011-12-08'
slug: beamer
---

It is straightforward to use Sweave or **knitr** with beamer; the only thing you need to be careful of is you have to add the `fragile` option to the frames that contain verbatim code. For LyX users, make sure you use the latest version of LyX (>= 2.1.2), and then you can use the `FragileFrame` environment instead of a standard `Frame` environment.

- A minimal beamer example for **knitr**
  - Rnw source: [knitr-beamer.Rnw](https://github.com/yihui/knitr/blob/master/inst/examples/knitr-beamer.Rnw)
  - LyX source: [knitr-beamer.lyx](https://github.com/yihui/knitr/blob/master/inst/examples/knitr-beamer.lyx)
  - PDF output: [knitr-beamer.pdf](https://github.com/yihui/knitr/releases/download/doc/knitr-beamer.pdf)
- A simplified version of the above example:
  - Rnw source: [knitr-beamer2.Rnw](https://gist.github.com/1803930)
- An example of [using full-page tikz figures in beamer slides](http://tex.stackexchange.com/a/46840/9128) on Stack Overflow
- [A knitr source file](https://gist.github.com/2387823) for including linguistic notation as graphical elements in ggplot2

One note on the Rnw source for users who came before **knitr** 0.6 -- in the past I used this in the preamble:

```tex 
\ifdefined\knitrout
  \renewenvironment{knitrout}{\begin{footnotesize}}{\end{footnotesize}}
\else
\fi
```

It will wrap the **knitr** output in a `footnotesize` environment, but since **knitr** 0.6, a single global option `size` will control the font size of the whole chunk, and this trick is no longer needed.

## How about HTML5 slides?

You can actually also try HTML slides, which smell fancy and modern. I have a [rough tutorial here](/en/2012/05/how-to-make-html5-slides-with-knitr/).

