---
title: LyX
subtitle: Using knitr with LyX
date: '2011-12-06'
slug: lyx
---

Since LyX 2.0.3, **knitr** can be used in LyX via a module named `Rnw
(knitr)`. See
[knitr.lyx](https://github.com/yihui/lyx/raw/master/examples/knitr.lyx) for
a simple example ([pdf
output](https://bitbucket.org/stat/lyx/downloads/knitr.pdf)). Just add the
module to your document and install **knitr** in R; then you are done.

![knitr module in LyX](https://db.yihui.org/imgur/jEKSh.png)

An important note to all LyX users: a big trouble with LyX+Sweave is that we
have got too many instructions in the past on how to configure LyX in order
to work with Sweave. Many tutorials are becoming misleading and confusing
(e.g. you no longer need to take care of `noweb.sty`). The only up-to-date
source is the [official LyX manual for
Sweave](https://bitbucket.org/stat/lyx/downloads/sweave.pdf).

## Ubuntu users

To install LyX, you can either check out the source code and compile it by
yourself:

```bash 
./authgen.sh
./configure
make
make install
```

or use the [PPA](https://launchpad.net/~lyx-devel/+archive/release) (much
easier):

```bash 
sudo add-apt-repository ppa:lyx-devel/release
sudo apt-get update
sudo apt-get install lyx
```

The one in the official repository is often lagging behind, and this PPA is
up-to-date.

## Other systems

If you use Windows or Mac OS, you can download LyX from <http://www.lyx.org>.

The most frequently seen trouble for Windows users is that R is not in `PATH`
by default; see the manual above or the [Stack Overflow
post](http://stackoverflow.com/q/9645451/559676) for the solution.

## Other languages

If you are under Windows and using multibyte characters, you need at least
LyX 2.0.6 and **knitr** 1.1. If your LyX version is lower than 2.0.6, you
are likely to run into problems due to the file encoding.

## Other examples

There are a couple of LyX examples under the [examples
directory](https://github.com/yihui/knitr/tree/master/inst/examples) of the
package repository. Remember to check out the bib files as well if there are
any.

Below is a short video of using **knitr** in LyX (no audio at the moment but
I plan to make a full tutorial in the future):

<div style="text-align: center;"><iframe src="https://player.vimeo.com/video/32948939?title=0&amp;byline=0&amp;portrait=0" width="600" height="458" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe><p><a href="http://vimeo.com/32948939">Using knitr in LyX</a> from <a href="http://vimeo.com/yihui">Yihui Xie</a> on <a href="http://vimeo.com">Vimeo</a>.</p></div>

## Some known issues

You should not let LyX mark foreign languages, otherwise it may ruin R code
chunks; see [#255](https://github.com/yihui/knitr/issues/255) for details.
Below are my language preferences in LyX:

![Do not mark foreign languages](https://db.yihui.org/imgur/vkLhP.png)

If your R code has output that contains single quotes, you may [run into an
error](http://stackoverflow.com/q/12448507/559676) like:

```tex 
! Undefined control sequence.
<argument> ^^M'
               ^^M
l.8 \end{verbatim}
```

To fix it, you need to update **knitr** to at least version 1.2.

For Mac OS X users, your OS has a [weird
bug](http://www.lyx.org/trac/ticket/8537#comment:19) that makes R fail to
set up the locale when started from LyX. As a result, R cannot process
multi-byte characters. You have to tell your locale info to R manually, e.g.
in `~/.Rprofile`:

```r 
cat('
Sys.setlocale(, "en_US.UTF-8")
', file = '~/.Rprofile', append = TRUE)
```

Here `en_US.UTF-8` is just one possible locale. Your OS might be using other
languages. To check what is the real locale, run `Sys.getlocale()` in a
normal R session (e.g. start R from the terminal).
