---
title: An Interview of Me by JP and Sarah
subtitle: Chatting about My R Journey, Hobbies, and the R Community
date: '2023-09-12'
slug: jp-sarah-interview
---

Two [posit::conf(2023)](https://posit.co/conference/) speakers, JP Flores and
Sarah Parker, reached out to me a couple of weeks ago for a potential interview.
Below is a list of questions and my answers, just for the record. I will not
attend the conference in person, but I may lurk on the Discord server during the
conference.

## How did you learn R and why do you continue to work on it?

I happen to have written a blog post about [how I learned
R](/en/2017/12/how-i-learned-r/) in 2017! In short, I first learned R around
2004 in a course when I was an undergraduate, but I only learned a tiny bit.
Later, I learned a lot more by helping other people on a web forum, even when I
did not know the solutions.

I continued to learn R and use R because I was highly interested in theoretical
statistics, and I was fascinated by the fact that I could look at some math
equations and type out the R code to do the computing by myself. I did not know
much about computers until I entered college. To be honest, anything running on
a computer was like magic to me at that time. I could not imagine that I could
also *write* "software", as software was still a new and difficult thing to me
two years ago. Later I read about John Chambers's goal of the S language:

> To ideas into software, quickly and faithfully

I definitely felt it.

A short report that I wrote on [spurious
regression](https://db.yihui.org/docs/Spurious-Regression-Yihui-Xie-2006.pdf) in
2006 is an example that shows my interest in theoretical statistics and
simulation. Of course, the R code at the end does not look great in my eyes 17
years later, but I still remember how excited I was when I could quickly write
some code to verify some math.

Later I fell in love with statistical graphics, which was an usual choice for a
student majored in statistics back then. You may take a look at another ["paper"
on
visualization](https://db.yihui.org/docs/R-visualization-paper-2007-Yihui-Xie.pdf)
I produced in 2007. Judging by today's standards, it may be garbage, but without
this piece of garbage (which contains my full passion), I would not have started
developing my first R package,
[**animation**](https://cran.r-project.org/package=animation). Again, the code
quality of this package is quite poor, but without this first package, perhaps
there would not be the next [20+
packages](https://r-pkg.org/maint/xie@yihui.name) in the next 15 years.

## Would you mind painting a picture of who you are?

That's really a hard question. Know thyself... That feels like a life mission to
me.

Anyway, in recent years it has become clearer and clearer to me that I'm much
more of a *creator* than a *consumer*. I do not only create R packages, but also
love creating other things. A good example is I love cooking. I enjoy the
process of creating food. By comparison, I'm not that interested in eating. My
own daily diet is extremely simple.

I also consider myself an observer, more of an *onlooker* than a *player*. That
means I'm often more passive than active. I love observing and sometimes
remembering little things in life. I'm happy to be left alone. I do not mind
being forgotten by other people. If they do think of me occasionally, I'm also
happy.

## What is your favorite song right now and why?

Again, that's a hard question, because I absolutely love songs. I keep my music
player open for about 15 hours every day, and listen to songs as I work or do
anything on my computer. I have listened to at least 20K songs in the last 7
years, out of which I have 1343 favorites so far. It's impossible pick a single
favorite right now. Any pick would be seriously biased. The majority of them are
in Chinese, my native language.

In terms of genre, I do not know why, but overall I like songs that express
sadness and sorrow (by the way, [Sadness and
Sorrow](https://youtu.be/wEWF2xh5E8s) is one of my favorite Naruto soundtracks,
and I like [Grief and Sorrow](https://youtu.be/bbV5Rqru2Lg) even more). [C'est
La Vie](https://youtu.be/rk7dGZuAYXs) and [Tears](https://youtu.be/4ncoei32M-0)
by Chyi Yu are such examples.

I can probably talk about my favorite songs for a whole week. You'd better not
bring up this topic in a short interview.

## What is your favorite thing to do outside of science and/or on the weekends?

I wonder if I have ever been "inside science". I will interpret that as my daily
job. In my spare time, I mostly read, write, cook, and play (badminton). I'm
often on a badminton court for at least 4 hours (without break) on Saturday or
Sunday. Again, please do not make me talk about these hobbies, otherwise I'd
need four more weeks. To make it up a little bit, I can show you [one of my
trick
shots](https://user-images.githubusercontent.com/163582/267533028-e6f5279b-3ac4-457b-90e7-62b9ea22dfaa.mp4)
in badminton.

## What is your favorite food / place to eat / hang out and why?

My favorite food used to be homemade smoked sausage and bacon in my hometown in
China. They are what I craved through my childhood due to great taste and
scarcity. However, after I succeeded in making them by myself in the US, my
interest has become weaker, especially after I greately simplified my diet since
COVID (normally I do not eat meat any more, although I still like it). I still
smoke sausage and bacon every winter, but I give most of them to friends who
enjoy them like the past me. Now I love simple food like potatoes and beans
cooked in any way. I still love spicy food (burning hot if possible). I'm also a
little addicted to all kinds of nuts.

I rarely eat outside now, so I do not have a favorite place to eat.

I love hanging out with a few friends who are also good at cooking. Usually we
either go outdoors (e.g., the Omaha Zoo, lakes, and parks, etc.) for exercise
and wearing out our little ones, or go to someone's house to have amazing
homemade meals. Sometimes we boast that every time we gather together, all top
five chefs in Omaha are present in this house.

## The R/Posit community is super tight knit, how has that benefited you, how did it come to be, and how do we keep it up?

Honestly, I do not think I'm qualified to answer this question since I do not
seem to have enough experience in participating in or managing this community.
As an observer, I'm really glad to see people help each other. The help could be
of multiple forms, e.g., direct help like answering questions, or indirect help
like encouragement. Personally I have benefited a lot from this helpful
community, because I do not have enough time to help people even with problems
related to my own packages, and I truly appreciate other people standing up and
offering help.

I do not really know how the tight knit community came to be. My posit[^1] is
that R is a quite different language (by statisticians, for statisticians), and
users are probably not traditional programmers. I do not know how much time
"traditional programmers" still devote to [language
wars](/en/2018/11/english-is-hard/), but I guess R users might care less about
those wars and want to get the job done.[^2] Another possible reason is that
since most R users are probably not typical programmers, they could think better
in the shoes of beginners, which means greater empathy---a key for a tight knit
community.

[^1]: Wow, I have finally tried to use this word for real.

[^2]: Wars definitely exist in the R community, but the scale is less
    overwhelming. Is that because the R community is relatively small compared
    to other language communities, and language wars just became package wars? I
    do not know.

How do we keep it up? I think other people can offer better advice than me, and
I just want to share a thought that might be overlooked: I do not feel a
community that is too tightly knit is a good thing. In other words, we need to
be careful about the balance, which is an art (hence tricky). We certainly do
not look forward to an R community that leaves no space for other languages. A
healthy community always need all sorts of nutrition. It is great that we are
nice to each other inside the community, but it will be even better if we are
nice and open-minded to people outside the community. It's okay for other people
to use a different tool or language that appears suboptimal or even inferior to
you. Even if you feel they are going to shoot themselves in the feet, it may be
fine for you to sit back and watch them shoot.

> "Man desires a world where good and evil can be clearly distinguished, for he
> has an innate and irrepressible desire to judge before he understands."
>
> ---Milan Kundera, "The Art of the Novel"

Good and bad software tools are often not so clearly distinguished, either. That
said, I admit that sometimes I have this "irrepressible desire", too.
