---
title: 'The Upcoming knitr v1.44: More Compatible with Quarto, and Locking `opts_current`'
date: '2023-09-07'
slug: knitr-1-44
---

Update on 2023-09-12

:   **knitr** v1.44 is on CRAN now and I realized that locking `opts_current`
    might be a nontrivial breaking change (sorry about that). If your code or
    package is affected by the locked `opts_current` object and you run into an
    error "*The object is read-only and cannot be modified*", you can call
    `opts_current$lock(FALSE)` to unlock it before you call
    `opts_current$set()`. I assume that you are modifying `opts_current` for a
    legitimate reason.

After coming back from [vacation](/en/2023/06/on-vacation/), I mainly spent my
time on the **knitr** package maintenance. I will make a new release soon, and
want to quickly highlight a few things in this post. For the full list of
changes, please read the
[NEWS.md](https://github.com/yihui/knitr/blob/master/NEWS.md) in the GitHub
repo.

## Working better with Quarto

The last version of **knitr** (v1.43) broke HTML Widgets in Quarto, which seems
to have affected several users (sorry about that). This version has fixed the
problem.

```         
Error in `add_html_caption()`:
! unused argument (xfun::grep_sub("^[^<]*<[^>]+aria-labelledby[ ]*=[ ]*\"([^\"]+)\".*$", "\\1", x))
```

Other relatively minor improvements are:

-   `spin()` supports the `qmd` format now, which is essentially the same as
    `Rmd`.

-   The correct type of progress bar will be used when rendering Quarto
    documents in RStudio's background jobs or build pane.

-   All dashes in known **knitr** chunk option names will be automatically
    normalized to dots internally. Previously this job was done on Quarto's
    side, but Quarto may miss certain chunk options. This change shouldn't
    affect average users, but advanced users and developers may need to pay
    attention. For example, in **knitr** hooks, you should always use dots in
    chunk option names if the names are built-in in **knitr**. There are chunk
    options that are specific to Quarto, and these names will *not* be
    normalized, e.g., `fig-responsive`.

## Locking `opts_current`

It has been documented for long that `knitr::opts_current` is assumed to be
read-only, but some users still modify it via `opts_current$set()`. To prevent
the accidental modification, this object will be locked when evaluating the code
chunks. If you call `opts_current$set()` inside a code chunk, you will get an
error.

I'd welcome any feedback on any of these changes. Thank you!
