---
title: The Status of the DT Package
date: '2023-05-15'
slug: dt-status
---

My first job at RStudio (now rebranded to Posit) was to integrate the JS library
[DataTables](https://datatables.net) into [Shiny](https://shiny.posit.co). That
was in 2013, almost ten years ago. To be honest, I have never been highly
interested in tables, and working on tables was just a random start of my
professional career. Since DataTables was quite a complex library and many of
its features could be useful outside Shiny, we decided in 2014 to make a
standalone package based on the [HTML Widgets](https://www.htmlwidgets.org)
framework. That's how the **DT** package was born.

Unfortunately, as I maintain more R packages over the years, I have found it
more and more difficult to actively maintain **DT**. In 2020, someone emailed me
this XKCD cartoon and said it reminded him of me:

[![Dependency
(XKCD)](https://imgs.xkcd.com/comics/dependency.png)](https://xkcd.com/2347/)

He thanked me and said "I think you live in Iowa but still". The funny thing is
that I actually do live in Nebraska! I have worked on some infrastructure
packages like **knitr** and **rmarkdown**, but I cannot take so much credit as
depicted by the cartoon. That said, my work style is similar to the supporting
pole in the cartoon---I often work on my own. I do [collaborate with other
people](https://yihui.org/en/2019/07/romain-lesur/), and have merged many pull
requests on GitHub, but most of the time, I still work on my own.

For the **DT** package, the last time I worked substantially on it was [five
years ago](/en/2018/01/back-to-dt/). I have been fortunate to have [a few
volunteers](https://github.com/rstudio/DT/graphs/contributors) helping me from
time to time to maintain this package (notably
[\@shrektan](https://github.com/shrektan) and
[\@stla](https://github.com/stla)). I have asked a few times inside Posit for
the possibility of a new maintainer, but no one seems to be interested, so I
have to carry on.

I'm writing this post to set expectations: unless someone can commit to
maintaining this package, it will enter the maintenance-only mode, meaning that
I will not add substantial new features to it anymore. However, if anyone wants
a new feature that is not too complicated and implements it via a pull request,
I can probably review and merge it. The same thing applies to bug fixes (unless
it's a really bad bug, in which case I will still try to fix it by myself).

There are [many R
packages](https://bookdown.org/yihui/rmarkdown-cookbook/table-other.html) for
generating tables, but I feel **DT** offers two unique features that are not
straightforward in other packages yet: [server-side
processing](https://rstudio.github.io/DT/server.html) and [table
editing](https://rstudio.github.io/DT/#table-editing). Some features from
[DataTables extensions](https://rstudio.github.io/DT/extensions.html) may also
be unavailable in other packages.

Please rest assured that **DT** will not die anytime soon. It will stay on CRAN
for the years to come. It's just that before a new passionate maintainer takes
it over from my shoulders, you may not expect any exciting new features from
this package. If you believe no news is good news, this is good news for you.

P.S. A few months after I received the XKCD cartoon, my son, who didn't see the
cartoon, happened to make this toy using mega blocks at home, which I found
quite funny:

![Dependency (Mega blocks version)](https://user-images.githubusercontent.com/163582/238486514-eaf186bd-7bf1-41c1-b545-2ebc34be589d.jpg)
