---
title: Using GitHub Actions as Free Virtual Machines to Debug R Problems on Different Platforms
date: '2022-12-21'
slug: gha-debug
---

As a developer, my work machine is a Macbook, but I often need to debug R
problems on other platforms. Over the years, I have been using tools like
VirtualBox and VMware to install different operating systems and run them on my
Macbook. I noticed that Windows on VMware required more and more memory. I have
16Gb memory in total and must give VMware at least 10Gb to run Windows. I'm not
sure if I should blame it on VMware or Windows, but this definitely slows down
my computer when I start up the virtual machine.

One or two years ago, I found the GitHub action
[mxschmitt/action-tmate](https://github.com/mxschmitt/action-tmate), and I have
used VMware less and less since then. With this simple action, you can debug
problems on any platform that GitHub Actions support, including Windows, macOS,
and Ubuntu. Of course, you can debug R problems, too.

I have created an example repo [yihui/tmate-r](https://github.com/yihui/tmate-r)
to show how to set up a GitHub action
[`.github/workflows/debug.yaml`](https://github.com/yihui/tmate-r/blob/main/.github/workflows/debug.yaml)
that first installs R, Pandoc, and TinyTeX, and then uses the `tmate` action, so
that you will be able to `ssh` into the GitHub action's virtual machine (or
click the link to the web shell) to debug R problems. You can change the `os` in
the `config` to `ubuntu-latest`, `windows-latest`, or `macOS-latest`, depending
on which platform you want to debug on. Similarly, you can also change the R
version to `devel`, `release`, and `oldrel-1`, etc., so you can debug with
different versions of R. Most of the time I use the `devel` (i.e., development)
version because I don't want to install it on my own computer, and CRAN problems
in my packages are mostly likely to arise in the `devel` version of R.

Note that you can use the `tmate` action inside any of your existing GitHub
actions. You don't have to create a separate repo like I did above.

## An example of debugging with the `ISO-8859-15` locale

A recent problem I tried to debug was that a reverse dependency of **knitr**
failed to pass `R CMD check` on CRAN's Debian machine. This machine has a
special locale `en_US.iso8859-15`. I could not reproduce the problem on my
macOS, but it must be because I was not using the `devel` version of R. I
started a Ubuntu machine with the GitHub action. It took me quite a few hours to
figure out how to set up the locale correctly:

``` bash
sudo locale-gen en_US.ISO-8859-15

# then start R with this locale
LANG=en_US.ISO-8859-15 R
```

That is, I spent a few hours and finally figured out that I needed `ISO-8859`
instead of `iso8859`... On [the CRAN
page](https://cran.r-project.org/web/checks/check_flavors.html), the `LC_CTYPE`
is `en_US.iso885915`, which I also tried and failed. I don't know if this is
difference between Debian and Ubuntu. I'm writing down this note in case any
other poor package author run into the same problem.

## Another example about symlinks on Windows

Yesterday I used the Windows machine to debug a symbolic link problem, and found
that `file.symlink()` works on GitHub's Windows machine but fails on CRAN's
machine. Again, I have no idea why that's the case, but I'm just writing down a
note here.

## A caveat on Windows

I'm not sure why, but if you run `R` on Windows there, the CRAN repository is
not set up as expected (this is probably a problem with the shell). You have to
set it up by yourself, otherwise `install.packages()` can hang your session and
there is no way to quit from the shell. You will need to cancel the GitHub
action. To avoid that, you may run this first:

``` r
if (identical(getOption('repos'), c(CRAN = '@CRAN@')))
  options(repos = 'https://cran.rstudio.com')
```

## Summary

You don't have to buy virtual machine tools, or a copy of a certain operating
system (Windows), or a Macintosh computer to debug problems on other platforms.
Run a GitHub action, and wait for the `tmate` session to be set up in the GitHub
action log. Then all you need is a terminal to run `ssh` or just click the link
to use the web shell in your browser (press `q` when you first log in). You have
about six hours, which may be enough for most problems. After you finish
debugging, be sure to log out so not to waste GitHub's resources.
