---
title: 'blogdown v1.6: Support for the `config/` Directory, and Improvements in `install_hugo()`/`new_post()`'
date: '2021-11-12'
slug: blogdown-v1-6
---

Version 1.6 of blogdown was released to CRAN earlier this week. Although you can
learn about all changes in [the release
notes](https://github.com/rstudio/blogdown/releases/tag/v1.6), I'd like to
quickly highlight a few things here:

## The `config/` directory

As some of you may know, Hugo supports the config file (`config.yaml` or
`config.toml`) under either the root directory of the website project or the
`config/_default/` directory, which has the advantage of storing multiple config
files in one place. Previously, **blogdown** only supported the former case. Now
the latter case is also supported (thanks to the motivation from [Athanasia and
Maëlle](https://github.com/rstudio/blogdown/issues/611)).

This means now you can move the config file from the root directory to the
`config/_default/` directory if you prefer. Note that if the config file is
present in both places, **blogdown** can only recognize the root-level config,
so if you really intend to use the config directory, you need to remove the
root-level config.

## Version `X.Y` or `X.Y.0`?

It has been a common mistake for users to specify a version number that omits
the `.0` component, e.g., the Hugo version `0.87` does not exist, and only
`0.87.0` does. Now `blogdown::install_hugo()` can detect this mistake and
automatically add `.0` to the version number (with a message).

## Specify `os` and `arch` in `install_hugo()`

The `install_hugo()` function has gained two arguments `os` and `arch` so that
you can specify the operating system and architecture by yourself, if the
automatic guess fails. For example, `install_hugo()` does not support FreeBSD by
default, but you can tell `install_hugo()` to install Hugo for your 64bit
FreeBSD via:

``` r
blogdown::install_hugo(os = 'FreeBSD', arch = '64bit', extended = F)
```

This will download `hugo_*_FreeBSD-64bit.tar.gz` from
<https://github.com/gohugoio/hugo/releases> and install it.

## Available Hugo installers via `hugo_installers()`

Again, if `install_hugo()` fails to detect your `os` and `arch`, you may check
which `os` and `arch` Hugo actually supports via `blogdown::hugo_installers()`.
It has a `version` argument, which defaults to the latest version of Hugo. The
output looks like this:

| version | os           | arch  | extended |
|:--------|:-------------|:------|:---------|
| 0.89.2  | DragonFlyBSD | 64bit | FALSE    |
| 0.89.2  | FreeBSD      | 64bit | FALSE    |
| 0.89.2  | Linux        | 32bit | FALSE    |
| 0.89.2  | macOS        | ARM64 | FALSE    |
| 0.89.2  | NetBSD       | 64bit | FALSE    |
| 0.89.2  | OpenBSD      | 64bit | FALSE    |
| 0.89.2  | Linux        | 64bit | TRUE     |
| 0.89.2  | macOS        | 64bit | TRUE     |
| 0.89.2  | Windows      | 64bit | TRUE     |
| ...     | ...          | ...   | ...      |

After you find an installer appropriate for your operating system, you can pass
the corresponding `version`, `os`, `arch`, and `extended` arguments to
`install_hugo()` to install it.

## Changes in `new_post()`

There were two changes in `blogdown::new_post()`. First, the default post
filename will no longer contain non-alphanumeric characters. Previously,
multibyte characters might not be excluded when generating the filename, and now
they will be excluded by default.

Second, if you do want to include multibyte characters in the filename (e.g.,
you can type such characters in the "New Post" addin in RStudio), they should
work correctly now. Previously `new_post()` could fail on Windows.

## Changes in previous versions of blogdown

V1.5 [added](https://github.com/rstudio/blogdown/issues/625) a global option
`blogdown.time` and if you set `options(blogdown.time = TRUE)`, the local time
will be added to the `date` field of a new post when it is created via
`new_post()`. The `date` field will like this:

``` yaml
---
date: 2021-11-10T15:50:34-0600
---
```

Why do you want to add time to the date? This is to avoid the ambiguity of the
date. A date without time and timezone info is ambiguous, which can cause a
build problem. For example, if you write and publish a post at 10am on
2021/11/10 in the timezone GMT+8, and the server that builds your website is in
the timezone GMT-6, Hugo on the server will think the post date is in the future
(the server date is still 2021/11/09 and the time is 8pm there). As a result,
Hugo will not build this post by default, unless you use the `--buildFuture` or
`-F` flag [in the command](https://gohugo.io/commands/hugo/) to force Hugo to
build future posts.

This problem can be extremely difficult for people to debug (even
`blogdown::check_site()` cannot help), because there are not build errors in
this case, but your post just will not show up. If your timezone is ahead of
your server's (e.g., Netlify or Vercel), you may want to consider either setting
this R option, or use the `-F` flag in the command.

![Why does not Hugo build my post?!](https://slides.yihui.org/gif/lost-key.gif)

V1.4 added [support](https://github.com/rstudio/blogdown/issues/636) for
machines with ARM chips in `install_hugo()`.

You can always learn about all changes in **blogdown** in its release notes at
<https://github.com/rstudio/blogdown/releases>.
