---
title: 'crandalf: Use GitHub Actions to Check Reverse Dependencies of an R Package'
date: '2021-06-03'
slug: crandalf
---

Three years after the **knitr** package was created, it had gotten hundreds of
reverse dependencies on CRAN, which brought a painful problem to me. That is, I
had to check a large number of reverse dependencies each time before I submit a
new version of **knitr** to CRAN, to make sure the new version would not break
packages that depend on **knitr**. To check these packages, I had to install
their R package dependencies as well as system dependencies. The latter was
especially tricky. In short, this process was both complicated and
time-consuming for me, not to mention the anxiety about possibly getting a CRAN
notification telling me that they discovered a breakage in my reverse
dependencies that I failed to discover in advance for some reason.

## Initial experiment with Travis CI in 2014

In 2014, I created [a GitHub repo named
**crandalf**](https://github.com/yihui/crandalf). The idea was to check the
reverse dependencies in parallel on Travis CI. I experimented with several ways
to avoid the job timeout (20 or 40 minutes, I do not remember now) when the
number of packages to check is large. I think I succeeded finally, but the
problem of installing dependencies was nearly impossible to solve completely.
Since I was too worried that I could fail to discover a breakage because a
certain dependency was not successfully installed, finally I decided to give up
and just run all checks locally on my own computer, which means I had to figure
out and install some system dependencies manually, and the fan of my computer
would have to blow out hot air for hours each time.

That said, this initial experiment should work fine for packages that do not
have a huge number of reverse dependencies. A few users actually tried it by
following the instructions to check their own packages on Travis CI.

The code I wrote at that time was not wasted, either. I pulled it out to the
function `xfun::rev_check()` later, which I have used regularly by myself over
the years.

## New experiment with GitHub Actions in 2021

Late last year, Travis CI [changed their pricing
model](https://blog.travis-ci.com/2020-11-02-travis-ci-new-billing), which means
its resources became much more limited than before. As a result, GitHub Actions
became a more attractive option. For example, the job execution time limit is 6
hours.

In February this year, Terry Therneau [filed an issue to the crandalf
repo](https://github.com/yihui/crandalf/issues/7), asking if it was still
active. Since I was still relatively new to GitHub Actions, I thought it might
be a good opportunity to learn more about it. After a few days' work, I managed
to transition from Travis CI to GitHub Actions. Thanks to the generous 6-hour
limit, I was actually able to check the reverse dependencies of **knitr** in a
single job.

[The TL;DR in the repo readme](https://github.com/yihui/crandalf) has explained
the simple usage for package authors who only need to check a moderate number of
reverse dependencies. For authors who have to deal with a large number of
reverse dependencies like me, you may need to read the full readme, but I guess
you must have already gotten your own solution to this problem, so this repo may
not be really useful to you.

## Conclusion

Through using this repo for about three months, I did discover a few small
breaking changes in some of my packages before CRAN submission, so it has been
useful to me. In the past few months, I have not heard the fan of my computer
blow like crazy overnight again.

Given my still limited knowledge about GitHub Actions, I'm sure that crandalf,
as a relatively quick experiment of mine, is not the optimal way to solve this
problem, and I'm open to suggestions and feedback. Please also feel free to
[fork the repo](https://github.com/yihui/crandalf) and tweak or improve as
necessary to better check your own packages.
