---
title: What Does it Mean When Your GitHub Issue is Closed, and What Can You Do?
date: '2021-03-21'
slug: issue-closed
---

After using GitHub for a little over a decade, I have encountered a handful of
people who could become angry after I close their GitHub issues without
fulfilling their requests. Since I'm more concerned about the people who were
similarly disappointed but silently walked away, I want to explain in this post
what I mean when closing an issue, to clarify the potential misunderstandings.

Usually I try hard *not* to close issues without a response. I did close a few
out of the thousands of issues that I have dealt with over the years, but these
ones were often far below the minimum requirements, e.g., an issue with no
content but only a brief title that I don't completely understand, or [an
issue](https://github.com/rstudio/blogdown/issues/408) asking [a random
question](https://github.com/rstudio/blogdown/issues/409) that is completely
irrelevant to the GitHub repo. Normally I do not even close issues right away
that lack minimum reproducible examples, although that requirement is mentioned
in the issue guide and should be seen when a new issue is opened.

The most common reason why I close issues without fulfilling the original
requests is the combination of the two conditions below:

1.  I don't see any hope that I (or my team) would have time or resources to
    resolve the issue in the foreseeable future. No one has an infinite amount
    of time, and at some point you must set priorities. By definition, setting
    priorities has to offend or hurt or sacrifice someone. This has become even
    worse for me personally since the pandemic, since my time has become even
    more limited. I guess this is also true for most people in the world. At
    RStudio, we can take as much time off as we want, but the fact for me is
    that I rarely feel comfortable with actively taking a break because of the
    endless work, so my usual breaks have been sick leaves. I will save this
    topic for another post in the future.

2.  There exists a workaround. Normally [I hate blocking users'
    ways](/en/2018/11/two-roads/) and will try to leave other ways open. That
    means you may have workarounds, even though they may not be straightforward.
    However, even with workarounds, I was still called a "dictator" a while ago
    by someone when an issue was closed. I thought dictators would not give you
    options...

In short, when I don't have time, and the workaround is not awfully bad or
complicated, I tend to close the issue, so I can move on to other issues---there
are so many after all. A closed issue does not necessarily mean that it is
invalid, but often means that it is not manageable under all the constraints.

However, it is possible that my evaluation of the workaround is wrong. It might
be okay or easy in my eyes, but bad or complicated in your opinion. Therefore I
don't mean that once an issue is closed, the request is denied forever. You
could continue to argue and I could reopen it later. Sometimes I do make
mistakes in my judgment, and sometimes you may have walked into my blind spots.
I'll be happy to reconsider the requests or correct my mistakes [even years
later](https://github.com/yihui/knitr/issues/954).

So you may need some persistence if you feel I really missed anything in your
request. BTW, if you want to learn what a terribly stubborn person I am, check
out the [hugo issue \#3632](https://github.com/gohugoio/hugo/issues/3632)
(perhaps someday I'll just give it up, since I've already found a workaround in
**blogdown**).
