---
title: My First Uncoast Unconference in 2019
date: '2020-02-24'
slug: uncoast-unconf
---

When Sam emailed me about this idea of "uncoast unconference" in November 2018, I replied her email within five minutes with "Yes! And Yes!" I don't usually reply emails so quickly, but I had wished for a Midwest R conference for years.

Born in a poor family, I have always been a frugal person, even though I don't consider myself poor any more. On the other hand, I usually don't like traveling, either (especially by air, which is often time-consuming and costly). Sam explained the motivations of the uncoast unconference [in her blog post](https://sctyner.github.io/uncoast-unconf.html), and the travel cost is one of them.

I drove from Omaha to Des Moines for a little over two hours, and attended my first unconference in April 2019. I should have written this post after I came back, but haven't had a chance. In the past few days, I saw the announcement of the [2020 Uncoast Unconference](https://twitter.com/UUnconf/status/1229796050392829953), and thought I should write down some reflections before I completely forget this event. I'm sure I have forgotten many things, and this post is my attempt to recall the rest of them from memory:

- I liked this unconference a lot. One of its striking differences with all other conferences was the food---nothing fancy about the meals or snacks. As Sam mentioned in the post "[The Five P's: Make the Most of Professional Conferences](https://www.aaaspolicyfellowships.org/blog/five-ps-make-most-professional-conferences)":[^1]

    > Conferences tend to provide a lot of snacks, but they are often things like sweets and muffins. 

    To be honest, personally I wish all conferences (including rstudio::conf) _not_ to provide snacks during breaks. The extra calories are absolutely unnecessary for me. The breakfasts and lunches are often already too good to me. Normally I'm able to control my desire for snacks, but I hate that I have to control it. I'd rather they don't exist in the first place.

- I remember Sam mentioned at the last day's dinner that she wanted the attendees to "have the full Iowa experience". I don't take pictures very often, but I took this boring one from my hotel room:

    ![The hotel in which I stayed during the unconfernce](https://user-images.githubusercontent.com/163582/75079989-496c8180-54d0-11ea-993e-fc57a37c2928.jpg)

    I love this feeling of living in the woods. There is no doubt that I enjoyed the "Iowa experience". During the icebreaker session before the unconfernce, Sam asked us if we loved the Midwest. Craig (Van Pay), a student at Iowa State, told me the criterion to check if someone truely loves the Midwest was whether he/she loves Ames. I absolutely do. Even Omaha is too big to me. I love small villages.
    
    [![Craig and me, chatting about Ames at the door](https://pbs.twimg.com/media/ESMGdH-WAAQby6s?format=jpg&name=large)](https://twitter.com/CKVanPay/status/1234839299696119809)

- I gave a crash course on HTML/CSS/JS on Day 0. I didn't prepare the slides and just talked leisurely, since I was busy preparing the next three days' meals for my family in the morning before I left (and they ordered pizza instead when I was away...). I thought I taught the tutorial quite poorly, but later I found [Amelia's notes](https://uncoast-unconf.github.io/uu-2019-day-zero/04-html-css-js/Amelias-notes.html), and I was astonished by how well she recorded what I mumbled at the podium.[^2]

- I discovered there was a ping pong table outside the conference room, and remembered someone said in her self-introduction that she liked playing ping pong. Eventually I found it was [Ranae Dietzel](https://ranae.github.io). We played for about half an hour until other people started presenting their projects. Ranae's ping pong skills were quite impressive! BTW, Laura Ellis just discovered [Ranae's tweet about **patchwork**](https://twitter.com/RanaeDietzel/status/1228877735663194112) last week, and I think [Laura's tweet](https://twitter.com/LittleMissData/status/1229176433123168256) has become the single most viral #rstats tweet in history!

- I promised [Taras Kaduk](https://twitter.com/taraskaduk/status/1118591910384476160) that I'd write a blog post about this unconference, and finally here I am! I wrote the prototype of the **rolldown** package in a couple of hours, which surprised a few people because the productivity seemed to be too high. For this package, the prototype was easy for me because (1) I was familiar with the [HTML Widgets](https://bookdown.org/yihui/rmarkdown/html-widgets.html) framework, and (2) the [scrollama library](https://github.com/russellgoldenberg/scrollama)'s API was relatively simple. Prototyping is often the easiest stage of developing a package. There will often be mountains of work in later stages. I was unable to afford more time on developing this package, so it should still be considered a prototype even if I have released an initial version to CRAN.

    ![Presenting rolldown at the 2019 uncoast unconference](https://pbs.twimg.com/media/D4TaN5BWkAEr6Yk?format=jpg&name=medium)

- In terms of productivity, I think the key is always to focus. Or in other words, to manage distractions. The unconference gives you a unique chance to hack on something for two days. When you are working with a group of peers side by side, it will be embarrassing if you continuously check email or social media. We do not need a huge amount of time to be productive---we do need an uninterrupted chunk time (it could be only two hours). During the unconference, I was only distracted by [one thing](https://juliasilge.com/blog/datacamp-misconduct/) on the first evening, and lost a couple of hours on it. Other than that, I was pretty much focused on the **rolldown** package.

- Sam asked us several questions in the icebreaker session and we stood by different sides of the room according to our answers. One question was "do you say coke or soda?" I decided that I would form my own group and not go with anyone else in the room because Chinese say neither coke nor soda. We actually say "Cola". I thought I'd be unique, but to my great surprise, my PhD advisor Heike also joined my group. "Of course it is Cola!" The German said.

- It was great to catch up with some old friends such as my classmate Karsten Maurer and some RStudio colleagues at this unconference. I was also acquainted with a new friend there, Siqi Zhang. He was an interesting person, also helpful and enthusiastic. On our way back to the hotel, he basically wrote the [**R6**](https://cran.r-project.org/package=R6) package with his tongue while sitting on the passenger seat in my car, without knowing the existence of **R6**. Five minutes later, I congratulated him on reinventing **R6**.

- Sam felt so excited when delivering the closing remarks on the last day that she couldn't help crying in full joy. Yes, it was absolutely wonderful for these great people to get together and hack on interesting projects for two days. I really want to thank all the organizers, especially the other Sam (Helmich).

I don't plan to attend this unconference this year, but I recommend that you do. I don't think you have a lot of chances to isolate yourself from the rest of the world for a couple of days and focus on coding with a group of people. Meanwhile, this year's Day 0 workshop will be led by Amelia McNamara, the most amazing note-taker I mentioned above, and Ian Lyttle, [the nicest person on the Internet](https://twitter.com/AmeliaMN/status/1222990245991313408). The application deadline is approaching, so I encourage that you apply soon: https://uuconf2020.rbind.io.

[^1]: In the picture in this post, you can see me in the jacket that I have worn for several years. When I appear in pictures with a jacket, I'm almost always in this jacket.

[^2]: On a weakly related note, I was [also surprised](https://twitter.com/xieyihui/status/1230158493614837763) by the pronunciation of "sew" in [her rstudio::conf talk](https://resources.rstudio.com/rstudio-conf-2020/lightning-talk-dr-amelia-mcnamara) this year.
