---
title: Is that a Mickey Mouse Blowing a Trumpet?
subtitle: I still don't understand the popularity of emoji...
date: '2020-02-17'
slug: on-emoji
---

At one dinner last year, my 4-year old looked at the table and said "there is a Mickey mouse on the table." I was confused at first. We didn't have a Mickey mouse toy at home at all. We only had a few music books that had the Mickey mouse in them. Apparently there was no Mickey on the table. Should I take him to see the doctor to cure his illusions?

He pointed his finger at three bowls that I put against each other on the table. One big bowl, and two smaller bowls. Oh... Okay. A Mickey mouse it was indeed.

I'm not as good as my little kid at recognizing shapes. Although it seems emojis are extremely popular nowadays, I often fail to figure out what they mean. They are as hard to decipher as [oracle bone scripts](https://en.wikipedia.org/wiki/Oracle_bone_script). Sometimes I also don't understand why they have to be used at all, since the alternative way seems to be much clearer, i.e., writing in text instead of pictographs. Are we so bored by our current writing system? Why are we so interested in going back to a writing system in [3000 BCE](https://en.wikipedia.org/wiki/Hieroglyph)? I have many examples in my mind for this post, but here is a recent one (with my apologies to Emil---I didn't mean you specifically):

![Emojis used in the list of talk materials at rstudio::conf](https://user-images.githubusercontent.com/163582/74670660-40e21700-516f-11ea-88e2-6bf032dc295e.png#border)

Huh. This time I'm sure I saw a Mickey mouse. And it was blowing a trumpet! Suddenly I felt so proud of my eyes and imagination---as if my kid said, "Good job, Daddy!"

![The movie camera emoji, which I thought was a Mickey mouse](https://user-images.githubusercontent.com/163582/74667748-7c79e280-5169-11ea-969e-f2debd7630b3.png)

Whenever I fail to understand an emoji, I right-click on it in my web browser, and inspect the element. In "Developer Tools", I saw:

```html
<g-emoji class="g-emoji" alias="movie_camera"
  fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f3a5.png">
  🎥
</g-emoji>
```

Alright. It was not a Mickey mouse, but a movie camera. How about the rest of emojis?

| emoji      | actual meaning | what I thought it meant |
|------------|-----------|------------|
| :star2:    | title of the talk | bling bling! shiny! twinkle twinkle little star, how I wonder what you are? |
| :speaker:  | speaker | the top half of a snap fastener |
| :link:     | link | link |
| :scroll:   | slides | a raw spring roll wrap, ready to be filled with sausage, shrimp, mushrooms, and bean sprouts... yummy! |
| :movie_camera: | video recording | a Mickey mouse blowing a trumpet |

Except the Mickey mouse, I was mostly kidding above. I was able to figure out what these emojis meant in the context. In, the, _context_. Then why is it worth the trouble?

- For authors, they have to take the time to find the appropriate emojis. They translate the text to symbols.

- For readers, they have to decipher the symbols, i.e., they translate the symbols back to text.

This reminds me of [a quote](http://www.quotationspage.com/quote/40151.html):

> Writing well means never having to say, 'I guess you had to be there.'
>
> --- Jef Mallett, Frazz, 07-29-07

In some cases, using emojis means 'I guess you have to read my mind.'

Of course, I'm not that extreme. I'm fine with common smileys, and I use them very often, too, but I never feel it is an obligation to use them. :smile: :joy:
