---
title: Back from rstudio::conf(2020)
subtitle: My talk, Q&A's, and other conference experiences
date: '2020-02-06'
slug: rstudio-conf-2020
---

Wait a minute. I thought I just wrote the blog post "[Back from rstudio::conf 2019](/en/2019/01/rstudio-conf/)" not long ago. A whole year has passed?! I cannot believe it has been so long since I wrote a blog post last time. In this post, I'll share some experiences as well as the materials of my presentation at the conference.

## My talk: One R Markdown document, fourteen demos

**TL;DR** You can download the R script I used in the talk here: [2020-rstudio-conf-rmarkdown-demo.R](https://slides.yihui.org/2020-rstudio-conf-rmarkdown-demo.R). Note that it will try to automatically install the required R packages and download files required for the demos. If you want to run the script by yourself, I suggest you run it in a new directory to avoid cluttering your current working directory. You can find the video of this talk on [resources.rstudio.com](https://rstudio.com/resources/rstudioconf-2020/one-r-markdown-document-fourteen-demos/).

I presented fourteen demos based on the same R Markdown document in my talk. The goal was to show that a relatively simple R Markdown document can generate a large variety of output document formats, some of which can look quite sophisticated.

The idea for this talk originally came from my remote talk for the 2019 RaukR summer school in Sweden, in which I presented a series of R Markdown demos to show the versatility of R Markdown, but I used different R Markdown documents in that talk. BTW, I also met the organizers Marcin Kierczak and Sebastian Dilorenzo at rstudio::conf this time, and we "complained" together about how little kids made it so difficult for their parents to travel. They also brought a T-shirt of the summer school to me all the way from Sweden, to which I was very grateful.

At JSM 2019, I gave another talk on the R Markdown ecosystem, and decided to use the same R Markdown document. I put all output formats in the YAML metadata, and clicked the `Knit` button 14 times during the talk, which was a little awkward, because I had to look closely at the output formats and think which one would be the next one to present. It was not easy to do this in front of the audience when the time for the talk is short (20 minutes).

This time I decided to automate it as much as possible, so I wouldn't have to spend time on thinking about which output format to present next. With [my experience at rstudio::conf(2018)](/en/2018/02/typing-fast/), I wrote an R script to automatically insert the `output` field into the R Markdown document in RStudio using `xfun::rstudio_type()`. With a `for`-loop iterating over all output formats, and a call to `readline()` at each step of the loop, I managed to present these output formats one by one. All I had to do was to keep pressing `Enter`, and the audience would see something like this being dynamically "typed" into my RStudio IDE:[^1]

[^1]: If you are curious about how the "typing effect" was implemented in this blog post, view its HTML source and look for the JS code below the `<pre>` tag.

```yaml
output:
  html_document:
    number_sections: true
    theme: journal
    toc: true
```

<script>
(function() {
  var el = document.querySelector('pre > code');
  el.style.height = el.offsetHeight + 'px';
  var tx = el.innerText;
  setInterval(function() {
    var n = el.innerText.length;
    el.innerText = n < tx.length ? tx.slice(0, n + 1) : '';
  }, 50);
})();
</script>

Again, you can find my R script at the beginning of this section. Keep in mind that it has to be executed in the RStudio IDE.

In retrospect, my tone in the talk was perhaps too disparaging on LaTeX, Word, PowerPoint, and LaTeX beamer. Here I want to apologize to whomever felt hurt by my silly comments (sometimes I have no idea what I'm talking about on the podium). I always say I'm tired of beamer slides, but beamer is actually extremely powerful. The only issue is that too many people use more or less the same beamer theme. I'd be equally tired of **xaringan** slides if I see the same theme over and over again.

## Q&A's on my talk

Due to the time limit, I wasn't able to answer all questions on sli.do. Now I'll answer them below, in case the askers are still interested.

- **Q: What's the updog app?**

    A: I had no clue how this person noticed Updog, because I didn't mention Updog in my talk at all. When I heard this question, I was totally confused. A whole week later, I suddenly realized that my demo files were in my Dropbox folder, and one folder name was "updog"! What sharp eyes! Later [Taras Kaduk told me on Twitter](https://twitter.com/taraskaduk/status/1222974644833017856) that I missed a great opportunity to honor the traditional "Nothing much, what's up with you?" Anyway, [Updog](https://updog.co) used to be a great service to host static websites in Dropbox, but unfortunately it is down now (again, not my fault!).

- **Q: How do you get the search box for a data frame in rmarkdown?**

    A: I used [the **DT** package](https://github.com/rstudio/DT).

- **Q: How did you get the pacman animation to work in PowerPoint?**

    A: The pacman was a GIF created [with **gifski**](/en/2018/08/gifski-knitr/). GIFs work in the presentation mode of PowerPoint.

- **Q: Did you lose a bet so you had to do your talk the same time as Hadley?**

    A: I didn't realize that Hadley's talk was at the same time as mine until about an hour before my talk. [It was a bummer](https://twitter.com/sharon000/status/1222983977541046273) to some people, but at least the two rooms [wouldn't be too crowded](https://twitter.com/jcheng/status/1223327608219131904). Well, I was especially grateful that my room was not empty after I knew Hadley was speaking in the next room.

- **Q: Is there any way to add a footer in PowerPoint when knitting with R Markdown?**

    A: Not to my knowledge. I don't use Office products myself, and whenever I get questions about Word/PowerPoint that I cannot answer, I'll recommend looking at [**officer**](https://github.com/davidgohel/officer). David Gohel has far more expertise than I do.

- **Q: The direction of the pie chart changes depending on the output format?**

    A: Good eyes! The direction of pacman is actually random to each output format.

- **Q: Do you know or are working in integrating audience interactions in xaringan?** Something related to [sli.do](https://sli.do) / [mentimeter](https://www.mentimeter.com).

    A: I have a few ideas, but I don't know when I'll be able to implement them. Before I do, the easiest way I could think of is to embed an `<iframe>` of a web page on a slide, and all interactions occur on that web page.

- **Q: How much time do you find it takes getting the formatting to look good for HTML outputs?** I find I can get the page looking OK but not great.

    A: A lot of time, if I really want the HTML pages to look good. However, I usually refrain from spending too much time on CSS. I'm a minimalist in both my daily life and my technical world. That said, I can only be a minimalist when I work for myself (e.g., design a theme for my own website). If I design products for others, I will certainly invest more time in the appearance.

- **Q: How do you integrate GIS visualization from ArcGis software into R Markdown document?**

    A: Sorry, but I know nothing about ArcGis. I used the [**leaflet**](https://github.com/rstudio/leaflet) package in my demos to render the map.

- **Q: What is the difference between bookdown vs pagedown?**

    A: The goal of the **pagedown** package is to typeset HTML documents with CSS. HTML is its only output format. PDF is a by-product in this package (printed from HTML). The **bookdown** package supports a variety of output formats, including HTML, LaTeX, Word, and EPUB, etc.

- **Q: Have we solved the issue of overhanging code in code chunks when rendering to PDF?**

    A: I know verbatim content could be wrapped by the LaTeX package **listings**, and Pandoc supports **listings**, too. However, I have never tried by myself. If anyone has tried and succeeded, please let me know and I'll be happy to share a link to your solution. Usually I just hard-wrap the lines by myself.

- **Q: Have you considered calendar based release cycle?**

    A: I have an R Markdown document that runs every two weeks on RStudio Connect to remind me of the packages that I may need to update on CRAN. I may or may not actually update these packages after I see the reminder email. I don't plan to switch to a strictly calendar-based release cycle. On the other hand, I think the base **rmarkdown** package and **knitr** are relatively mature now.

- **Q: Is the markdown document available to download? Can we get your code for your 14 demos?**

    A: Yes, please find the link to the R script in the beginning of the previous section in this blog post.

- **Q: Is there such thing as a googleslide"down"?**

    A: Not to my knowledge, but I'm very interested. I know many people are interested in a product that connects R Markdown with Google Docs/Slides, or an online platform like Overleaf where multiple authors can collaborate. I cannot comment much on this at the moment, but personally I'm definitely highly interested in such products/platforms!

## Rob's talk on how R Markdown changed his life

When I first saw the title of Rob's talk last year, I felt the pressure for my own talk. If someone highly praised R Markdown in a previous talk, what should I talk about so I wouldn't let the audience down?

I could also talk about how R Markdown changed my own life---it has made me incredibly busy day and night for years, and I could not eat or sleep. Just kidding. It did change my life. For example, it brought me a dream job at RStudio, and to some extent, its simplicity turned me to a minimalist.

You can find materials of Rob's talk at http://robjhyndman.com/rmd2020. He reviewed the authoring tools that he had used since he was in kindergarten,[^2] which was a lot of fun because we could hear more and more people in the audience started to recognize those tools as he moved forward in his life path. He told me the night before in the California Academy of Sciences that he was going to show an old Twitter conversation between him and me in his talk, but I had no idea which one it was. Had I not seen his slide the next day, I'd have totally forgotten [that tweet from 2012](https://twitter.com/robjhyndman/status/271112533929238529)!

On his last slide, he showed a picture of me and thanked me. Of course, I felt touched. The funny fact is that the picture was from [my very first talk about R Markdown](https://vimeo.com/94181521) in Seattle in 2014 (at Fred Hutch). If you search for my name with Google Images, this is the first image you get.

[^2]: Well, I don't know if he started using computers in kindergarten, but he did have a cute and handsome picture of himself at that time.

Many thanks to Rob for this very inspiring talk! I'll think about the "maildown" package.

## Book signing

There was a book signing event at the reception on Tuesday evening. It was the first time I had attended such an event. There was also one at rstudio::conf(2019), but somehow I didn't find the place (apologies to those who might have waited for me there).

[Max Held](https://twitter.com/maxheld/status/1221985368657952769) took a picture of the event, which happened to have me on it:

![Signing books at rstudio::conf(2020)](https://pbs.twimg.com/media/EPVdNgAUwAAwi17?format=jpg&name=medium)

Max said it was not a comic conference, yet there were so many people lined up for the books. I felt the same excitement. I really loved the conference, so much that I didn't even care to go to see the Golden Gate Bridge during my stay in SF, although I had never really seen it.

I was in a hurry to drink my beer (kidding), so I became the first one to finish signing the 100 copies of books. [Greg Dubrow](https://twitter.com/greg_dubrow/status/1222235939537215489) was the 100th person coming to my table, and he got the last copy. Behind him was the poor [Yue Jiang](/en/2018/07/yue-jiang/).

Sitting on my left hand side was JJ, the CEO and founder of RStudio. While I was signing the books, I overheard someone who apparently didn't know him and asked him "Do you work for RStudio?"

Heh, heh, heh.

![The CEO of RStudio](https://slides.yihui.org/gif/awesome-me.gif)

## Some people I met

On my plane from Omaha to SFO, my neighbor glanced at my laptop screen and recognized the RStudio IDE. He told me he didn't know much about R, but his wife was an R user. I didn't tell him that I was going to rstudio::conf. However, two days later, my colleague said on Slack that someone asked him if there was an RStudio employee based in Omaha and met her husband on the plane. Huh! I didn't know his wife was also attending this conference! In case any other R users in Omaha are reading this post, here is the link to [the Omaha R User Group](https://www.meetup.com/Omaha-R-Users-Group/).

At the entrance of the California Academy of Sciences, I ran into [Henrik Bengtsson](https://github.com/HenrikBengtsson), whom I had never met before (hence I didn't recognize his face). Henrik has made many valuable contributions to the R community, and is also the unsung hero behind [non-Sweave package vignettes](/knitr/demo/vignette/) in my eyes. If it were not for him, there wouldn't be thousands of package vignettes on CRAN.

Inside the academy, I met many friends whom I hadn't seen for a long while, such as Roger Peng, Hilary Parker, Jeff Leek, and Emily Robinson, etc. I didn't know Jeff started to grow his beard! I forgot to take a picture, otherwise I'd consider adding it to the [`yolo = TRUE`](/en/2019/03/yolo-karl/) collection in **xaringan**. Emily was still such a kind, lovely, and [inspiring](http://lcolladotor.github.io/2020/02/03/conference-feelings-from-newbie-to-sponsor/) soul.

When I returned to the hotel, I was caught by Theresa Henle in the lobby. She attended our R Markdown workshop, and is a very warm-hearted person. Soon we were joined by Carolina Johnson, Ellis Hughes, Jonathan Carroll, and Joshua Goldberg. Ellis was wearing his Halloween costume---a T-shirt with the default R Markdown example printed on it, which I had previously seen [on Twitter](https://twitter.com/ellis_hughes/status/1220006359292235781), but it was fantastic to see it for real. Jonathan just put together [the latest issue of R Weekly](https://rweekly.org/2020-04.html), which was still open in my browser because I hadn't had a chance to read it at that time. We chatted in the lobby for quite a while, and I started to debate to myself whether I should go back to my room to prepare my talk for the next morning, since it was fairly late in the night (past 11:30pm, meaning 1:30am central time for me). I had finished writing that R script, but I hadn't thought about the most important part of the talk---the jokes. Finally I covered Josh's mouth to stop him from talking further, and ran off. Sorry, Josh! BTW, last year Josh [encouraged me to write a non-technical book](/en/2019/01/rstudio-conf/#comment-4307358256), and I definitely still remember it. Still no promises, but I think I'll get there someday since I'm truly interested in writing such a book.

At the conference reception, I met three Japanese: [kazutan](https://twitter.com/kazutan) (前田和寛), [Uryu Shinya](https://twitter.com/u_ribo), and [Kenta Yoshida](https://orcid.org/0000-0003-4967-3831). Kenta was in my R Markdown workshop. I think I have known kazutan for a number of years, but it was the first time I had met him in person. I feel Japanese are born comics. Even when they are in an English environment, they still demonstrate a sense of humor naturally through their face and gestures. I told them that sometimes I'd thumb through the slides of the Tokyo R User Group, and I felt the content was often deeply technical, which was surprising to me. For this conference, apparently they also had [problems with English](https://twitter.com/kazutan/status/1222491746052915201), just like Hiroaki Yutani did [last year](/en/2019/01/rstudio-conf/).

Ian Lyttle told me at the reception that he discovered a bug in **rmarkdown** but decided not to bother me and figured it out by himself. In this case, I wouldn't mind a quick message, since that bug was [simple enough to fix](https://github.com/rstudio/rmarkdown/issues/1756). Anyway, it was so very kind of him!

I still had a few emails that I didn't manage to reply. As a result, I greeted some people with "Hey I'm sorry I haven't replied your email!" That was what I did to Malcolm Barrett when I met him for the first time in front of his poster. I owe the same email debt to Brooke Anderson, and our Mine Çetinkaya-Rundel and Alison Hill.

I had struggled with [an **rmarkdown** issue](https://github.com/rstudio/rmarkdown/issues/1733) related to LaTeX that I was unable to reproduce for a long time. Fortunately, in the week before the conference, Jared Lander reported that he had the same problem, and he would attend the conference, too. Finally I could see the problem on someone's computer for real. [It turned out](https://github.com/rstudio/rmarkdown/issues/1733#issuecomment-582165621) that we only had to update LaTeX packages in MiKTeX. Thanks, Jared, for letting me use your computer for three hours!![^3]

[^3]: It didn't take me three hours to figure out the solution. I was mainly chatting with passersby as I was updating the packages, and the WiFi was fairly slow.

Not surprisingly, I met a couple of more conference attendees at the SFO airport on Friday morning. I could easily tell from their conference T-shirts. Actually one woman was right in front of me as we went through the security, and she recognized the "Markdown guy". On my flight back to Omaha, I saw at least two other attendees on the same plane.

## Naras and Literate Programming

I met [Naras](https://web.stanford.edu/~naras/) on the last day of the conference. He told me R Markdown also changed his life, as well as several other interesting things. One particularly interesting thing was that he actually published [a paper in JSS](https://www.jstatsoft.org/article/view/v004i03) in 1999(!) based on literate programming techniques. He deeply appreciated Knuth's literate programming paradigm, and I absolutely agreed with him that (dynamically) composing a big chunk of code with smaller pieces of chunks was an undervalued idea. I also mentioned the advantages of literate programming in my article "[Write An R Package Using Literate Programming Techniques](/rlp/)". I'm sure there are other papers written with this technique, but Naras's paper is the earliest one to my current knowledge. I haven't met many true fans of Knuth's literate programming. Naras and Terry (Therneau) are the only two that I know.

## Some frequently asked questions to me

In case anyone else is interested, I'm listing some FAQ's below according to my experiences at the conference.

- **Q: Where are you based?**

    A: I'm in Omaha. (People often continue to ask why since it seems to be unbelievable that anyone would like to live in Nebraska, and the reason is that my family is here.)

- **Q: What's the headquarter of RStudio?**

    A: I don't think we have an official headquarter, but I'd say Boston anyway, since we have our biggest office there. Many of us work from home, like myself.

- **Q: Can we invite you to give a talk in our department/company?**

    A: I'd love to, but it is not very practical for me to travel in recent years because my little ones are still too little. Some people have invited me multiple times, e.g., both Marcin (RaukR summer school) and Jared (New York R) told me I could go whenever I want, but I still haven't visited them. That said, I'll be happy to give a remote talk if that's okay to you. This will save you the cost (no need to reimburse or pay me), and also save me the long trips. If your institution is within three hours of drive from Omaha, I can probably drive there to give the talk and return home afterwards.

- **Q: Can I have you sign my books?**

    A: My pleasure! I can sign on anything you like (books, stickers, T-shirts, etc.), except a fake debit note that says I owe you a million dollars.

- **Q: Can I take a picture with you?**

    A: Of course! I can also pretend to smile as hard as you want me to.

- **Q: Can I sit at your table or by your side at the meal time?**

    A: Absolutely! Feel free to take any seat you like and chat. I may not chat too much, but I'd love to listen. Even if you see I have a friend with me, feel free to join us. Most of time I'm not having a formal meeting with someone, so please don't worry. If I need to leave, I'll keep looking at the watch on my wrist. BTW, I don't have a watch on my wrist.

- **Q: Why did you stop blogging for the past half year?**

    A: One participant at the conference asked me what happened to my blog. I was very grateful to his attention. Yes, I was super busy last year. I planned to finish writing a book, but ended up being interrupted for a few times for software development work (e.g., when Pandoc 2.8 was released, and Bootstrap 3 was officially dead). With about two dozens of R packages on my shoulders, I have found it more and more difficult to focus on any new projects. In 2019, I released a single new package in total ([**rolldown**](https://github.com/yihui/rolldown)). To be honest, I was not very satisfied with its quality, and I only spent less than a week's time on developing this package. I often felt overwhelmed by the number of GitHub issues and Stack Overflow questions every day. Eventually I decided that I could not afford the whole R Markdown ecosystem and should hire someone to help me, although I had already got [several big faithful helpers](/en/2018/07/help-answer-questions/). Apologies in advance to those who are interested in this new position---it has been there for a month but I didn't promote it because I have already had a few perfect candidates, and it is going to be really tough for me to make the decision.

- **Q: What's your next project? In other words, what's going to be "down" next?**

    A: I don't have a plan yet. I need to finish writing the current book first. If you have any cool ideas, I'd always love to listen.

## Final words

Emil Hvitfeldt has kindly put together [a GitHub repo](https://github.com/EmilHvitfeldt/RStudioConf2020Slides) to collect all materials related to this conference. RStudio also has an official repo to do this, but it seems we forgot to promote it: https://github.com/rstudio/rstudio-conf.

I'd like to thank the TAs of our [R Markdown workshop](https://github.com/rstudio-conf-2020/rmarkdown-dashboard) for their help over the two days, including Hadrien (who also wrote [a useful post on customizing CSS](https://medium.com/@HadrienD/f5adff36e2cc) later), [Melanie](https://www.linkedin.com/in/melanie-mayer-69554214a/), [Adi](https://adisarid.github.io), and [Jiena](https://www.jienamclellan.com). I also want to thank my co-instructor Carl, who did most of the work at the workshop and made my (teaching) job much easier. Many thanks to my RStudio colleagues, who have made a lot of effort to make this conference a success. Every time I go to this conference, I feel very much inspired by the attendees. Thank you all for your encouragement and kind words! I'm especially glad to see that people like [Leonardo Collado-Torres](http://lcolladotor.github.io/2020/02/03/conference-feelings-from-newbie-to-sponsor/) started to follow Emily's call to become sponsors. At the same time, I also feel proud that [RStudio has become a Public Benefit Corporation](https://blog.rstudio.com/2020/01/29/rstudio-pbc/).

Lastly, if anyone is going to the useR! conference this year, I'll be happy to meet you in St. Louis in July! I'll do [a tutorial](https://user2020.r-project.org/program/tutorials/) there, and hopefully also a talk. If things (I mean, kids, of course) go well, I'll also go to rstudio::conf(2021) in Orlando FL.
