---
title: On TIOBE Index
subtitle: and the era of decision fatigue
date: '2019-06-28'
slug: tiobe-index
---

Python users must be happy to see this month's [TIOBE Index](https://www.tiobe.com/tiobe-index/), while R users might have felt sad about R's ranking. [There has been criticism](https://en.wikipedia.org/wiki/TIOBE_index) on the TIOBE Index. I, for one, don't like this index, but not because R's ranking dropped this month. Even if it ranks R as the most "popular" programming language, I'd still be skeptical (well, I guess everyone would).

The main reason I don't like this index is that the effort behind the index seems to be fairly cheap, because it is  based on a few automated queries to search engines and the formula (with somewhat arbitrary weights) to calculate the index is very questionable when you consider what it actually indicates v.s. what this index claims to be (from their web page):

> It is important to note that the TIOBE index is not about the best programming language or the language in which most lines of code have been written.
> 
> The index can be used to check whether your programming skills are still up to date or to make a strategic decision about what programming language should be adopted when starting to build a new software system.

Basically it says that you should follow whatever programming languages that most other people have searched for in search engines. No wonder the current US president was elected. Speaking of media and search engine coverage, he was definitely the winner.

It is not that I dislike the TIOBE Index. It is that I hate all sorts of rankings in general. Rankings are too abstract and vague. They are often relatively easy to calculate and easy to become headlines in the news. The worst of all is, people who calculated these rankings will be the ultimate winners, no matter if the specific objects being ranked become "winners" or "losers" in their definition for the ranking. For example, regardless of Python entering TIOBE's "Hall of Fame" or R dropping out the "Top 20" or even dying, TIOBE is always the winner in terms of the attention they have gotten. This reminds me of a Chinese idiom: Behind a general's reputation, the bones of ten thousand corpses of his soldiers have dried (一将功成万骨枯).

However, my point is not about blaming TIOBE or any ranking systems. If I'm blaming anyone at all, I'm blaming ourselves for our laziness. We are too lazy to evaluate one thing carefully by ourselves, which gives a great chance to ranking systems: Forget about it, and let me just tell you that X is better than Y (be it a programming language, a university, or a restaurant, etc.). "Better" in what sense? That is the hard question, and we tend to avoid answering it.

Actually I'm not sure if we should blame ourselves for our laziness or just blame this era of decision fatigue. We simply have too many, trivial or not, decisions to make every day. Practically, we don't have the time to do the research by ourselves, so we have to blindly trust the rankings. This feels like a tragedy or curse of our times. In Daniil Granin's book "[This Strange Life](https://www.litmir.me/br/?b=226757&p=1)" (which depicted the life of Lyubishchev), he mentioned a biologist who researched worms for his whole life and said something like this:[^1]

> Worms are so long, yet my life is so short!

I doubt if anyone is still able to focus on one thing like a worm for a whole life today. One day I mentioned on Twitter that I only read Twitter on every Wednesday afternoon, and someone joked that he only read Twitter in the first half of every minute.

Programming languages are so complicated, yet the index is so simple.

![I can do any rankings I want.](https://slides.yihui.org/gif/have-permit.gif)

[^1]: Oddly enough, it is hard to find this book in the English world, so I don't know the original words. I read the Chinese translation about 8 years ago. It was a shockingly fantastic book. If you are interested in time management, I'd highly recommend this book.
