---
title: From RTFM to ITFM (Improve The Fine Manual)
subtitle: Instead of blaming the user, try to ask for suggestion on improving the manual
date: '2019-05-22'
slug: rtfm-or-itfm
---

One TinyTeX user complained that it was not obvious in the manual to him that he needed `tinytex::install_tinytex()` to install TinyTeX. Then my [biggest helper](/en/2018/07/help-answer-questions/) Christophe Dervieux (@cderv) replied him [in the GitHub issue](https://github.com/rstudio/tinytex/issues/103#issuecomment-493793875) and told him this instruction was in the first code block in the first section of the TinyTeX documentation. This user felt the message in the reply was like:

> It's there, dummy, so why didn't you find it?

When I saw the new messages in the GitHub issue, I was very surprised. As I said, Christophe is a super kind person, and that user certainly misunderstood him. I felt some gun powder in the air.

The lengthy `tlmgr` manual was one of the two motivations of TinyTeX: I wished the TinyTeX documentation would be short enough, but... facepalm! I didn't know how I could improve the documentation to make `tinytex::install_tinytex()` more prominent, so I asked for his suggestion. I could have yelled that "you would find it if only you had 30 seconds' patience for RTFM", but such a reaction would be lose-lose.

Eventually he admitted the documentation was clear, and the thing he was looking for was right in front of his nose.

With just a little bit more patience (the author doesn't blame the user too soon, nor does the user complain too soon), we can turn the lose-lose situation to win-win.

![Be patient. You will be saved.](https://slides.yihui.org/gif/tree-growing.jpg)
