---
title: The Implementation of `yolo = TRUE` in xaringan via yolofy()
date: '2019-03-06'
slug: yolo-karl
disable_math: true
---

It has been more than two years since [Karthik requested](https://twitter.com/_inundata/status/798970002992873472) the (most famous?) `yolo = TRUE` feature in **xaringan**, and I feel amused to see [people still](https://twitter.com/Chucheria/status/1104422687345180673) having [great fun with it](https://twitter.com/tam07pb915/status/1101434299369185280).

[![@tmrkn's tweet about the funny yolo option in xaringan](https://pbs.twimg.com/ext_tw_video_thumb/1101434265231798272/pu/img/BLOrnmcx_AARqWyH.jpg)](https://twitter.com/tam07pb915/status/1101434299369185280)

The implementation was actually not too complicated. The idea is that we just randomly insert new slides with background images (the default is [Karl's mustache photo](https://kbroman.org/blog/2014/08/28/the-mustache-photo/)) into existing slides. We know that slide pages are separated by three dashes `---`, so what we need to do is to find out the three dashes, and replace a random set of them with

```markdown
---
background-image: url(path/to/the/image)

---
```

In fact, there is a function [`xaringan:::yolofy()`](https://github.com/yihui/xaringan/blob/2543fa1/R/utils.R#L51-L65) to implement this. It has two arguments: `x`, a character vector of the Markdown source of the original slides, and `config`, a list of configurations that specify how many times (or probability) you want the image to appear in the slides, and which image you want to use.

```r
x2 = xaringan:::yolofy(
  x = c('---', 'First', '---', 'Second', '---', 'Third'),
  config = list(times = 2, img = 'karl-mustache.jpg')
)
cat(x2, sep = '\n')
```

```
---
background-image: url(karl-mustache.jpg)
---
First
---
Second
---
background-image: url(karl-mustache.jpg)
---
Third
```

If you have read the source code of `xaringan::yolofy()`, you will realize that the `yolo` option of `xaringan::moon_reader` is flexible. Below are all valid usage:

```yaml
output:
  xaringan::moon_reader:
    yolo: true  # make Karl appear once randomly
```

```yaml
output:
  xaringan::moon_reader:
    yolo: false
```

```yaml
output:
  xaringan::moon_reader:
    yolo: 3  # let Karl appear at most 3 times
```

```yaml
output:
  xaringan::moon_reader:
    yolo: 0.2  # appear in 20% of original slides
```

```yaml
output:
  xaringan::moon_reader:
    yolo:
      times: 5
      img: kangaroo.jpg  # use a different image 5 times
```

This has been one of the most representative "low effort, high return" examples in my packages. I think the actual implementation contributed the least to its influence. The key was Karthik's idea and Karl Bromona-Lisa's picture. I was just lucky enough to have seen both.
