---
title: On Marketing (on Social Media)
date: '2018-12-26'
slug: social-media-marketing
---

Both Mara and Hadley disagreed with me [when I talked about my concerns on marketing](/en/2018/11/dependency-winner/) last month. Marketing was not the main topic of that post, and I want to clarify my thoughts in this post.

## The medium is the message

I'm not against marketing. I do it myself, too. I definitely agree with Mara's comment that meritocracy is a fantasy:

> I think there's a tendency to imagine a platonic ideal of meritocracy in the absence of something we call "marketing," which (in reality) doesn't really exist.

My actual problem is more with the social media than with marketing. When I said "the room" was loud enough, I meant the social media:

> [...] marketing more or less depends on how loud you can shout out and whether you are able to keep raising your voice in a room that has already been fairly loud (or using more emojis).

There is too much to see on the social media. Too much "breaking" news. Too many pictures of dogs and cats. Too much Trump. To market your software package, you are forced to "raise your voice" or use all sorts of bells and whistles (e.g., attach images or GIFs) unless you have a fairly big number of followers.

I'd be very interested in a service that can help us filter the content on social media. I don't think social media platforms like Twitter and Facebook care about whether we are able to read what we really want to read. On the contrary, I believe they want to train us to be buried in, and addicted by, chaos.

[McLuhan described](https://en.wikipedia.org/wiki/The_medium_is_the_message) the "content" of a medium as a juicy piece of meat carried by the burglar to distract the watchdog of the mind. I feel social media platforms are exactly such burglars. To clarify, I'm not saying that users who generated the content are burglars. Users are simply victims.

## Two great examples of marketing on social media

If I were to follow only one person on Twitter, I'd follow [Mara @dataandme](https://twitter.com/dataandme).[^1] She is a great curator, promoting an extremely wide range of interesting resources about R every day. If I were still relatively new to R, and had enough free time to look for things to learn, I'm sure I'd benefit a lot from her tweets. The great thing about Mara is that she actively markets for people with low voices, so they don't have to scream by themselves. ~~My last wish for Mara is to completely drop the (already very occasional) use of "ICYMI" :) In case you missed it, just miss it. [FOMO](https://en.wikipedia.org/wiki/Fear_of_missing_out) is rather unhealthy in my opinion.~~ (Update 24 hours later: [She did it! "ICYMI" was replaced by #repeatTweet.](https://twitter.com/dataandme/status/1078850366492561409) Yeah! Thanks, Mara!)

Another great example of marketing on Twitter is [@WeAreRLadies](https://twitter.com/wearerladies). I don't know who came up with this idea of "Rotating Curators". It must be a genius. This is the best marketing idea I have ever seen: people (R ladies) take turns to use the same Twitter handle to promote their own or other people's interesting work.

## Deep marketing

[As Hadley pointed out](/en/2018/11/dependency-winner/#comment-4192835297), I do a lot of marketing myself, but I often do it differently. In particular, I deliberately avoid using Twitter myself. It is only my personal choice, and I don't mean you should do it, too. In fact, I believe most people would actually benefit more from marketing on social media than through other ways.

After I finished the **bookdown** project and the corresponding book in 2016, I started to think about this question:

> If I were to tweet (announce) only once or twice a year about my work, what would I post?

This partially explains my decreasing number of tweets per year---if I don't have anything of importance to say, I just keep quiet. To me, the marginal utility of marketing on social media has been diminishing. I feel more and more people are engaged in social media. It has become a [red ocean](https://en.wikipedia.org/wiki/Blue_Ocean_Strategy). I don't want to spend time on thinking about how to do marketing more effectively there as the bar keeps raising, and I'd rather save the effort to do the one thing (or two) well every year. On the other hand, thanks to many friends like [Julia Silge](https://twitter.com/juliasilge/status/1062575146404274176) and [Carson Sievert](https://twitter.com/cpsievert/status/950416948634021893), I only need to focus on writing blog posts, and they will pick some to spread. The crafty Yihui clearly knows that marketing through one's own mouth is not the best idea. Therefore staying (relatively) quiet on Twitter is the rational choice for me. I guess most other people don't have my luxury, hence should not follow my marketing strategy.

My so-called deep marketing strategy is "deep work + passive marketing". This has an important prerequisite: I have been famous enough. I can invest most of my time into the work itself, and people will surely discover it sooner or later. Even if I'm excited about the work, I'd hold the desire to share it myself, because I want it to pass someone else's independent test first. [I strongly prefer depth over breadth](/en/2018/08/influence-depth-or-breadth/) in terms of making an impact. I'd be much happier if only a single user finds my work useful and uses it for a decade than when ten thousand users are excited for ten seconds.

## Slow marketing

After we build a cool product, we often feel the urge to tell people in the next minute. I usually hold this desire, too. Instead, I slowly collect cool use cases of this product in the coming years. Hadley described the **bookdown** website [bookdown.org](https://bookdown.org) as one of my marketing initiatives. He was absolutely correct. I keep collecting books written in **bookdown** for marketing both my own package and other people's books. However, I won't share the individual books every time I find one (usually I find them on Twitter but won't tweet or retweet). I want to take a single chance to impress **bookdown** users. That is, when they open the website and see the long list of free books.

Blogging is also a slow way of marketing. It is slow in two senses: posts are often slow to write and also slow to read. By writing slowly, you (as the author) have a better chance to speculate. A possible by-product is that you may do a better job of marketing. By reading slowly, your readers know more deeply about your work and you. Of course, there will be readers who don't prefer reading blog posts because of their length. Personally I don't consider them my target audience.[^2] The audience who are easy to get may also be easy to lose.

[As I mentioned to Martin John Hadley](https://twitter.com/martinjhnhadley/status/1074961327414743042) a few days ago, I don't often announce new releases of packages I maintain (the main exception is the initial CRAN releases). New releases typically contain bug fixes and new features. I feel not many people are interested in knowing the bug fixes, and I often don't have many groundbreaking new features in these releases, so I'd just let those who really care about the new releases dig out the new stuff slowly by themselves. Sometimes it is worth leaving small exercises to users ([Dason is an expert](https://stackoverflow.com/questions/53820938#comment94526023_53820938)). Is that a kind of the [IKEA effect](https://en.wikipedia.org/wiki/IKEA_effect)?

## What I didn't do well: marketing for other people

A lot of people in the R community have helped me promote my work. I feel very grateful to them. Honestly, I haven't done much in return, and I definitely owe the community some marketing effort. Occasionally I write about some cool hackers in my blog, and try to help people find jobs. As a master of marketing, sometimes I use [very subtle ways](https://pagedown.rbind.io/html-resume) to market for [other people](https://pagedown.rbind.io/html-letter).

As I was writing [the post](/en/2018/09/code-appendix/) about Alex and Lucy's methods of putting code in the appendix in September, I came up with a book idea. I was hoping to put together a book about those cool hackers, to show how one could be moderately successful as an ordinary human, because I don't believe the chicken soup that all people can be wildly and unconditionally successful. I hope the community would benefit from these examples. That said, I have already had two other books lined up for 2019, so I really have no idea when I'll be able to work on this one.

## Conclusion

Is marketing necessary? Absolutely. Do you have to use social media? It depends. The take-home message? Do good work first. Then try to be creative in marketing.

![Be a good duck first. Then wear a dog mask to impress others.](https://slides.yihui.org/gif/duck-dog-mask.gif)

[^1]: If I were to subscribe to only one RSS feed about R, I'd subscribe to [R Weekly](https://rweekly.org). The team has done a fantastic job of handpicking the best new stuff related to R every week.

[^2]: But I admit my posts can be wordy and rambling.
