---
title: On Disagreement
date: '2018-12-24'
slug: on-disagreement
---

There is a problem with being famous. When you become famous, you may lose some opportunities of hearing other people's disagreements with you. There are a few possible reasons:

1. They may not be confident enough with their own opinions, and think you must be correct when there is a disagreement.

1. They may think you are wrong, but choose not to speak up anyway, because they are worried that everyone else would agree with you, which could make them unpopular.

1. Out of courtesy, they don't want to disagree. They know you often feel good about yourself, and they don't want to destroy your fantasy.

1. They just don't bother arguing with you. For example, they may think you are so obviously wrong, or they just don't care about you.

So the actual number of disagreements should usually be higher than the number you have seen. From my experience of reading comments and feedback on my blog posts over the years, I feel the vast majority of readers wouldn't express their disagreement. There is no way for me to tell if they really agree with me, or just choose not to speak up. This has always been a puzzle to me.

Anyway, I always welcome different opinions. We all have blind spots, which is why different perspectives can be extremely helpful. My words, written or spoken, are not meant to be carved into stone. I may change my opinions, especially after I hear different thoughts or see different perspectives from a discussion with other people. Below are two examples:

- [I ranted about some Stack Overflow users](/en/2018/02/closed-so-question/) and criticized them for closing posts too quickly. I said I didn't understand why posts had to be closed. Colin Gillespie kindly explained it to me and defended the Stack Overflow community. I appreciated the explanation very much.

- Originally I linked to Aaron Swartz when [I was talking about open-access publications](/en/2018/08/bookdown-crc/). Maëlle Salmon felt uncomfortable with that and thought I was judging Aaron. I admit that some links in my posts are very subtle and deserve explanations, but sometimes I don't have enough time or the topics are too sensitive.

I wish more readers could be like Colin and Maëlle. It is totally fine that you don't agree with me, or dislike what I said---please feel free to let me know in these cases. I think there is a good chance that we can reach an agreement after exchanging more thoughts. Even if we don't, that is also fine.

I'm totally open to critiques, too. There are things I hate in my own work and products (and actually, my self). If nobody mentions them, I may not be motivated to fix or improve them. If you criticize me, you will actually be helping me. Here are two examples:

- I'm not really satisfied by [the R Markdown book](https://bookdown.org/yihui/rmarkdown/). Before I started writing it, I explicitly aimed at publishing it as quickly as possible,[^1] so I sacrificed a bit quality. I feel most chapters are fairly dry (especially those about output formats), and some chapters are too brief (e.g., Chapter 17). If people can point out the parts they particularly dislike, I will have a better idea on what to improve in a next edition. For example, [Mikhail Popov mentioned](https://twitter.com/bearloga/status/1012422401534058501) his struggles with customizing templates, and that was great feedback to me.

- Chester Ismay [published a review of the **bookdown** book](https://twitter.com/old_man_chester/status/994690785982345216) in The American Statistician this year, and pointed out several places that are confusing or too challenging in the book. I agree with his critiques. If I publish a second edition of this book in the future, I'll make sure to take this review into consideration.

In fact, occasionally I want to speak up my disagreement with certain people but I'd hesitate because I don't know what their attitude is and I don't want to offend or hurt them. I hope this post will remove the hesitation of readers who disagree with me. Going forward, I'm always looking forward to more of your corrections of my biases and mistakes.

![Feel free to correct me when you feel anything is wrong. Don't hesitate.](https://slides.yihui.org/gif/daaaad.gif)

[^1]: On one hand, I'm usually busy enough and could not afford too much time on writing the book. On the other hand, R Markdown had been invented for five years, and it should be a good time to have an official guide. I could aim at quality instead of publication speed, but I doubt if I would ever be able to finish the book. BTW, let's keep our fingers crossed for "the Shiny book", or the seven volumes of "[The Art of Reactive Programming](https://community.rstudio.com/t/plans-for-a-shiny-book/1080/15?u=yihui)"! :)
