---
title: Things are Getting Better and Better
subtitle: Keep calm and carry on
date: '2018-11-08'
slug: getting-better
---

Last month [I suddently learned](https://twitter.com/_R_Foundation/status/1050791571514413057) that the R Core Team started a blog earlier this year. And of course, I was even more excited that the blog was based on **blogdown**. Given that the official R Project website had used `<iframe>` for nearly two decades, I was very delighted that they were finally embracing the newer world-wide web step by step.

Although blogs and mailing lists are both open to the public, I think blogs are more public. For developers, there are always difficult decisions to make, and oftentimes there is no way to please everyone, especially when making breaking changes. In such cases, I think a public explanation helps a lot, and most users [will appreciate](https://twitter.com/orchid00/status/1055512092558741504) the transparency, even if the change brings them trouble. BTW, I, for one, fully support dropping the support for `if (x)` where `length(x) > 1` in base R. [The post by Tomas Kalibera](https://developer.r-project.org/Blog/public/2018/10/12/conditions-of-length-greater-than-one/index.html) is a great example of demonstrating how careful R core is and how challenging it is to make breaking changes. Without revealing these efforts behind the scenes, users might think it was an arbitrary change.

Next I'll be waiting for [base R to move to GIT or GitHub](http://r.789695.n4.nabble.com/Why-R-project-source-code-is-not-on-GitHub-td4695779.html). I'll make sure to eat healthy food every day and exercise regularly to be able to witness that glorious moment in the unknown future. FWIW, LyX has moved from SVN to GIT in 2012,[^1] and Python has moved in 2017. For R, the friction [still seems to be huge](http://r.789695.n4.nabble.com/R-CMD-check-warning-about-compiler-warning-flags-td4747304.html).

Anyway, here are some other recent things that have made me feel the world is becoming a better place:

1. Although I was thoroughly disappointed ([so were others](https://twitter.com/ALCarriquiry/status/954789308757659648)) by the ASA guidelines on promotion and tenure (P+T) evaluation of faculty members published in January this year, I was extremely delighted to see [a post by the Director of Statistics at University of Minnesota](https://simplystatistics.org/2018/10/11/guest-post-galin-jones-on-criteria-for-promotion-and-tenture-in-bio-statistics-departments/) last month, in which he mentioned some new criteria for P+T that would recognize the importance of many other things (such as software contribution and novel teaching methods). That was so open-minded. If I were not so satisfied with my current job, I would...

1. I have talked about Stack Overflow a few times in my blog. I still see users who are reluctant or afraid to ask questions there, but I believe it is becoming a lot better than before. When [their new Code of Conduct was published](https://stackoverflow.blog/2018/08/07/get-to-know-our-new-code-of-conduct/) in August, I stood up and applauded for ten minutes in front of my computer. Is it a perfect place for Q&A now? Of course not, but there is no point of pursuing perfectionism, and it is not possible for a site with so many users, either. All I need to see is the desire to keep improving, which I have already seen. There are still people who downvote without explanations or vote to close an appropriate question, but now I can feel the positive energy from other people when I complain:

    [![People upvoting my comment on a post that was downvoted inappropriately](https://user-images.githubusercontent.com/163582/48227387-d33e1d00-e367-11e8-857f-dfdc0620acce.png#border)](https://stackoverflow.com/q/53064555/559676)

1. One of my life dreams has been (more or less) fulfilled: making it easier for students to write dissertations with R Markdown and **bookdown**. As I mentioned in [the announcement of the **bookdown** contest winners](https://community.rstudio.com/t/16394), I was excited to see [a network graph](https://github.com/ryanpeek/aggiedown/network/members) like this on GitHub:

    ![The network graph of the thesisdown package](https://community.rstudio.com/uploads/default/original/2X/f/fe99e9903e1c7ffc1c0b2c85518fc45fd8b13013.png)

    At the same time, publishers seem to be more and more willing to [allow authors to host free versions of their books online](https://twitter.com/StatGarrett/status/1052642829745496064). As I said in an earlier post, I believe [we could tear down the paywall](/en/2018/08/bookdown-crc/). Just like any other revolutions in history, it takes time and requires patience.

1. This is really old news, but I still want to mention it. I [started experimenting](https://github.com/yihui/knitr/commit/b5ef66b7a) with other languages in **knitr** in 2012, and added a TODO item for the Python support. Five years later, thanks to my genius colleague Kevin Ushey,[^2] [the dream had finally become true](https://github.com/yihui/knitr/commit/b2d892974) and I was able to remove the five-year-old TODO. I'd say that the pull request [rstudio/reticulate#107](https://github.com/rstudio/reticulate/pull/107) was one of the most important PRs for **knitr** in its history, not to mention how awesome the **reticulate** package itself is.

1. I feel the "tyranny of email" eventually started to go away from my inbox. This year I have received multiple emails telling me that they knew [I wanted them to](/en/2017/08/so-gh-email/) ask questions on public forums such as Stack Overflow or RStudio Community, so they did so before emailing me with the links to their questions in the public. I really appreciate it. Even prestigious and busy professors like Dr. Frank Harrell [would ask questions on Stack Overflow](https://stackoverflow.com/q/48208457/559676) instead of emailing me. How cool is that?

1. As I mentioned recently, Rmd files will no longer be rendered as normal Markdown to HTML on GitHub. GitHub will display Rmd files in their source format (i.e., plain text). I had been waiting for this for a couple of years. It seemed that [I didn't](https://twitter.com/yutannihilat_en/status/1053877401606742018) annoy [too many users](https://twitter.com/datavisitor/status/1054800395019513856). Or perhaps people who hated it didn't want to speak up... BTW, when GitHub was acquired by Microsoft a few months ago, I felt an earthquake in the world of programmers. I don't want to comment on this, but at least it turned out that I was able to contact GitHub through `support@github.com` and they were stilling listening. The world probably didn't become worse.

1. The list could go on and on, but I want to stop here by mentioning the most inspiring post of the year in my eyes: [_The Importance of Sponsorship_](http://hookedondata.org/The-Importance-of-Sponsorship/), written by Emily Robinson nine months ago. If everyone (senior or not) in the community (tech or not) could read this post and follow its suggestions, I believe the world will become better much more quickly, with people of all levels growing more quickly.

In summary, all the worlds of the academia, Stack Overflow, GitHub, college students, book authors/readers, R users who also use Python, and myself[^3] are becoming better. Of course, there are always challenging problems to be solved ahead. We shall calm down and carry on.

[^1]: Unfortunately they chose to host a GIT server by themselves. I had [a failed attempt](https://www.mail-archive.com/lyx-devel@lists.lyx.org/msg173179.html) in convincing them of using GitHub in 2012. It was a super long email thread, which [I bumped five years later](https://www.mail-archive.com/lyx-devel@lists.lyx.org/msg198746.html) after I saw Python moved to GitHub, but no one in the LyX developer team except Scott seemed to be interested at all. My major point is, it is not about _this_ team of developers. It is always about [the future generations](http://www.quotationspage.com/quote/38805.html).

[^2]: If only I had more time to write about this guy... He doesn't blog often, but his posts are often meticulous. His [current last post](https://kevinushey.github.io/blog/2018/02/21/string-encoding-and-r/) even motivated an R core member to update the documentation of `file()`, which was later called "blog post driven documentation" [by Jenny Bryan](https://twitter.com/JennyBryan/status/966734915847864320).

[^3]: Recently, my older son has praised me for the first time (since he was born) for the meal I cooked. Just another example of my world becoming better.
