---
title: English is Still Hard for Me, and Thoughts on (Computer) Language Wars
subtitle: Why are language wars endless?
date: '2018-11-02'
slug: english-is-hard
---

My native language is Chinese (Mandarin). Although I started learning English in middle school 22 years ago, and even have been in the US for more than 9 years, I still struggle with English as a foreign language on a daily basis. I'm only slightly content with my English writing. For reading, speaking, and listening, they are all miserable. In particular, my listening sucks. For example, when someone tells a joke in a conversation or talk and everyone laughs, I often have to smile awkwardly like an idiot, not knowing what exactly the joke was.

Those who know me may think I'm being modest: "Come on, Yihui, you have written four books and given numerous talks in English! How could you possibly struggle with English?"

## Some of my struggles with English

You see my four books, but you don't know that I used the dictionary for thousands of times. I use the dictionary when writing anything in English, including books, papers, software documentation, blog posts, GitHub replies, and emails.

I read books almost every day, but I rarely read books in English. If I hear a good book in English, I'll find its translation in Chinese (e.g., "Poor Charlie's Almanack", "Deep Work", and "Principles"). My English reading speed is too slow, not to mention the trouble of constant pause to look up words in the dictionary. I guess my vocabulary is no larger than a 3rd grader of native English speakers. Even when I read books for toddlers, I often find words that I don't know. In the adult's world, some English words are just so confusing and I can never remember what they mean. Today I just saw [the example of "bi-weekly" vs "biannual"](https://twitter.com/Julie_B92/status/1058330883927797761). There are too many hills for me to die on...

For speaking, my biggest headaches are the pronunciation and my limited vocabulary. Let me give you four (funny) examples of my pronunciation problems:

1. During my PhD defense in 2013, I said "paradigm" multiple times and pronounced it as "para-dig-m". Yes, I said "dig". I guess it didn't matter, though, since I passed the defense anyway. It was quite some time later that I heard someone else said "paradigm" and realized my pronunciation had been wrong for years. I hate those silent letters in English. Tom_b_. I_s_land. Gra_h_am. Dam_n_. BTW, there is a Durham building at Iowa State, and most new Chinese students pronounce it incorrectly.

1. I went to LA in 2015 and [gave a talk](http://datascience.la/yihui-xie-presents-html-widgets/) there on HTML widgets after [Joe Cheng's talk](http://datascience.la/joe-cheng-presents-shiny/) on Shiny. It was in Joe's talk that I learned for the first time in my life that I had pronounced the word "verbatim" incorrectly for years (I learned the word from LaTeX by reading). I thought "ba" in "verbatim" should obviously be as in "bat", but Joe's pronunciation clearly told me it should be as in "bake". I could hear my inner world collapsed at that moment.

1. One evening in September this year, as I watched my 3-year old playing in a park, I listened to Nick Tierney and Saskia Freytag's podcast on [Sweave, knitr, and rmarkdown](https://soundcloud.com/crediblycurious/sweave-knitr-and-rmarkdown). It struck me when Nick mentioned my book "R Markdown: The Definitive Guide". Again, for the first time of my life, I realized I had pronounced "definitive" incorrectly for years. I thought it was similar to "definite". I had used the wrong pronunciation in the promotion video of my upcoming [R Markdown workshop](https://www.rstudio.com/conference/) before I listened to Nick's podcast. Damn it. They might doubt if I'm really the author of the book.

1. Last weekend my neighbor's son came to my backyard to play with my son. His parents followed him over. I was frying some sesame balls outside.[^1] I invited them to taste the balls and told them these were "see-same" balls. I'm not sure if they really heard me, but after I returned to my pot to fry the rest of balls, I overheard the wife told her husband that those were "/ˈsɛsəmiː/" balls. Wait? What is "se-sa-me"?!... What was worse was that when I came inside, looked it up in the dictionary, and realized that I had not only screwed up the pronunciation for ten years, but also misspelled it as "seesame" (which explains my wrong pronunciation).

I don't really worry about the problem of pronunciation or even accent. I'm sure people can understand me in most cases anyway. The other problem, the limited vocabulary, is a substantial trouble in speaking. When I give a talk, I have to start a background process in my brain to find the proper words, and this parallel process may or may not succeed. During a talk, you cannot pause in the middle of a sentence, ask your audience to wait for a moment, and use a dictionary. In writing, it will be much easier since there is no requirement of immediacy.

For listening, I have to blame myself for being too shy to talk to native speakers more often or ask them to repeat when I don't get it. I can only deal with technical conversations. For conversations on other topics, sometimes I can understand 30% to 50%, and sometimes I'm basically deaf, especially when the environment is noisy, such as in a bar or when there is live music around. I feel most American restaurants are just too loud for me, so I rarely feel comfortable dining in those restaurants.[^2] In a group conversation, I also feel awkward to interrupt others when I don't understand certain things due to language problems (like, "Excuse me, could you repeat your joke and say it more slowly?").

By sharing my experience above, I mean it can be surprisingly hard to master a foreign language (at least for me).

## Why wars on computer languages or tools are a waste of time

First things first: Don't [ever](https://news.ycombinator.com/item?id=18319717), [ever](https://news.ycombinator.com/item?id=18336202), [ever](https://news.ycombinator.com/item?id=18342415) read comments about computer languages or tools on Hacker News. Leave them alone, and let them waste their own time there. Or actually, just don't read any comments on any topics on Hacker News.[^3]

Why are some people so obsessed with computer language wars? Why don't people also argue to death on human languages? My theories are:

1. Most people only have one native language. They don't know enough about foreign languages. When they learn a foreign language, they know attacking this language will make no sense even if they see all kinds of unexpected rules compared to their native languages. For example, from the point of view of Chinese speakers, none of plural nouns (hence countable/uncountable nouns), the subject-verb agreement, or tenses of verbs in English make practical sense. Surprises to one language speaker may feel fairly natural to another language speaker who has learned all these "surprises" since he/she was one year old.[^4] When talking about computer languages, people seem to forget this. They become snarky about surprises in other languages, even if they haven't really spent any substantial time on learning the foreign computer languages.

    ![Some people don't bother learning a language or tool seriously](https://slides.yihui.org/gif/wrong-usage.gif)

    I don't mean you should spend 22 years on a computer language before you are qualified to comment on its disadvantages, but I won't listen to arguments from someone who hasn't learned a language for more than half a year. I guess if someone hates a language, he won't even bother learning it seriously, so language wars tend to be shallow.

1. Native languages of humans are learned when humans are still little babies and don't have a choice. Computer languages are learned much later, and often consciously chosen by the learners. To some degree, you may feel insulted when someone criticizes or insults your computer language, because it implies you made a stupid choice of an inferior language, which often urges you to defend your wisdom. By comparison, if someone insults a human language, I believe everyone will agree that it is sheer discrimination, because we were pretty much born with our native languages.

To sum it up, people are reluctant to learn a different language seriously, so surprises in other languages will stay in their mind and be denied forever. Computer languages also tend to become a part of people's identities, which can be hard to deprive.

There may also be people who lack the sense of inner security, and they seek confidence by looking down upon other people's choices of languages.[^5] This is apparently the wrong way to go, and unfortunately, it triggers endless wars, too.

## Keep your identity small

Paul Graham wrote an essay "[Keep your identity small](http://www.paulgraham.com/identity.html)" in 2009. I found it to be a piece of good advice.[^6] If you love a language, don't turn it into a religion, but just show your love by good work with the language. I love my native language, so I blog extensively in Chinese, even though I feel Chinese people have been losing confidence in the Chinese language mainly due to the dominance of English (and endless English exams!). English makes me struggle, but I write frequently in English anyway. Of course, speaking of computer languages, I like R, and also find JavaScript a lot of fun. In early years, I used to scorn and make fun of SAS and MS Office ([example](/en/2009/09/how-to-import-ms-excel-data-into-r/)), but I have stopped it in recent years because it is absolutely not wise,[^7] and I have gained enough confidence in R (as well as Pandoc's Markdown).

Sometimes I'm surprised that even [leaders and experts](https://twitter.com/ivanov/status/243244721034637312) of extremely popular languages still need [endorsements about languages](https://twitter.com/wesmckinn/status/326771315170230273) from higher-level experts. That probably explains why ordinary users fight even harder for the languages of their own choice. Few people seem to have enough inner peace to let them ignore comments or comparisons on the languages they use and love.
<!--
Only ugly languages become popular. Python is the one exception. -- Donald Knuth
-->

> If we were to wake up some morning and find that everyone was the same race, creed and color, we would find some other cause for prejudice by noon.
> 
> --- George Aiken

In the end, to those who are still interested in language wars and believe languages and software are an essential part of your identities, I'd highly recommend a novel, [_And Quiet Flows the Don_](https://en.wikipedia.org/wiki/And_Quiet_Flows_the_Don), to help you get rid of your identities. It is an epic novel and took me quite a few months to finish in 2014. Among all the novels I have read, this one has had the biggest impact on my view of the world. Who are your real enemies? What have you been fighting for? A dream, or a label?

[^1]: Cooked sweet potato mixed with rice flour, and coated with sesame---in case you are interested in the recipe.

[^2]: My listening is one problem. The other problem is that I feel I have to keep shouting when talking to other people, which is quite a stress to my throat.

[^3]: There is certainly useful information, but overall I feel it is even worse than Twitter (disorganized and rage-driven).

[^4]: For example, just tell me why the plural of "cow" is "cows", but the plural of "sheep" is still "sheep" instead of "sheeps".

[^5]: Mathematicians stand on each others' shoulders and computer scientists stand on each others' toes. --- Richard Hamming

[^6]: Well, I confess that I learned this article from the Hacker News mailing list, but I've been considering unsubscribing the list recently, because I feel even the quality of the weekly newsletters has been dropping while the length is going up .

[^7]: If you read [one of my previous posts](/en/2018/09/notebook-war/) carefully enough, you may have seen that I actually praised Excel in Footnote #2.
