---
title: A Follow-Up Post on My Early Career Crisis Post (Finally)
subtitle: Those clever and brave are often trapped by what fascinates them
date: '2018-09-21'
slug: career-crisis-follow-up
---

In the post "[My Early Career Crisis](/en/2018/02/career-crisis/)" earlier this year, I promised that I'd write a follow-up post to talk about my thoughts and advice for managers and fresh PhDs. This is the major "debt" I owe you before I can focus on my next project. I thought I'd better pay it off now, so I can have something new to talk about at rstudio::conf 2019.[^1]

## The Statue of Responsibility

I guess everyone knows the Statue of Liberty, but not many know the [Statue of Responsibility](https://en.wikipedia.org/wiki/Statue_of_Responsibility). Dr. Viktor E. Frankl, the person who came up with the original idea, stated that:

> Freedom, however, is not the last word. Freedom is only part of the story and half of the truth. Freedom is but the negative aspect of the whole phenomenon whose positive aspect is responsibleness. In fact, freedom is in danger of degenerating into mere arbitrariness unless it is lived in terms of responsibleness. That is why I recommend that the Statue of Liberty on the East Coast be supplemented by a Statue of Responsibility on the West Coast.

This was very insightful. I don't know if it is worthwhile building such a physical statue on the west coast, but whenever you talk about freedom, you should also think about the other half of the truth: responsibility.

![The statue of responsibility](https://user-images.githubusercontent.com/163582/45893844-3b25ad80-bd92-11e8-82ff-9702a1900198.png)

Freedom was one of the main topics of my career crisis post. I enjoyed too much freedom and independence for too long, and didn't think much about responsibility. My first advice to graduate students is that you should bear responsibility in mind while enjoying the freedom in academia.

However, I should mention that responsibility is actually fairly tricky in academia, because people are _knowledge workers_. In general, it is hard to measure responsibility for knowledge workers. Even when you have a weekly meeting with your advisor to talk about your progress, you may be able to survive the meeting with just half an hour's work instead of the expected twenty hours. Usually there are no physical products from your research projects like those produced by labor workers. It is tempting to change your goal from "deliver a research project" to "just survive the next meeting". You will develop a habit of avoiding responsibility with the latter goal.

For managers and advisors, you may have to spend a little more time on making responsibility more measurable when you realize an employee or student seems to be unproductive. It can be slow for one to gain the sense of responsibility, and you may start with assigning explicit bite-sized tasks to them. At the same time, also keep the long-term goal in their mind, and let them feel the possible future excitement from time to time (e.g., how awesome you will be when you accomplish this project). I understand that some projects may go nowhere and can fail. In this case, make sure they have at least learned something in the process, such as a good habit for working, a sense of responsibility, or knowledge for another project.

Responsibility may be accompanied by anxiety, which is extremely poisonous. If you, as a manager/advisor, discover that an employee/student is failing to keep the responsibility, you need to figure out the cause. If it is because the task is too challenging, consider reducing the difficulty or providing more resources. If it is because they are dodging the assigned task and working on their side projects, you may need to be a little forgiving for a while and see if you can pull them back. It may be worth changing the task, too, if it turns out that their side projects are valuable. Anyway, try not to let anxiety grow quietly in their mind.

## Why talents fail: easily burned by strong passion and too many choices

[Ouyang Xiu](https://en.wikipedia.org/wiki/Ouyang_Xiu), a famous Chinese essayist of the Song dynasty one thousand years ago, once lamented that "智勇多困于所溺" (those clever and brave are often trapped by what fascinates them).[^2] This resonated well with me, although I don't consider myself clever but I do consider myself brave.

There are two dangers in being a talent. One is that failures seem harder to endure, especially after you have poured a lot of enthusiasm but suddenly fall flat. The other is that you may have many more choices than others when thinking about what to do, so you only pick what you will enjoy. Both enthusiasm and your favorite choices can trap you.

A month after I wrote my crisis post, [Romain François wrote his version](https://purrple.cat/blog/2018/03/22/i-m-not-looking-for-a-job/), titled "I'm (not) looking for a job". This post has stayed in my browser for six months till today,[^3] because I saw we had so much in common. Well, I have to admit that I always did all pages of my exams, and Romain didn't bother to open the second page of his physics exam. Both of us fell in love with programming and were not interested in statistics theories but passed the exams with flying colors anyway. Both of us tended to overcommit ourselves, not knowing how to say no. Both of us created websites for statistical graphics galleries, and those websites died. Both of us had given training courses that we had no idea about, and prepared that the night before. Both of us were structureless and lost from time to time.

To some extent, we were punished by our cleverness and passion. Here are some of my advice to those clever, brave, and passionate graduate students:

- Passion is not necessarily good or bad. It is _unguided_ passion that is dangerous. As long as your passion is carefully guided, it is extremely powerful. Don't let your passion kick you around randomly. Without delivering results and products, you are just wasting your energy, even if you feel you are busy and working hard.

- Being smart on one subject doesn't guarantee you will succeed on anything or be able to work on anything. Both your knowledge and time are limited. You are likely to be more famous than your peers because of your talent, so more people may reach out to you for various matters, but don't work or promise/agree to work on things just because you (potentially) can.

- Be brave to work on challenges, but don't throw the whole world behind and disappear in the woods. The dark side of being brave is that you may be unreasonably stubborn, too. You don't have to listen to other people's feedback and opinions, but you have to at least make sure to hear them. Be brave to start, but more importantly, be brave to stop (which is much more difficult). On the other hand, although you have a lot of choices, don't always only pick up things you like to work on. In April, I said this in [an interview by Amstat News](https://magazine.amstat.org/blog/2018/04/01/data-is-my-job/) when being asked "what career advice would you give your 20-year-old self":

    > Try more often to do things you don't like but are important at the same time. It is easy to do things you like, but in the real world, there is no guarantee you will like all tasks assigned to you.
    
    I was basically paraphrasing Huxley's words, which I learned from "Poor Charlie's Almanack":
    
    > "Perhaps the most valuable result of all education is the ability to make yourself do the thing you have to do, when it ought to be done, whether you like
it or not. It is the first lesson that ought to be learned and however early a man's training begins, it is probably the last lesson that he learns thoroughly."
    >
    > --- Thomas Henry Huxley

For managers and advisors, the most important task is to guide these talents. Keep teaching them to say no, focus, and structure their lives. Let them feel the joy of accomplishments and remember it. Cal Newport's book "[Deep Work](http://calnewport.com/books/deep-work/)" has been very useful to me. I think talents suffer more from distractions because they have both inner distractions (such as the strong desire to work on random side projects) and outer distractions (such as people reaching out to them for help).

## The guilty you are not alone

One major observation I made from my crisis post was that many people could relate my situation (procrastination, guilt, and anxiety, etc.) to their own. I received several public comments and private feedback. Apparently, I was not the only one who struggled, but probably only one of the minority who had written about it publicly.

I don't want to blindly soothe those who feel guilty when they procrastinate or fail to do what they are supposed to do. That would be irresponsible of me. As long as you don't abandon yourself, I think there is still hope. You need to figure out the root cause of your procrastination. Is the cause from outside or inside?

For example, I had both external and internal causes. The internal cause was that I had other interesting projects that I hoped to work on. The external cause was all kinds of distractions (emails, GitHub issues, questions, social media, and so on). To solve the internal issue, all I had to do was talk to my manager. For external issues, they are trickier to deal with. I guess some of them are not totally my fault, such as the very addictive social media (they use algorithms to make us feel addicted, and it is hard to fight against the addiction). So far two books have helped me most: one is "Deep Work" as I mentioned before, and the other is "Amusing Ourselves to Death". The former teaches you specific strategies to deal with chaos (e.g., don't feel obliged to reply to every single email). The latter is more about the (TV) culture in which we are surrounded by irrelevance, meaninglessness, and shallowness, when messages can be passed around at the speed of light and create the unnecessary FOMO (fear of missing out). If you don't stay alert about this chaotic time we live in, you won't be able to accomplish anything substantial.

It turned out that once I was able to fix the internal cause, the impact of the external cause became much smaller, because I was very willing to focus on the projects that I was genuinely interested in. So my last advice to graduate students and fresh PhDs is that when the guilty feeling starts to hit you over and over again, talking to your advisor or manager may be a much better idea than just quietly feeling guilty by yourself. I know this can be challenging especially for introverts (like myself). You may choose an approach that makes you most comfortable to express yourself. For example, I prefer writing over talking, so I'd email my manager.

![Introverts, unite separately in your own homes! (My favorite image about introverts)](https://slides.yihui.org/images/introverts.jpg)

## Summary

In this follow-up post, first I emphasized that with great freedom comes great responsibility. Remember this when you enjoy the freedom. Then I talked about the blind spots and weakness of talents. Prioritize things that lead to your promised deliverable. Lastly, I encourage you to speak out for your vulnerable self. You may be surprised by other people's willingness to help you.

In the end, I want to sincerely thank all those who shared thoughts with me and encouraged me after I published that blog post. With so much power gained, I successfully finished and published the R Markdown book this year. Recently I just started working on an exciting new project, which will be an important step toward one of my life goals. Spoiler: it will be an R package named **\*\*\*\*down** [as usual](https://twitter.com/dataandme/status/1008803120967749635).

[^1]: Again, this is the "[talk-driven development](/en/2018/03/talk-driven-development/)".

[^2]: From "[五代史伶官传序](https://zh.wikisource.org/zh-hans/%E4%BA%94%E4%BB%A3%E5%8F%B2%E4%BC%B6%E5%AE%98%E5%82%B3%E5%BA%8F)".

[^3]: As you can see from [the screenshot](https://github.com/yihui/xaringan/pull/165#pullrequestreview-155533735) I took a couple of days ago. Look for the cat icon.
