---
title: Serving a Website or Shiny App at 0.0.0.0
date: '2018-09-18'
slug: localhost-0-0-0-0
---

Last week I came across [a question on Stack Overflow](https://stackoverflow.com/q/52312957/559676), in which the OP asked how to serve a **blogdown** website locally and let folks at home see it through the local network. That sounded like a fun thing to me, so I posted an answer.

Basically all you need to do is serve the website at the IP address `0.0.0.0` instead of the default `127.0.0.1`, e.g.,

```r
blogdown::serve_site(host = '0.0.0.0')
```

Then all people with access to the local network should be able to see the website via your IP address (which typically looks like `192.168.0.x`) and the port number (**blogdown**'s default is `4321`). If you are not sure about the IP address, take a look at your network preferences (or run the command `ifconfig` on macOS/Linux). The URL of your website should be of the form `http://192.168.0.x:4321`. You will see this address when you start serving the website on your computer.

Similarly, you can serve Shiny apps at `0.0.0.0`, e.g.,

```r
shiny::runApp(host = '0.0.0.0')
```

This is a convenient way to show websites or apps to people in the same local network. They can look at them on their own screens (even on mobile devices) while you develop a website or app.

![Look at a website while the other person is developing it](https://slides.yihui.org/gif/programming-movie-actual.gif)
