---
title: In HTML and the Web I Trust
subtitle: And LaTeX is dead
date: '2018-07-30'
slug: in-html-i-trust
---

One **bookdown** user seemed to be [very unhappy](https://twitter.com/conjja/status/1023621901602770944)[ with](https://i.imgur.com/5RqREyv.png) the HTML output format.[^1] Although I don't quite understand how difficult it is to generate a PDF from **bookdown** (sounds like two mouse clicks to me in RStudio), this tweet did remind me of a broader topic that I wanted to write about: PDF/LaTeX vs HTML.

In short, I believe [LaTeX is dead (long live LaTeX)](https://www.authorea.com/users/5713/articles/19359). It will definitely survive for a few more years (maybe twenty or thirty years), but I believe HTML has much more potential to prosper. The fittest will survive, and HTML is the fittest. If you choose LaTeX, you are pretty much tied to PDF. If you choose HTML, you will have much more freedom and fun (e.g., interactivity). In terms of typesetting, HTML cannot beat LaTeX, but it all depends on how good you want the typesetting to be. On one extreme, you could spend an infinite amount of time on improving the appearance of your work, but I'm sure most people won't do that. Getting things done is often more important than making things extremely beautiful or fancy. There has to be a point where you stop investing time in styling and typesetting. The question is when to stop. I tend to stop a little earlier myself, and I understand some people want to stop later.

![Forget about formatting](https://slides.yihui.org/gif/flip-table.jpg)

One project that made me believe even more in HTML is [ReLaXed](https://github.com/RelaxedJS/ReLaXed). The typesetting quality of web pages will surely catch up with LaTeX, but on the other hand, LaTeX will probably never be able to catch up with HTML in other aspects.

On a related note, last week [I tweeted about my dream](https://twitter.com/xieyihui/status/1022873179532996609) of liberating authors from the typesetting tasks. I was envisioning that in the (far) future, it would be the readers instead of authors or journal editors who would decide how an article or a publication should look like. The authors should only take care of the content, and the editors only take care of the review. There could be a recommended style, but is not enforced. If an article is published in HTML, styling it with CSS will be much easier than LaTeX. Readers can even choose to do so in their own web browsers. Web designers could also contribute and share themes and styles. Choosing the style that makes you, _the reader_, the most comfortable when reading the document. Changing the style on the fly. Think about it. Why should we spend time on inventing a style and then blindly hope all readers will like it? People can argue to death on things like serif vs sans-serif fonts, line-heights, colors, white vs dark themes, and so on. What introduced these [bikeshedding](https://en.wikipedia.org/wiki/Law_of_triviality) wars? I think it is our belief that what looks good in our own eyes must look good in other people's eyes, too. Look! I'm using this beautiful font! How can it possibly look ugly in your eyes?!

My blog post is relatively short, and I strongly recommend that you read the full article "LaTeX is dead" above.

[^1]: And two months later, I heard [another similar complaint](https://twitter.com/dan_p_simpson/status/1040689040419368960).
