---
title: No Slap in the Face to Those Who are Smiling
subtitle: or downvoting a Stack Overflow post that shows good intentions
date: '2018-05-07'
slug: no-slap-to-smiles
---

There is an idiom in Chinese that I can roughly translate as "You shall not slap a person in the face when he is smiling at you". This means if a person is showing a positive attitude, you'd better forgive him even if he has made a mistake.

A couple of days ago, a Stack Overflow user named "Caddisfly" wrote his/her (hard to guess the gender from this nickname) first post on Stack Overflow titled ["Short caption in kable"](https://stackoverflow.com/q/50164548/559676). What happened to this post partially confirmed my thought in [my previous blog post](/en/2018/05/right-easier-than-wrong/): some people tend to do easier things that are not very helpful, and avoid doing things that are harder but tremendously more helpful.

In Caddisfly's first post, (s)he showed good intentions: (s)he found a solution to a problem in a hard way (my bad), and wanted to share this solution with the community. Unfortunately, the answer was mixed right in the question. When I first saw the post, Caddisfly's reputation point was only one, meaning no experience in posting anything at all on Stack Overflow. Then the post was downvoted once, and a user voted to close the post. To me, that is _technically_ understandable, but also very, very bad in terms of building a welcoming community.

Downvoting or voting to close a question only requires clicking your mouse once or twice, which is extremely easy. Educating the beginner that an answer should be separate from the question requires you to type more words, which could take a minute or two, and therefore is much harder to do, but also much more helpful and meaningful (thanks, @gparyani, for doing that in the second comment).

[![A Stack Overflow post that shows good intentions but was voted to be closed](https://db.yihui.org/images/so-good-intention.png#border)](https://stackoverflow.com/q/50164548/559676)

Perhaps my words "slap in the face" are too strong. My point is that if a user is showing good intentions, we should try to welcome and encourage him/her. Formality problems such as splitting a post into a question and answer are fairly easy to fix, but kind users who are willing to share solutions are relatively difficult to find (some are busy, and some don't bother). Between the two choices, a Stack Overflow post correct in the form and a generous Stack Overflow user, which would you value more? I think the answer should be obvious.
