---
title: On Adjectives
date: '2018-03-23'
slug: on-adjectives
---

Among all types of words, I have always found adjectives the most challenging to use in communication (either writing or talking). They are challenging because (1) it is so hard to refrain from using them, and (2) it is hard to be precise.

In my opinion, it is hard to refrain from using adjectives because usually we want to draw attention, and adjectives are the most effective type of words to draw attention. If we want to draw attention, we often tend to use adjectives that are biased and fail to represent facts. For example, we may use "supreme" when we only mean "good", because we are afraid that other people won't notice the good quality. Every time I go to grocery stores, I find labels like "_extra large_ eggs" funny -- as if the eggs would be a lot larger because of the label.

The single piece of advice on writing that influenced me the most was this one:

> In writing. Don't use adjectives which merely tell us how you want us to feel about the thing you are describing. I mean, instead of telling us a thing was "terrible," describe it so that we'll be terrified. Don't say it was "delightful"; make us say "delightful" when we've read the description. You see, all those words (horrifying, wonderful, hideous, exquisite) are only like saying to your readers, "Please will you do my job for me."
> 
> ---  C.S. Lewis, Letter to Joan Lancaster, 26 June 1956

Although I have reminded myself several times of this advice, I have to admit that I have failed numerous times to actually follow it. I often exaggerate, and don't consider how readers would feel. Once a **blogdown**[^1] user pointed out to me that I often use "just" and "simply" in my writing (e.g., "just do this" / "simply do that"), just like mathematicians often use "obviously" in proofs. These words are not necessary, and could potentially hurt readers: "You said '_simply_ do these twelve things and I'll be there?!' How??" Sam Tyner's [recent twitter thread](https://twitter.com/sctyner/status/978821060220121088) is an excellent example of how you could unconsciously hurt people by using words like "just" or "should".

The reason I use "just" or "simply" is that I tend to fool myself into thinking my tools are simple to use, and then hopefully fool readers, too, but the fact is that using the word "simply" alone won't making tools simple. Only solid efforts in developing the tools will.

In the real world, I have only found [a single person](https://twitter.com/CMastication/status/959856196369793024) so far who only states facts without using unnecessary adjectives or any tricks to draw attention in writing or talking. He is such a different person, and I admire him for his inner peace.

I have hoped to write this post for long, because I see examples every now and then (including my own). After I saw the adjective ["prolific"](http://blog.revolutionanalytics.com/2018/03/the-most-prolific-package-maintainers-on-cran.html) today, I thought it might be a good time to write this post (I almost did it the last time when I saw ["popular"](http://blog.revolutionanalytics.com/2016/11/most-popular-r-packages.html)). To clarify, the purpose of this post is not to criticize anyone, but remind myself of either using adjectives appropriately, or just avoiding adjectives when possible.

[^1]: Perhaps **bookdown**? I don't remember.
