---
title: Another R-Podcast with Eric Nantz
subtitle: My early career crisis, the R Markdown ecosystem, work-life balance, and so on
date: '2018-02-15'
slug: r-podcast
---

Eric Nantz [interviewed me in 2013](https://www.r-podcast.org/episode/013-interview-with-yihui-xie/) while we both were attending a workshop in Muncie, Indianapolis. This time we met again at the RStudio Conference, and he asked me to do another interview. I thought it might be a good idea to review the past five years, so I accepted the invite. Below are some of the questions he prepared to ask me, and my initial responses, in case anyone prefer reading over listening (like me). The audio version of the interview is [here](https://r-podcast.org/episode/024-rstudioconf-yihui-xie/). **EN** is Eric and **YX** is me below.

---

**EN**: Since the last time you appeared on my podcast you've become a software engineer at RStudio and from my perspective have been very successful! Has your role been everything you envisioned?

**YX**: I believe pretty much everyone in this world has a bright and dark side, just like the moon. But usually people only notice the bright side of others. From your perspective, I might have been "very successful". Over the five years I worked at RStudio, I did get a few things done. When I first joined RStudio in the Fall of 2013, I was assigned to the Shiny team, and I mainly added DataTables and selectize.js support in Shiny. In 2014, I started working on **DT**. In 2015, I spent a fair amount of time on **leaflet**. At that point, I had been working extensively on JavaScript applications. I was definitely not a JS professional. I kind of enjoyed hacking with JS, but I was obviously not passionate enough about my job at that time.

Now here comes my dark side. Due to several reasons, including that I was not super passionate (I was passionate, but just not _super_ passionate) about JS and I was poor at interpersonal communication, I started to put aside my official job, procrastinated frequently, and disappeared from the team from time to time. As time went by, it became a serious inner crisis of mine. In 2014 and 2015, I constantly felt depressed. It is probably hard for you to imagine the huge amount of my depression, anxiety, shame, and guilt. I'll write [a longer blog post](/en/2018/02/career-crisis/) on this matter later. For now, I just want to say that it was completely my own fault, and I learned some very bitter lessons. I joined a dream company very easily, but I ruined myself and let several people down in the first two years.

It took me a while to recover from my early career crisis, but things got better in 2016 as I started to work on the **bookdown** package. My personal interest and the company interest were finally aligned, and I became highly motivated. The year 2017 was similar. I absolutely love writing, and I really wish to improve tools for writing, no matter it is writing books, or blog posts. To answer your initial question: yes, now I'm very satisfied with my role in the company.

---

**EN**: It's safe to say that R Markdown has become its own R ecosystem with powerful frameworks and extensions to create interactive reports, entire web sites, and more recently blogs via **blogdown**. What's next in the continuing evolution of R Markdown?

**YX**: At this point, you can compile single documents, make slides, create dashboards, build interactive applications, write journal papers, author books, and generate websites with R Markdown. That does sound like an amazing ecosystem, and I'm very proud of it (although I definitely should not take all the credit). It is natural to ask "what's next?", and I don't have a clear idea at the moment. I do have something to do in the next couple of months, but I'd rather not talk about it. It is not because it is a secret, but because I usually don't want to make early promises.

In terms of things to do in the farther future, I think there is still quite a bit of work to do to make R Markdown work seamlessly with journals. We have a package named **rticles**, but honestly I don't think it has fully met the standards of journals yet. The other thing I'm very interested in is to build books from blog posts. It is kind of like a combination of **bookdown** and **blogdown**. I think it will be useful, and may generate a lot of new books from the R community. Have you heard of or read the book "Rework"? It was compiled from blog posts of its authors, and became a bestseller.

Many people don't understand the point of Markdown, especially those LaTeX users. They don't understand why we invest so much time in such a simple and weak authoring language. My philosophy is that the pursuit of features can sometimes be harmful for both software developers and users. You may spend too much time on features of software, and even forget what you actually need to do (e.g., write a book). To exaggerate a bit, no feature is a good feature. The weakness of Markdown is a good feature. It forces you to focus on the content, and more importantly, it makes your content portable: you can generate PDF, HTML, Word, and many other formats.

Anyway, I have my strong faith in the R Markdown ecosystem. I think it will save users a lot of time and make them productive, so I'll certainly keep working on it until the whole ecosystem is complete.

---

**EN**: You recently mentioned that you want to get back to other R packages you've developed, in particular the **DT** package. I know I can have a difficult time jumping from one large scale project to another completely different effort (say from an enterprise shiny application to some statistical modelling packages). Do you have any tips on balancing the development and maintenance of projects that have fundamentally different purposes and code bases?

**YX**: This is a really hard question for me. I think it is essentially a question about psychology. It happens that I'm extremely interested in psychology, and sometimes I think I'm good at applying psychological methods to other people, but ironically, I'm poor at dealing with myself. For example, it is hard to motivate myself to switch to a different project.

The hardest part of switching to a different project is the initial psychological friction. Once you get past that, things will be a lot easier. I believe most people understand this, however, not many people really have the willpower to overcome the initial friction. It is like doing physical exercises. You know it will be good for your health, but you still hate it every time.

---

**EN**: Since we last talked at the 2017 rstudio::conf your **blogdown** package has matured and is rapidly growing in popularity for R users who want to start an online blog (and thank you for giving me the foundation for my new R-Podcast site the way I always envisioned it!) Has developing blogdown been any easier or harder than say **knitr**, **rmarkdown**, and **bookdown**?

**YX**: In terms of programming, yes, it was much easier than **knitr** and **rmarkdown**. The total number of lines of code in **blogdown** was less than 2000 (**knitr** has about 8500).

The main challenge in the development was not about writing clever code, but user experience. I spent a fair amount of time on listening to beginners. I wanted to see the possible ways that they might get stuck, and things in the documentation that they might misunderstand.

The documentation, i.e., the **blogdown** book, was also a difficult problem to tackle. I mentioned in [a previous post](/en/2018/01/valid-url/) that Chapter 2 (Hugo) and the appendix were particularly hard to write. There were so many things to explain, and I need to think carefully how not to overwhelm readers (I don't think I was very successful in this regard).

I invited Amber Thomas and Alison Hill to join me and co-author the book mainly because after I read their **blogdown** tutorials, I felt they cared a lot about beginners and were patient enough to explain things. This is the spirit that I value most. I don't really care much about the level of technical skills.

---

**EN**: Recently your new book about **blogdown** was published and it was developed completely in the open. Do you think this is a viable model for say others in the R community who want to start creating a book?

**YX**: Honestly I don't know. It is up to the publisher. I was fortunate enough to work with Chapman & Hall, and my editor John Kimmel did a great job negotiating with his boss. They were granted the exclusive right to print and sell the hardcopies, and we would reserve the right to keep the free versions online. Some people [have found it hard to believe](https://twitter.com/Wvykta/status/960112256351694848) that there are so many free books on [bookdown.org](https://bookdown.org).

Actually I want to bring up another relevant topic: Should books and papers be free? I feel there is prejudice against commercial companies especially in the academia. In my opinion, you need to consider the work behind the publications (e.g., my copyeditors were helpful and I think they deserve being paid well). People who did the work to publish the work (authors and employees of publishers) need to survive, like you and me. They may have families to support, and so on. That said, sometimes I do feel certain journal papers and books are way too expensive. I feel the marketing and sales people didn't do a great job, or perhaps it is just that we don't really need publishers anymore (low demand leads to ridiculously high price).

For me, I can make my books free just because my employer pays me well, and I don't need the extra income.

---

**EN**: I've been fortunate to be a member of the RBind team and I am very excited to see how it's helped other R users quickly get their content from **blogdown** online. Tell our listeners more about RBind, how they can get involved, and your overall goals with it.

**YX**: Rbind is a GitHub organization <https://github.com/rbind/>. The name obviously came from the R function `rbind()`. The goal is to bind all websites related to R and stats to a single place, so that we can discover these websites more easily, and more importantly, we can study the source files of websites that we are interested in (e.g., an exceptionally beautiful website).

I think this aligns well with the spirit of open source. I attended a speech by Richard Stallman in 2010 at the useR! conference, where he emphasized the freedom to study, modify, and reuse software. When you see a great website, I hope you have the freedom to study its source, too, and apply the great things you learned from other people's websites to your own website.

A small gift to Rbind member is a free subdomain `*.rbind.io`, if you like it. You may request one from <https://github.com/rbind/support/issues>.

---

**EN**: What tips do you have for achieving a healthy work-life balance? I know for myself I can struggle with how to manage a demanding job with a young family and contributing to the R community.

**YX**: You have got several really hard questions for me, Eric. Although I can provide an answer to you, I'm afraid I'm not a representative sample due to my distinctive personality, and what I'm going to say probably won't apply to other people in the R community. First of all, I don't feel there is a clear border between work and life to me, probably because I enjoy working so much that working becomes a part of my life. I constantly work in late nights and over weekends, whenever I get a chance. By "getting a chance", I mean the little ones are not crying or pulling my legs. Secondly, I don't have a lot of personal hobbies, but only a few effective ones that can help me relax and enjoy life. My only hobbies are badminton, cooking, reading, and writing. I'm not interested in things that most people are, e.g., computer games, movies, entertainment programs, or sightseeing. Yes, I'm such a boring person.

In the end, I want to emphasize the importance of a healthy body, although you must have heard of this many times before. Don't exchange your health with other things such as wealth or fame or anything. When I feel sleepy, I just go to sleep (of course, thanks to the flexibility of working from home).
