---
title: How to Properly Write a URL
subtitle: A common mistake that many people make
date: '2018-01-30'
slug: valid-url
---

My two least favorite parts to write in [the **blogdown** book](https://bookdown.org/yihui/blogdown/) were: the chapter on Hugo (Chapter 2), and the appendices (B and C) on some basic knowledge about web technologies. I found it quite challenging to describe the full pictures, and some technical details were frustrating for me to introduce. I'll give a simple example in this post: how to write a valid URL (or link).

You may think it is dead simple to write a URL, and we click links to browse websites every day. We see them in the address bar of our web browsers all the time.

You are wrong. People make a common mistake [all the time](https://github.com/davidjohnbaker1/davidjohnbaker/commit/69de41e95) when writing URLs without realizing the mistake. I'm not kidding. If you are familiar with Markdown, would you think the following link is valid?

```markdown
Please visit the [R project homepage](www.r-project.org).
```

Or if you know HTML, does the following HTML code produce a valid link?

```html
Please visit the <a href="www.r-project.org">R project homepage</a>.
```

They may appear to be correct at the first glance. However, these links won't take your readers to the R project website. Why? Because they are _relative links_. Carefully read [Appendix B.1](https://bookdown.org/yihui/blogdown/html.html) in the **blogdown** book to torture yourself by the gory details about "relative URLs", "absolute URLs", "relative absolute URLs", and "protocol-free URLs", etc.

This is a valid link:

```markdown
Please visit the [R project homepage](https://www.r-project.org).
```

And this is also valid when present on an HTML page served through a protocol (HTTP or HTTPS):

```markdown
Please visit the [R project homepage](//www.r-project.org).
```

Just don't write a link like this:

```markdown
Please visit the [R project homepage](www.r-project.org).
```

It is wrong, wrong, wrong.
