---
title: Screenshots Can Be Helpful, But Only Text Can Be Copied And Executed
date: '2018-01-16'
slug: screenshots-vs-text
---

Last year I have mentioned that [we cannot be friends if you give me source code only in screenshots](/en/2017/08/source-code-as-screenshots/). I exaggerated a little bit. I certainly won't hate you if you send me screenshots, but my point is that you will make it difficult for me to do anything about your code. If I cannot run the code right away, it is often not easy for me to help you quickly.

Somehow some users seem to have the habit of showing screenshots instead of text. Yesterday I received an issue [rstudio/blogdown#244](https://github.com/rstudio/blogdown/issues/244), where everything was in screenshots, including source code and output. The user was having weird problems with downloading Hugo from GitHub, and my first reaction was to check whether the link was broken, but the link was in the screenshots, which means I'd have to type it out, and it was long (so it could be error-prone to type it). Everything in the screenshots was actually pure text, so there is no need to take the screenshots in this case. I don't need to know how things _look_ on your screen. I only need to know what you ran exactly, and the (text) output.

Screenshots can be very helpful when something does not _look_ right, and you can show me what it _looks_ like on your screen by taking screenshots. If you are not sure whether to post screenshots, here is the rule of thumb: usually it does not hurt to see screenshots, but if the screenshots contain text (especially source code), do post the text, too.
