---
title: Being Busy vs Being Productive
date: '2017-12-20'
slug: busy-vs-productive
---

Karthik [wished to be productive this year](https://twitter.com/_inundata/status/820713820310016000) and didn't seem to enjoy being extremely busy last year (I just learned it from [Maëlle Salmon's blog post](http://www.masalmon.eu/2017/01/24/kervillebourg/)). I guess nobody likes to be busy, yet everyone would love to be productive. He pointed to [an interesting blog post](http://jacksimpson.co/finishing-being-productive-busy/) that explained the main difference between being busy and being productive. The latter means you have to finish your project. It resonated well with me.

It is very easy to start a new project. I have seen several people who are geniuses in my eyes and started great projects a number of years ago, but unfortunately never finished them. As I said in my [previous post](/en/2017/12/blogdown-book/), I never lack ideas on new projects. You can wake me up at 3am any morning and I will be able to tell you immediately three or four projects that I have been hoping to do. However, even if I try my very best, I can only finish one a year, and the idea of the one project is often from several years ago. For example, I have hated the LaTeX installation and maintenance for more than five years. I knew how to possibly solve this problem, but it was just so hard to find two uninterrupted weeks to type out the code in my mind. Fortunately I finally found the two weeks, and finished the [TinyTeX](/tinytex/) project, for which I feel very excited.

What does "finish" mean? For a software project, finishing the code is often far from finishing the project, and in fact, it is often the easy part. The more difficult parts are testing (on different platforms with different users) and documentation. The documentation is especially difficult but important. You have to constantly update it based on your readers/users' feedback, and ask yourself over and over again, "Is it clear enough now?"

Even if it is well-documented and fully tested, it may still not be "finished" -- you have to maintain it (unless it is as stable as Donald Knuth's TeX). This has been the biggest challenge to me. Bug reports, feature requests, and questions, ... They will just keep coming, and I'm always stuck in the pain of choosing to look ahead (starting new projects) or behind (maintaining old ones). I hope I could find a way out in 2018.

P. S. I think Karthik is one of the most creative people in the R community. You will regret it if you missed his talk at rstudio::conf 2017. His slides... Well, that was just a very minor thing to represent his creativity. So many awesome ideas have been implemented in rOpenSci.
