---
title: Reproducible Research With A Marmot
subtitle: If a marmot cannot understand your research, humans probably won't, either
date: '2017-12-07'
slug: rr-marmot
---

Perhaps I have seen it before, but I just came across the "[rubber duck debugging](https://rubberduckdebugging.com)" method. It reminded me of [a talk I gave at the 2013 BioC conference](https://slides.yihui.org/BioC-2013-Yihui-Xie.html#/5), in which I introduced the "marmot reproducible researching" method. That is, when you write code chunks in a **knitr** document, you need to explain to the marmot what you are doing in the code with the corresponding prose/narratives.

![Marmot reproducible research](https://db.yihui.org/images/rr-marmot.jpg)

I don't remember whether I borrowed the ideas from the rubber duck debugging method (chances are I did). Anyway, code is often only one part of our work, but we (especially software developers) tend to think code is more essential or important or difficult to write than narratives/documentation. That is not true. Code is more for computers, and documentation is for humans. It is actually often more difficult to deal with humans than computers.
