---
title: "The #1 Reason Why I Don't Want to Work in Academia"
subtitle: Formatting Papers Is A Huge Waste of Time
date: '2017-12-04'
slug: formatting-papers
---

A few days ago I came across [a blog post by Xi'an](https://xianblog.wordpress.com/2017/11/29/biometrika/), in which he mentioned the Editor of Biometrika was retiring. I felt very sad to learn what the editor had done for ten years. Ten years!

> [...] Running a top journal like Biometrika is a massive service to the statistics community, especially when considering the painstaking stage of _literally editing each paper towards the stylistic requirements of the journal_.

In general, I truly appreciate what journal editors do in terms of the improving the content of papers, but... Styling every single paper for ten years? Why should a journal editor do that? Actually, why should anyone do that at all?

The editor of Biometrika is certainly not alone. I don't have much experience in publishing papers, but when I published [my first (and last) paper](http://www.jstatsoft.org/v53/i01/) in the Journal of Statistical Software, I did learn that one of the chief editors carefully helped me resolve several minor stylistic issues in my LaTeX source document.

I just don't understand why it is worth so much time to format papers. The sad fact is that every journal has its own stylistic requirements (and LaTeX classes/commands). I have talked to some biologists in the past, and they told me they often had to submit the same paper to one journal after another until it is accepted. Every time they submit to a different journal, they have to spend a huge amount of time to reformat the paper. The time could well be spent on more worthwhile matters, such as doing biological experiments or analyzing data or even taking a rest.

I cannot help asking: Dear journals, why are your stylistic requirements the best in the world? If they are not necessarily the best, why cannot you give them up?

Our poor graduate students often have to deal with this, too, when they write their dissertations. Every university has its own set of stylistic and formatting rules (font size, line-spacing, page margins, and so on).

I'm glad that I no longer need to deal with these trivialities. That said, one of my lifetime goals is to kill the formatting rules of journals and dissertations. I wish one day all universities can either accept a common style, or just let it go. Journals are more unlikely to accept a common style (like arXiv's style), so let's just kill journals.

There is a long way to go, and [**bookdown**](https://github.com/rstudio/bookdown) was my first step. My strong belief in R Markdown is based on the fact it is limited in terms of typesetting (i.e., being limited is a feature). By comparisons, other tools like LaTeX and Word are totally open-ended, and that is why they can quickly become complicated, and people tend to [build too many walls and not enough bridges](https://en.wikiquote.org/wiki/Talk:Isaac_Newton#.22We_build_too_many_walls....22_Source.3F).

And what is even worse is that we are unconsciously making ourselves prisoners inside the walls we built, and we think we have been working hard.

## Appendix

Below I have collected some examples that show the pain of authors when they are forced to do things irrelevant to the content of their papers:

- [Nick Tierney](https://twitter.com/nj_tierney/status/939800909978017792) felt desperate when being required to submit a Word version of the paper (presumably the paper was written in LaTeX or R Markdown).
