---
title: '301 Redirect: The Most Important Technique in Maintaining Websites'
date: '2017-11-19'
slug: 301-redirect
---

What do you feel when you click a link and get a "404 NOT FOUND" page? Probably not so good. If you are maintaining a static website, you should have absolutely no excuses of letting a link to any of your web page break now. Use [301 redirects](https://en.wikipedia.org/wiki/HTTP_301) when you must break the link to a web page or a resource. It is understandable when you need to change a URL, but it is not forgivable if you don't use a 301 redirect in this case, and just show your clueless vistors a 404 page. What else can they do other than flipping the table?...

![What else can you do other than flipping the table?](https://slides.yihui.org/gif/flip-table.jpg)

As [I recommended](/en/2017/06/netlify-instead-of-github-pages/) a few months ago, Netlify is my first choice when publishing static websites. It supports 301 and 302 redirects, and it is dead simple: basically you just drop a `_redirects` file containing the redirection rules. [Read the docs](https://www.netlify.com/docs/redirects/) for details.

So there is no need to tell your visitors that a certain page has been moved. Just redirect it to the new location and let them see the actual page. The extra bonus is that search engines are often aware of 301 redirects, and they will update the links in the search results accordingly after a while. As an example, [I suggested](https://github.com/rbind/apreshill/pull/1) Alison use the subdomain `alison.rbind.io` instead of `aprehill.rbind.io` a few weeks ago, and redirected `apreshill.rbind.io/*` to `alison.rbind.io/*` for her in [`static/_redirects`](https://github.com/rbind/apreshill/blob/master/static/_redirects). Now if you google for "Alison Hill blogdown", you should see that Google has updated the link with the new domain:

![Alison's website in Google search results](https://db.yihui.org/images/google-alison.png#border)

## Why not GitHub Pages?

GitHub Pages does not support 301 redirect at the moment. The best you could do is either JavaScript `window.location.href = "your.new.URL";`, or [meta refresh](https://en.wikipedia.org/wiki/Meta_refresh). Both ways are awkward. I recommend that you avoid these approaches when possible.

## An application: redirect HTTP links to to HTTPS

Similarly, you should not have any excuses of not enabling or even forcing HTTPS on your static websites: this is free on Netlify (again, [read the docs](https://www.netlify.com/docs/ssl/)). If you take a look at Alison's `_redirects` file, you will see this rule:

```
http://alison.rbind.io/*    https://alison.rbind.io/:splat  301!
```

Basically it means to redirect non-secure HTTP links to secure HTTPS links. If you didn't force SSL on Netlify, you can use this rule to achieve the same thing, but with a slight benefit that you are free to revert to non-secure links at any time. Forcing SSL means you website must be connected via SSL for the next year.

## Another application: redirect `*.netlify.com` to your own domain

If you use a custom domain on Netlify, I strongly recommend you to redirect the `*.netlify.com` subdomain to your own domain. Here are two rules from [my own `_redirects` file](https://github.com/yihui/yihui.org/blob/master/static/_redirects):

```
https://yihui.netlify.com/*  https://yihui.org/:splat  301!
http://yihui.netlify.com/*   https://yihui.org/:splat  301!
```

This makes sure that all visitors will see the same URLs consistently. It may be confusing if some visitors come to your website via `*.netlify.com`, while other visitors come through your own domain. The additional bonus is that this hides Netlify behind the scenes. If you decide not to use Netlify anymore, you are completely free to point your domain to a new server.

In all, please consider using redirects, and let there be no more broken links.
