---
title: No Need to Upgrade to Pandoc 2.0 (Yet)
subtitle: for R Markdown users
date: '2017-11-15'
slug: pandoc-2
---

Update on 2018-06-13

:   Half a year has passed, and I think the R Markdown ecosystem should be ready for Pandoc 2.x now. See [this post](/en/2018/06/time-for-pandoc-2-x/) for details.

Pandoc 2.0 was released two weeks ago. I have read its [release notes](https://github.com/jgm/pandoc/releases) a few times, and my conclusion is that for R Markdown users, there is no need to upgrade to Pandoc 2.0 from 1.x. I don't see any major benefits relevant to R Markdown. In fact, I'd encourage you to stay with Pandoc 1.19.x for now.

There are a few things that I don't like about Pandoc 2.0. I feel that the rules for nested lists are quite confusing after the four-space rule was disabled by default in Pandoc 2.0. It took me a while to understand the new rules. I'm not comfortable with the [changes in syntax highlighting](https://groups.google.com/forum/#!topic/pandoc-discuss/1bwAre8fG6E), either.

There have been a few breaking changes (which are expected, because of the major version number has been increased), which I had to deal with in the **rmarkdown** package as well as other R Markdown extension packages. The good news is that these changes are not too bad, and the current development versions of [**rmarkdown**](https://github.com/rstudio/rmarkdown), [**bookdown**](https://github.com/rstudio/bookdown), and [**flexdashboard**](https://github.com/rstudio/flexdashboard) should be compatible with Pandoc 2.0.2 now.

From what I can tell, users often upgraded to Pandoc 2.0 through Homebrew on macOS unconsciously (via `brew upgrade`), and they do not know an important fact: the RStudio IDE actually bundles Pandoc v1.19.2.1, so there is no need to install Pandoc separately if you use RStudio. If you want to use RStudio's Pandoc, you can remove the Homebrew versions:

```bash
brew remove pandoc pandoc-citeproc 
```

If you want RStudio's Pandoc to be available system-wide, you can add its path to the system environment variable `PATH`. The path can be found in the environment variable in RStudio:

```r
Sys.getenv('RSTUDIO_PANDOC')
```

On macOS, it should be `/Applications/RStudio.app/Contents/MacOS/pandoc`, so you can export it in `~/.bash_profile`, e.g.,

```bash
export PATH="$PATH:/Applications/RStudio.app/Contents/MacOS/pandoc"
```

Anyway, if you must use Pandoc 2.0, try the development versions of these R packages (we will release them to CRAN soon), but personally I just don't see any major benefits of upgrading to Pandoc 2.0.
