---
title: Different Degrees of Freedom for Bloggers and Book Authors
date: '2017-10-04'
slug: bloggers-vs-book-authors
---

Peter Baumgartner notified me of [his 4-part tutorial for **blogdown**](http://notes.peter-baumgartner.net/tutorial/). I was about to go to bed at this time, but I don't regret spending time on reading his tutorial, since it is a really good one. So good that I have nothing more to add. Strongly recommended.

This tutorial did remind of one thing that I have been hoping to talk about, which is the different degrees of freedom for bloggers and book authors. I mean literally the degrees of freedom, not the concept in statistics. 

As a book author, I often feel jealous of bloggers especially when they write software tutorials, because I don't have so much freedom as them. For a book, I need to be very careful about screenshots that show "modern technologies", because perhaps ironically, "modern technologies" often tend to change (even from day to day). Once a book is printed, I don't want readers to hate me because when they check out something I mentioned in the book only to realize it is different now. The second edition of the book may take a couple of years to be finished and printed again. 

By comparison, bloggers have a lot more freedom. They don't need to worry much about typesetting, and they can update their posts or tutorials from day to day. Readers can always see the latest versions, unlike books, which will continue to mislead readers for years once printed if there are any problems.

That basically explains why my books are boring to read. I have to eliminate things that may change in the next few years, even though they may be super helpful, such as screenshots. Do I love screenshots? Absolutely! Screenshots will make it much easier for new users to follow certain steps than text descriptions. Peter's tutorial is full of screenshots. So is [Alison's](https://apreshill.rbind.io/post/up-and-running-with-blogdown/). So is [Amber's](https://proquestionasker.github.io/blog/2016/12/19/creatingsite/). But I can only add boring links in the book (and pray they won't be broken in the next few years), instead of taking screenshots of these web pages.

![boring](https://slides.yihui.org/gif/give-up.gif)
