---
title: 'Python: The Incredibly Confusing Language?'
date: '2017-09-11'
slug: python-the-incredibly-confusing-language
---

Last week David Robinson published an interesting post titled "[The Incredible Growth of Python](https://stackoverflow.blog/2017/09/06/incredible-growth-python/)". Just like naming is hard, I think coming up with a proper title of an article is also hard. In this article, "growth" was defined by StackOverflow traffic. I certainly don't mean to criticize David here (he has written so many informative and useful articles and blog posts), but I feel a lot of articles on the internet are not properly titled. This problem is particularly severe when a title uses very abstract words that do not immediately reflect what they actually mean. In this example,[^1] when a reader sees "growth", she might think "Python has gained an incredible amount of new users", but is the Stack Overflow traffic a reasonable indicator of the number of Python users? I don't know. Another common title that often bothers me is "the 5 most popular packages (or developers)": what is so wrong about saying "the 5 most downloaded packages"?

A lot of people visiting Stack Overflow probably also means Python is highly confusing or the documentation is poor in general, so these people have to constantly search for answers on Stack Overflow. Is that one possible explanation for the "growth"? I think it is. Well, I don't want to be too cynical: I believe Stack Overflow traffic can indicate the number of Python users is growing. I just don't know how good this indicator is. I apologize for the intentionally poor title of my blog post here.

[In 2012](https://bitbucket.org/stat/www/downloads/2013-RevoR-Yihui-Xie.pdf) I started to believe that sometimes FAQ's are nearly bugs.[^2] People having too many questions or asking the same questions over and over again is not necessarily a good sign for a software package or language.

[^1]: I have seen many other examples, e.g., the post titled "[Introduction to Statistics using NumPy](https://mubaris.com/2017-09-09/introduction-to-statistics-using-numpy)" was all about mean, median, variance, and standard deviation. That is a ridiculously broad and abstract title. These four descriptive statistics are just a tiny tiny portion of "statistics". Why not title the post "How to calculate the mean, median, variance, and standard deviation with Numpy"?

[^2]: I'm not saying the **bookdown** package is free of bugs, but I intentionally listed only [one FAQ](https://bookdown.org/yihui/bookdown/faq.html) in the book.
