---
title: How I Find, Manage, and Use GIFs
date: '2017-05-18'
slug: gifs
---

A few months ago [Jenny](https://twitter.com/JennyBryan) wanted me (and Karthik, if I remember correctly) to share some experience with GIFs. I have been busy with writing the [**blogdown** book](https://bookdown.org/yihui/blogdown/) recently and don't really have much time, so I'm going to write a quick post just to take a short break. I may expand this post in the future.

First things first. I tend to pronounce "GIF" with the _soft_ G, but I feel there are more people pronouncing the hard G. Since my native language is not English, I usually try to say the hard G when I speak in English (and soft G in Chinese). I'm fine with either way, and I promise I won't [turn your skull into a toilet](http://theoatmeal.com/comics/gif).

## Where do I find GIFs?

Twitter is my primary source. I don't follow a lot of people on Twitter since I don't want to spend much time on social media,[^1] and I follow two accounts [@AmazingGlFS](https://twitter.com/AmazingGlFS) and [@ThingsWork](https://twitter.com/ThingsWork). Of course, many people often tweet with GIFs every day, and I will collect a few funny ones occasionally.

I used to collect GIFs from WeChat, too, but recently I found WeChat disabled downloading images from the articles published there. I was disappointed but that is okay. I don't collect GIFs frequently anyway.

When I see a funny GIF on Twitter, I copy the URL of the tweet and paste to [ezgif.com](https://ezgif.com/optimize) to convert the MP4 video[^2] to GIF and optimize it a little bit.

[Giphy](https://giphy.com) has tons of GIFs but I rarely actively look for GIFs there. I often save a GIF from a context, such as in a Tweet. The context will give me more inspiration.

## How do I manage GIFs?

I don't have a clever method to manage my GIFs. I simply store them in a Dropbox folder. All my slides, which you can find in my [CV](/en/vitae), are hosted in Dropbox via [Updog](https://updog.co)[^3] and I have assigned a subdomain slides.yihui.org to serve these (HTML) slides as well as the GIFs. For example, https://slides.yihui.org/gif/goose-smile.gif actually points to a GIF file in my Dropbox folder.

I don't have a huge amount of GIFs in this folder (less than 100), so I don't need a clever method for indexing or searching. I can remember most of them in my mind. The filenames are typically very short, like [happy-elmo.gif](https://slides.yihui.org/gif/happy-elmo.gif) and [mad-panda.gif](https://slides.yihui.org/gif/mad-panda.gif).

I only collect the very good ones, and there are not many. For example, you may think I was silly, but I was excited to see the [quick fox](https://slides.yihui.org/gif/quick-fox.gif) finally jumped over the brown dog. It feels like I had been waiting for this since 2002 (the first year I started using computers).

Sometimes static images are also funny. The one that made me smile the most is the [Moustache Karl](https://slides.yihui.org/gif/karl-broman.jpeg)(TM) (it is like a male version of the Mona Lisa in my eyes and it makes me happy for mysterious reasons). Another example is those two-step instructions, such as [how to draw an owl](https://slides.yihui.org/gif/draw-an-owl.jpg) and [how to flip a table](https://slides.yihui.org/gif/flip-table.jpg) (I collected the latter from one of Karl's recent tweets).

## How do I use GIFs?

In short, you must have a strong ability of association. When I collect a GIF, I often have already got vague ideas of its possible use in my talks and I can associate it with software packages or techniques. So far I have been intentionally trying to avoid showing you actual GIFs in this post, because I don't want to distract, but now I need to show you an example of association:

![git push --force](https://slides.yihui.org/gif/git-push-force.gif)

I'm not sure what would come to your mind when you see this GIF, but I guess the keyword is "force". One application of this GIF is to show the dreadful command line `git push --force`, and warn your audience not to do it. Another slightly less appropriate application is just to show the power of something, e.g., R Markdown [added much more force](https://slides.yihui.org/2016-useR-bookdown-Yihui-Xie.html#(9)) to Markdown thanks to R and Pandoc. 

When I prepare a talk, I will open the Dropbox folder. As I work on the slides, I will have all kinds of random thoughts, and some of them may be expressed in GIFs. I think I'm fairly good at associating random things with each other, and the consequence is unexpectedness, which can lead to fun. [Here is an example](https://github.com/yihui/knitr/issues/1322) of how I associated a totally normal GitHub issue from Amelia to two GIFs, so that I could say no to a feature request that I was not interested in, (hopefully) without letting her down or making her feel too sad. Sometimes it works, and [sometimes](https://github.com/wch/r-source/commit/74c8486a039) people don't get it.

Even though I'm fairly familiar with the GIFs I collected, sometimes I could be shocked to know the actual stories behind them. Last year [when I announced ](https://twitter.com/xieyihui/status/752577793687379968) the first CRAN release of **bookdown** and asked for testing, I thought the scenes in the GIF were fake (who would possibly do the high bar over there!!) but someone told me it was [a real story](http://gizmodo.com/5951446/this-guy-somehow-survived-a-free-fall-from-a-4000-foot-cliff), and the man survived after he fell off the cliff.

## Can you share the full collection of your GIFs?

No.[^4]

## Amusing ourselves to death

Okay, now let's put away the fun for a moment.

Recently my bed reading time has been spent on the book "[Amusing Ourselves to Death](https://en.wikipedia.org/wiki/Amusing_Ourselves_to_Death)" (I'm reading a Chinese translation), and it is the first book that has made me feel anxious. I have been rethinking the many presentations that I have made over the years, and I think many people are familiar with my style now and even kind of expect GIFs in my talks. I want to make my talks entertaining because I often lose my attention when I attend other people's talks. That is also the reason I usually avoid deep technical stuff in my talks (you can read the documentation any time after the talk by yourself instead of having me read the documentation out loud in 15 mins in front of you).

I have been trying to amuse the audience but I certainly do not want to amuse you to death (good intention [does not necessarily](https://slides.yihui.org/gif/save-him.gif) lead to good results). I hope you can laugh and remember, instead of laughing then forgetting (like what was described as the effect of TV in the book).

GIF is an effective way to get people's attention, but I guess we will need some time to think and check [what is actually left](https://slides.yihui.org/gif/you-get-nothing.gif) after the laughter. I'll truly appreciate it if you have ever attended any of my talks, but want to leave me some negative comments on my presentation style.

[^1]: I use a Chrome extension named "StayFocusd" and limit my Twitter reading time to be 10 mins every day.

[^2]: Twitter used to let us post GIFs directly but last year it started to convert GIF to MP4 for technical reasons.

[^3]: Updog used to be cheap. When I became a Pro member, it only cost my $5 in total for lifetime membership. Now it is a little bit expensive. GIFs are static files, so you have many other choices to host them, although maybe not as convenient as Updog. Or you can use the free plan of Updog only to serve your GIFs but not HTML slides.

[^4]: On one hand, I don't own these GIFs and I didn't create them. On the other, I want you to think more carefully when deciding whether you want to download a GIF. You won't value them if you are suddenly given 100 GIFs that I carefully collected over the years.
