---
title: Some Facts about Jeff Leek
date: '2017-04-14'
slug: jeff-leek-facts
---

> **Note**: What other facts about Jeff Leek do you "know"? Please feel free to click the link "Edit this page" in the navigation menu and submit a pull request on GitHub, or tweet with the hashtag [#jeffleekfacts](https://twitter.com/hashtag/jeffleekfacts).

I have not written blog posts for quite a while. It is not because I don't have anything to write. On the contrary, I have a huge amount of things that I could have written about, e.g., how I collect and manage GIFs, and some stories behind the publication of the [bookdown book](https://bookdown.org/yihui/bookdown). A lot of things have happened since the last time I wrote a post here. I'll explain them later this year.

Today I started this post only because I love memes and rumors (with no bad intentions), especially those about the guys behind [Simply Statistics](http://simplystatistics.org). These guys are a lot of fun. So [Jeff Leek asked on Twitter](https://twitter.com/xieyihui/status/852205086956818432) the other day about an R interface to Alexa Skills (Cc'ed me probably because of my [Shiny Voice](https://yihui.shinyapps.io/voice) app).

I don't know anything about Alexa, but the funny thing was that [rumors quickly emerged in the replies](https://twitter.com/xieyihui/status/852294292928200704).

And I just wanted to collect these unknown "facts" about Jeff A-leek-sa:

- @DrJWolfson: Jeff Leek smooths densities with his bare hands.

- @tslumley: Jeff Leek can do zero-fold crossvalidation.

- @xieyihui: Jeff Leek supports both vector and matrix machines.

- @TrestleJeff: `stringsAsFactors` defaults to `FALSE` in Jeff Leek's presence.

- @rdpeng: Jeff can convert data frames to matrices with his mind.

- @drob: Jeff Leek's error messages contain the cure for cancer. Unfortunately, he's never seen one.

- @drob: Any statistic is a sufficient statistic when it's Jeff Leek using it.

- @seankross: Jeff Leek has no need for the Tidyverse. Any data he touches tidies itself out of a combination of respect and fear.

- @joranelias: All Jeff Leek sequences of random variables converge surely in probability.

- @kennyshirley: Correlation implies whatever Jeff Leek tells it to imply.

- @just\_add\_data: Jeff Leek doesn't trade off bias and variance.

- @bcaffo: Jeff Leek counted to infinity. Twice.

    - @DrJWolfson: Using only the irrationals.
    
    - @bcaffo: Which reminds me that Jeff Leek can make square root of 2 rational.

- @bcaffo: Jeff Leek can fit a regression line with one point. And get a variance.

- @mjfrigaard0: Jeff Leek once won a Kaggle competition, but was disqualified for using his abacus.

- @mjfrigaard: Git commits to Jeff Leek.

- @mjfrigaard: Jeff Leek can lift the curse of dimensionality by merely glancing at your data.

- @clarkfitzg: All P-values computed by Jeff Leek are significant.

- @jrnld: Singular matrices are so named because Jeff Leek is the only one who can invert them.

- @rikturr: Jeff Leek's cubic splines are all linear.

- @butterflyology: Jeef Leek supports S3 and S4 classes, at the same time.

- @tpoi: When Jeff Leek uses `<-<-`, it tests for equality

- @Miao\_Cai\_SLU: Jeff build regression models without endogeneity.

- @brandenco: CRAN checks itself before it submits to Jeff Leek.

- @BeEngelhardt: When Jeff Leek inverts a matrix, time actually reverses `$O(n^3)$`.

- @michaelhoffman: Jeff Leek is the Uniformly Most Powerful Jeff.

- @pachamaltese: Jeff Leek always obtains unbiased estimators.

- @rdpeng (a few days later): Ok, who knew that Slack was an acronym?

    - @sherrirose: Jeff Leek knew that Slack was an acronym.

    - @rdpeng: Nice. I deserved that.

- @EamonCaddigan: Jeff Leek can quickly process several yottabytes of data in memory. HIS memory.

- @butterflyology: If you install Jeff Leek, there are no dependencies. Because Jeff Leek depends on nothing.

- @DrJWolfson: Jeff Leek cannot be replicated, but he is fully reproducible.

- @pdalgd: Jeff Leek can make code work just by waiting for it!

- @TrestleJeff: R Core was founded as a Jeff Leek tribute band.

I'm looking forward to yet more facts.

![More](https://slides.yihui.org/gif/dog-reach.gif)
