---
title: A Letter of Recommendation for Nan Xiao
date: '2014-11-18'
slug: lor-nan-xiao
---

> I hope my letter could boost this guy up like:
> 
> ![](https://db.yihui.org/imgur/kmzQife.gif)

I'm not sure if I'm a good observer, but time and time again I feel some people are undervalued, or they were not given better opportunities to show their value. Not surprisingly, I know quite a few such people in the Chinese R/stats community, mainly because of the website [Capital of Statistics](https://cosx.org) (COS) that I founded a number of years ago.

I believe Nan Xiao is among these undervalued people, which is why I'm writing a public letter of recommendation for him to apply to a stats/biostats/bioinformatics program in the US. You can go to his website <http://r2s.name> to know more about him, and I'm not going to repeat his information here.

As someone who went through the same application process six years ago, I know it is difficult to get an offer unless you are from a top university in China in the eyes of the admission committee. By "top" (in terms of the major of statistics), it basically means Peking U, Tsinghua, USTC, Fudan, Beijing Normal U, and perhaps one or two other universities. My alma mater was Renmin U (in Beijing), which nobody knows, unfortunately. The statistics program at Renmin actually has got the highest ranking in China this year, and I'm not surprised at all. Perhaps Renmin does not offer the best math training to students in statistics, but I think its program is well balanced between application and theory. In recent years, they have been putting more emphasis on the math training to catch up with the "top" universities. Personally I do not think this is a good idea, but it seems to make the admission committees in the US more comfortable. Anyway, the first driving force of my admission to Iowa State U was probably my work on the [animation](http://cran.rstudio.com/package=animation) package, which was also why I was acquainted with my PhD advisors Di and Heike before I applied to Iowa State.

To some degree, I was very fortunate since my research interest, statistical graphics, at that time was not the "mainstream" in statistics (it still is not), and it happened that there were two professors with the same research interest, so it was fairly easy to make the deal. Nan's interests (machine learning/bioinformatics) are broader than mine, and I think he will face more competition consequently. Given his education background from a university that is not widely known, I'm trying to make him more visible, although my influence might be very limited. I believe he will make better contribution during his PhD training than me, if his potential can be well utilized.

I have known Nan for quite a few years. We have physically met only once during the 6th Chinese R conference last year, but I have been reading his forum posts in COS and blog posts since circa 2008. He is one of the best hackers that I know, with a very good sense of beauty. Apparently, hacking skills are becoming more and more important in this age of data (excuse me, but I do hate saying "big data" when "big" is meaningless). Let me enumerate some of my observations about him:

- He knows well about the web (scraping data, security issues, and so on). To his future advisor/department, this means he could be very helpful if you need to obtain data from the web, and he may be able to improve the department IT support, which often sucks from my experience.
- He is a superb presenter. He has an outstanding presenting style, which you can see from his past [talks](http://r2s.name/talks.html) (it does not matter if you do not understand Chinese). You may underestimate the importance of this, but please recall how much you (or is it just me?) wanted to fall asleep during the Joint Statistical Meetings, when everybody was using the same blue Beamer style, with pages after pages of equations.
- My favorite illustration among his blog posts is this one: <http://r2s.name/cn/r/ria.html>
- He has deep interests in data visualization, in particular, network visualization. Look at his list of [papers](http://r2s.name/papers.html) on his website! Aren't those graphs beautiful?
- He has worked on the translation of three books into Chinese with other people. To translate a book, you certainly have to understand it. You probably should not have any doubts on how well he knows R, graphics, and data mining methods.
- I do not formally collaborate with him very often, but you may want to look at the SVD example in his [projects](http://r2s.name/projects.html). He did it after I said "How about a Shiny app?". I believe there have been many other SVD examples with the similar idea, but I was still impressed how quickly he made it. If you are familiar with Shiny, you may also be impressed by his taste on design (I love the "Crouching Tiger Hidden Dragon" picture. Looks so cool!).
- I know little about bioinformatics, chemoinformatics, or pharmacology, so I'm not going to comment on these specifics. There is one thing that I'm sure about, though, which is his eagerness for making substantial contributions to science that can eventually benefit some people. I trust his sincereness.

If you are looking for a PhD student in a stats-related program in 2015, please consider this guy. A job in the industry is also a possibility for him, so please also consider him if your company has a position for an awesome hacker. Email me if you have more questions, or forward my blog post to your colleagues/friends who might be interested.
