---
title: A Few Notes on UseR! 2014
date: '2014-07-26'
slug: a-few-notes-on-user2014
---

It has been a month since the UseR! 2014 conference, and I'm probably the last one who writes about it. UseR! is my favorite conference because it is technical and not too big. I have completely lost interest in big and broad conferences like JSM (to me, it has become Joint Sightseeing Meetings). Karl has written two blog posts about UseR! ([1-2](http://kbroman.wordpress.com/2014/07/02/2014-user-conference-days-1-2/), [3-4](http://kbroman.wordpress.com/2014/07/21/user-2014-days-3-4/)), and I'm going to add a few more observations here. An important disclaimer before I move on: Karl Broman is not responsible for videotaping at UseR! 2014 (neither am I), and he is not even on the conference committee. I accidentally mentioned the videos when replying [his tweet](https://twitter.com/xieyihui/status/491286793338118144), which seemed to have caused confusion unfortunately. Any questions about the conference, including the time to publish videos, should be directed to the official organizing committee.

The [conference website](http://user2014.stat.ucla.edu/) is hosted on [GitHub](https://github.com/user2014/user2014.github.io). Awesome. Speakers can add links to their slides through pull requests. Genius. It is a little sad, though, that each UseR conference has its own website and twitter handle. There should have been a single website, a single domain name, and a single twitter account managing all the R conferences each year. Fragmentation is just such a natural thing in programmers' world.

The on-campus dorms were fantastic (oh when I wrote "dorm" I almost typed "dnorm"), which saved us time on transportation. Dining halls were on campus as well. Breakfast was perfect, although I could not stand eating sandwiches, hamburgers, or pizza for four days. Okay, let's talk about the talks. You can find most of the slides on the conference website.

- John Chambers: the three promising projects Rcpp/Rcpp11, RLLVM, and h2o. I do not know anything about h2o. I think Rcpp has been a great success, and I have my blind faith in Romain for Rcpp11. For RLLVM, I'm a little concerned: 15 stars, and 4 forks on [GitHub](https://github.com/duncantl/Rllvm). That is not a good sign. The [bus factor](https://en.wikipedia.org/wiki/Bus_factor) is too low. Well, I have been admiring Duncan for a huge number of his amazing packages. Perhaps he can handle this one on his own as well.
- Ramnath Vaidyanathan: all JavaScript libraries [are belong](https://en.wikipedia.org/wiki/All_your_base_are_belong_to_us) to Ramnath! If you want to get a certain JS library integrated with R, tell him the night before, go to sleep, and you will see it in the R world the next morning. I'm only partially kidding :)
- Gordon Woodhull: it was great to see the substantial progress in RCloud.
- Jeroen Ooms: I came from the [RWeb](http://users.stat.umn.edu/~geyer/r.html) age, so you know how excited I was when I saw [OpenCPU](https://www.opencpu.org/) a couple of years ago. There were things I wished I could do for years but were too complicated before OpenCPU was launched. For example, the **knitr** issue [#51](https://github.com/yihui/knitr/issues/51) was probably my first experiment with OpenCPU, and I had a lot of fun with it.
- Jonathan Godfrey: I did not attend his talk, but he attended my tutorial and talked to me a couple of times during the conference. That was the first time I had talked to a blind R user, and was surprised to know a few facts:
    - PDF is bad for blind people, and HTML is much better (think R package vignettes);
    - it is nearly impossible for them to read raster images, and SVG graphics can be better;
    - if there is an image in an HTML document, its `alt` attribute is very important;
    - LaTeX math expressions created by MathJax look excellent in the eyes of sighted people, but they seem to be hard to read by the blind (Jonathan mentioned to me afterwards that it may be possible to configure MathJax to make it readable but he is not sure how to do it; the math expressions on Wikipedia are displayed as images with the `alt` attribute, and he can read those math expressions);
- Matt Dowle: his **data.table** story with Patrick Burns was pretty interesting. You can read his slides.
- Aran Lunzer: LivelyR. It was not a talk. It was simply magic. I had absolutely no clue how they made it, even though I'm one of the (co-)authors of the packages that they used.
- Dirk Eddelbuettel: Rcpp and Docker. I was really glad that he mentioned Docker. Travis CI seems to have attracted a lot of attention of R package authors after I was inspired by a reader of my blog and experimented with it [last year](/en/2013/04/travis-ci-general-purpose/). The major missing piece on Travis CI is R for R users. `apt-get install r-base` every time is a waste of time and resources. It will be nice if one can build one's own virtual machine with all the necessary packages. This is pretty simple with Docker. However, I have not found a free service like Travis CI that allows the users to build/test software with custom Docker containers.
- Martin Mächler: good practices in R programming. You can find slides on his homepage. This was an excellent talk. Precise and clear. I recommend everyone to read his slides. One minor and subjective issue is `=` vs `<-`. Not many people are with me, and once [Alyssa Frazee](http://alyssafrazee.com/introducing-R.html)'s post made me cried a little in the restroom (so excited to find another person using `=` in R).
- Andy Chen: RLint. Programming styles? I guess a single programming style will never happen. I insist on using `=` instead of `<-` for assignment in R, except when I collaborate with the left arrow party. Roger Peng insists 8 spaces for indentation. Excuse me? What is a programming style?
- John Nash: it was a great pleasure to meet John in person for the first time. I love hearing old stories from senior people, such as Jeff Laake telling me early stories about ADMB and CRAN, and John Kimmel mentioning John Tukey and the development of interactive graphics at Bell Labs. John (Nash) showed me some Fortran, Pascal, and BASIC programs to me that were even older than me. Personally I have no interest in these languages, but it was interesting to know what were done before you were born, and some of the programs are still "alive" in R. Since he was so eager for running Fortran code in **knitr** documents, we sat together for a few minutes, he wrote a Fortran example, and I just [added](https://github.com/yihui/knitr/commit/7caadc9c33) a quick and dirty Fortran engine in **knitr**.
- I gave a talk titled "Knitr Ninja", and a few people remembered `sword(2)` after that. I was extremely bored by myself after I had given so many talks on **knitr**, so I thought I should do a completely different talk that nobody had heard of, including [my bosses](https://twitter.com/jcheng/status/484758665593749505) at RStudio. It turned out that the RStudio viewer was pretty handy for presentations, and I could show Kakashi in it:

    ![Kakashi Lightning Blade](https://db.yihui.org/imgur/VzrEYWJ.jpg)

- Katharine Mullen: JSS. Honestly I'm a little concerned about JSS, although I strongly believe it is an outstanding journal. I have only published one paper on it (the **animation** package), and the review process was too slow. Four months goes by and you hear nothing back so you ask what's up. Then four months goes by, you get the first round of review. Sometimes I do not quite understand how free journals work, or what motivates the anonymous reviewers. I think this is a pretty hard problem, and I would [propose](/en/2012/03/a-really-fast-statistics-journal/) to open up the journal to the wild just like open source software. Even 58 editors on board is still too few compared to the number of authors and submissions. I was extremely excited that Jan de Leeuw's very first proposal of establishing such a journal was that the journal should be done in HTML!! And _interactive_, where possible!! That was the year 1995 (I was still in the fifth grade in elementary school learning fractions in a village). Twenty years later, I think the infrastructure is good enough (e.g. R Markdown, Shiny, Shiny Server) to go back to his original proposal. I would love to see papers in HTML instead of PDF. Typesetting with HTML is a whole lot easier and attractive than LaTeX/PDF in my opinion, and there is a whole lot more interesting stuff to play with in HTML. With R Markdown v2, HTML and PDF are not mutually exclusive, although we will have to give up certain markups in LaTeX, but man, do you really need `\proglang{}` and `\pkg{}`?
