---
title: My first Bioconductor conference (2013)
date: '2013-07-21'
slug: bioconductor-2013
---

The [BioC 2013 conference](https://secure.bioconductor.org/BioC2013/) was
held from July 17 to 19. I attended this conference for my first time,
mainly because I'm working at the Fred Hutchinson Cancer Research Center
this summer, and the conference venue was just downstairs! No flights, no
hotels, no transportation, yeah.

Last time I wrote about my [first ENAR
experience](/en/2013/03/on-enar-or-statistical-meetings-in-general/), and
let me tell you why the BioC conference organizers are smart in my eyes.

## A badge that never flips

I do not need to explain this simple design -- it just will not flip to the
damn blank side:

![](https://db.yihui.org/imgur/fOy3LtR.jpg)

## The conference program book

The program book was only four pages of the schedule (titles and speakers).
The abstracts are online. Trees saved.

## Lightning talks

There were plenty of lightning talks. You can talk whatever you want.

## Live coding

On the developer's day, Martin Morgan presented some buggy R code to the
audience (provided by [Laurent
Gatto](http://proteome.sysbiol.cam.ac.uk/lgatto/)), and asked us to debug it
right there. Wow!

## Everything is free after registration

The registration includes almost everything: lunch, beer, wine, coffee, fruits,
snacks, and most importantly, Amazon Machine Instances (AMI)!

## AMI

This is a really shiny point of BioC! If you have ever tried to do a
software tutorial, you probably know the pain of setting up the environment
for your audience, because they use different operating systems, different
versions of packages, and who knows what is going to happen after you are on
your third slide. At a workshop last year, I had the experience of spending
five minutes figuring out why a keyboard shortcut did not work for one
Canadian lady in the audience, and it turned out she was using the French
keyboard layout.

The BioC organizers solved this problem beautifully by installing the
RStudio server on AMI. Every participant was sent a link to the Amazon
virtual machine, and all they need is a web browser and wireless connection
in the room. All people run R in exactly the same environment.

Isn't that smart?

## Talks

I do not really know much about biology, although a few biological terms
have been added to my volcabulary this summer. When a talk becomes
biologically oriented, I will have to give up.

Simon Urbanek talked about big data in R this year, which is unusual, as
mentioned by himself. Normally he shows fancy graphics (e.g. iplots). I did
not realize the significance of this [R 3.0.0
news](http://cran.r-project.org/src/base/NEWS.html) item until his talk:

> It is now possible to write custom connection implementations outside core
  R using `R_ext/Connections.h`. Please note that the implementation of
  connections is still considered internal and may change in the future (see
  the above file for details).

Given this new feature, he implemented the [HDFS
connections](https://github.com/s-u/hdfsc) and [0MQ-based
connections](https://github.com/s-u/zmqc) in R single-handedly (well, that
is always his style).

You probably have noticed the previous links are GitHub repositories. Yes!
Some R core members really appreciate the value of social coding now! I'm
sure Simon does. I'm aware of other R core members using GitHub quietly (DB,
SF, MM, PM, DS, DTL, DM), but I do not really know their attitude toward it.

Joe Cheng's Shiny talk is shiny as usual. Each time I attend his talk, he
will show a brand new amazing demo. Joe is the only R programmer that makes
me feel "the sky is the limit (of R)". The audience were shocked when they
saw a heatmap that they were so familiar with suddently became interactive
in a Shiny app! BTW, Joe has a special sense of humor when he talks about
an area in which he is not an expert (statistics or biology).

RStudio 0.98 is going to be awesome. I'm not going to provide the links
here, since it is not released yet. I'm sure you will find the preview
version if you really want it.

## Bragging rights

- I met Robert Gentleman for the first time!
- I dare fall asleep during Martin Morgan's tutorial! (sorry, Martin)
- [some](http://www.bioconductor.org/help/workflows/) Bioconductor web pages
  were built with knitr/R Markdown!

## Next steps

Given Biocondutor's open-mindedness to new technologies (GIT, GitHub, AMI,
Shiny, ...), let's see if it is going to take over the world. Just kidding.
But not completely kidding. I will keep the conversation going before I
leave Seattle around mid-August, and get something done hopefully.

If you have any feature requests or suggestions to Bioconductor, I will be
happy to serve as the "conductor" temporarily. I guess they should set up a
blog at some point.
