---
title: "Curriculum Vitae"
slug: "en/vitae"
disable_comments: true
---

# Yihui Xie

## Contact Information

<p>
<!--
Address: 560 S 183rd Ave, Elkhorn, NE 68022  
-->
</p>

Email: xie@yihui.org; Homepage: <https://yihui.org>; Mastodon [@yihui@mastodon.social](https://mastodon.social/@yihui); Twitter [@xieyihui](https://twitter.com/xieyihui).

## Brief Biography

[Yihui Xie](https://en.wikipedia.org/wiki/Yihui_Xie) was a software engineer at [Posit, PBC](https://posit.co) from 2013 to 2023. Since 2024, he has been working for Posit, Swiss Re, and Merck as a contractor. He earned his PhD from the Department of Statistics, Iowa State University. He is interested in interactive statistical graphics and statistical computing. As an active R user, he has authored several R packages, such as **knitr**, **bookdown**, **blogdown**, **xaringan**, **animation**, **DT**, **tinytex**, **pagedown**, **tufte**, **formatR**, **fun**, **servr**, and **Rd2roxygen**, among which the **animation** package won the 2009 John M. Chambers Statistical Software Award (ASA). He also co-authored a few other R packages, including **shiny**, **rmarkdown**, **rticles**, and **leaflet**. He has published a number of books, including "Dynamic Documents with R and knitr", "bookdown: Authoring Books and Technical Documents with R Markdown", "blogdown: Creating Websites with R Markdown", "R Markdown: The Definitive Guide", and "R Markdown Cookbook."

In 2006, he founded the Capital of Statistics (<https://cosx.org>), which has grown into a large online community on statistics in China. He initiated the Chinese R conference in 2008, and has been involved in organizing R conferences in China since then. During his PhD training at Iowa State University, he won the Vince Sposito Statistical Computing Award (2011) and the Snedecor Award (2012) in the Department of Statistics.

## Professional Interests

Reproducible research; statistical computing; statistical graphics; data visualization.

## Education Background

- 2009 ~ 2013, PhD in Statistics, Department of Statistics, Iowa State University
- 2006 ~ 2009, Master of Economics, School of Statistics, Renmin University of China
- 2002 ~ 2006, Bachelor of Economics, School of Statistics, Renmin University of China

## Honors & Awards

- [Snedecor Award](http://stat.iastate.edu/graduate-financial-support), 2012 (the most outstanding PhD candidate in the Department of Statistics, Iowa State University)
- Honorable Mention Prize, the Applications of R in Business [Competition](http://bit.ly/wx4bFb), 2012
- [Vince Sposito](http://stat.iastate.edu/graduate-financial-support) Statistical Computing Award, 2011 (Department of Statistics, Iowa State University)
- John M. Chambers Statistical Software [Award](https://community.amstat.org/jointscsg-section/awards/john-m-chambers), ASA, 2009 (for the R package [animation](https://github.com/yihui/animation))
<!--
- Excellent graduate scholarship, Renmin University of China, 2007
- Successful Participant, Mathematical Contest in Modeling (America), 2006 ([paper](https://db.yihui.org/docs/MCM-2006-paper-Yihui-Xie.pdf); [certificate](https://db.yihui.org/imgur/c3soC.jpg "Certificate of Mathematical Contest in Modelling (America)"))
- Excellent graduate of Renmin University of China, 2006
- "Excellent Worker in Student Media" of Renmin University of China, 2006 (for hosting the website of statistics discussions in <https://cosx.org>)
- Scholarship for outstanding learning, Renmin University of China, 2005
-->

## Publications

See my [Google Scholar page](https://scholar.google.com/citations?user=lkjqsd4AAAAJ&hl=en) for a full list of publications.

### In English

Books and book chapters:

1. Yihui Xie, Christophe Dervieux, Emily Riederer (2020). [_R Markdown Cookbook_](https://bookdown.org/yihui/rmarkdown-cookbook). Chapman & Hall/[CRC](https://www.routledge.com/p/book/9780367563837). ISBN 9780367563837.
1. Yihui Xie, J. J. Allaire, Garrett Grolemund (2018). [_R Markdown: The Definitive Guide_](https://bookdown.org/yihui/rmarkdown). Chapman & Hall/[CRC](https://www.crcpress.com/p/book/9781138359338). ISBN 9781138359338.
1. Yihui Xie, Amber Thomas, Alison Presmanes Hill (2017). [_blogdown: Creating Websites with R Markdown_](https://bookdown.org/yihui/blogdown). Chapman & Hall/[CRC](https://www.crcpress.com/p/book/9780815363729). ISBN 9780815363729.
1. Yihui Xie (2016). [_bookdown: Authoring Books and Technical Documents with R Markdown_](https://bookdown.org/yihui/bookdown). Chapman and Hall/[CRC](https://www.crcpress.com/product/isbn/9781138700109). ISBN 9781138700109
1. Yihui Xie (2015). [_Dynamic Documents with R and knitr_](http://www.crcpress.com/product/isbn/9781498716963). 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963
    - Yihui Xie (2013). [_Dynamic Documents with R and knitr_](http://www.crcpress.com/product/isbn/9781482203530). Chapman and Hall/CRC. ISBN 978-1482203530
1. Yihui Xie (2014). knitr: [_A Comprehensive Tool for Reproducible Research in R_](http://www.crcpress.com/product/isbn/9781466561595). In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595

Papers:

1. Yihui Xie, Heike Hofmann, and Xiaoyue Cheng (2014). _Reactive Programming for Interactive Graphics_. Statistical Science, 29(**2**), 201-213. ([PDF](https://bitbucket.org/stat/www/downloads/STS477.pdf))
1. Yihui Xie (2013). _animation: An R Package for Creating Animations and Demonstrating Statistical Methods_. Journal of Statistical Software, 53(1), 1-27. URL <http://www.jstatsoft.org/v53/i01/>
<!--
1. Yihui Xie and Xiaoyue Cheng, 2008. _animation: A Package for Statistical Animations_, R News, 8(**2**). URL: <http://www.r-project.org/doc/Rnews/Rnews_2008-2.pdf>
1. Yihui Xie, 2007. _Visualization of Data and Statistical Models Using R_, Proceedings of the 3rd Conference on Australia-China Free Trade Agreement (ACFTA): Econometric Modeling and Policy in Trade, Investment and Economic Integration ([PDF](https://db.yihui.org/docs/R-visualization-paper-2007-Yihui-Xie.pdf))
-->

### In Chinese

Books:

1. Peng Zhao, Yihui Xie, Xiangyun Huang (2021). [_Modern Statistical Graphics_](https://bookdown.org/xiangyun/msg/). [Posts & Telecom Press Co., Ltd.](https://www.ituring.com.cn/book/2951) ISBN 9787115566904.
1. [R Ninja](https://bookdown.org/yihui/r-ninja) (under development)

Papers:

<!--
1. Yanyun Zhao, Nailin Feng, Yuncheng Zhao, Yihui Xie, Ning Xiao, 2008, Research on the National Quality Competitiveness of China, _Statistical Research_, 25(3), 12-19
-->
1. Yihui Xie, 2008. On the Applications of Statistical Graphics in Data Analysis, _Statistics Review_, Bo Zhang (ed), China Financial and Economic Publishing House.
1. Yihui Xie, Yu Zhu, 2008. Bootstrap Methods: Developments and Frontiers, _Statistics & Information Forum_, 89, 90-96.
1. Yihui Xie, 2007. The Application of the Classification and Regression Tree Based on the Package **rpart** in R, _Statistics & Information Forum_, 86, 67-70.
1. Yihui Xie, 2007. Series in International Competitiveness: How Weak is the Financial System of China?, _China Statistics_, 7, 35.
1. Yanyun Zhao, Yihui Xie, 2006. Unbalanced growth in top 100 industrial enterprises in China: market expanding outgoes business managing, _Talents_, 9, 84.
1. Yanyun Zhao, Yihui Xie, 2005. Who is the champion of growth among top 1000 industrial enterprises in China: analysis on the capability of market expanding and aggregate efficiency, _Talents_, 9, 72-73.

Besides, I published several articles in the [Capital of Statistics](https://cosx.org) in Chinese.

## Professional Experience

I worked for RStudio (later rebranded to Posit) as a software engineer from 2013 to 2023, and have been writing software tools for data visualization, reproducible research, and automatic reporting/document generation.

I [worked on](https://github.com/rstudio/shiny/graphs/contributors) Shiny from late 2013 to mid-2015. <!--I added a few new features to Shiny, such as the support for JavaScript libraries [DataTables](https://datatables.net) and [selectize.js](http://selectize.github.io/selectize.js/), and solved the problem with Unicode characters in Shiny apps on Windows.-->
From late 2014, I started working on the [**DT**](https://github.com/rstudio/DT) package for displaying tables. At about the same time, I worked extensively on the [**leaflet**](https://github.com/rstudio/leaflet) package for interactive maps, to bring it to the HTML widgets framework. My 2015 was primarily spent on these two packages.

In early 2016, I created a new package named [**tufte**](https://github.com/rstudio/tufte), to add the Tufte style to R Markdown documents and support both HTML and PDF output formats. I started the [**bookdown**](https://github.com/rstudio/bookdown) project in late 2015 to make it easier to write books and technical documents with R Markdown, and most of my time in 2016 was spent on this project. I also published a book for the **bookdown** package with Chapman & Hall/CRC in 2016.

Since late 2016, I started the [**blogdown**](https://github.com/rstudio/blogdown) project, to create websites based on R Markdown. The package was finished, and the companion book was published by Chapman & Hall/CRC in 2017.

I spent the first half of 2018 on writing the book "[R Markdown: The Definitive Guide](https://bookdown.org/yihui/rmarkdown)" (published in July), and the last few months on the R package [**pagedown**](https://github.com/rstudio/pagedown).

I was not very productive in 2019. <!--I often felt drown in GitHub issues and Stack Overflow questions.--> There was too much maintainence work for me to do for my R packages. I planned to write the [R Markdown Cookbook](https://bookdown.org/yihui/rmarkdown-cookbook), but didn't finish it until the summer of 2020. After that, I started to pay the huge amount of tech debt accumulated due to the hard time of COVID and the writing of the aforementioned book. I revamped the **blogdown** package in the second half of 2020.

Since the September of 2019, I had been more and more overwhelmed by the workload. 2020 had been quite a traumatic year to me (perhaps to everyone else, too). Fortunately, the tech debt started to appear manageable at the end of the first half of 2021.

I became a freelancer in 2024.

### Internship

1. Summer 2012, [AT&T Labs Research](http://research.att.com), Florham, NJ (mentor: [Simon Urbanek](https://urbanek.info))
1. Summer 2013, [Fred Hutchinson Cancer Research Center](https://www.fredhutch.org) (mentor: [Raphael Gottardo](https://research.fredhutch.org/gottardo/))

### Website Management

Sept 2003 - Present

I created and maintained websites for:

- [The School of Statistics](https://stat.ruc.edu.cn), Renmin University of China (Sept 2003 - Jun 2009)
- The Center for Applied Statistics, Renmin University of China (Apr 2004 - Jun 2009)
- The Center for Risk Management and Actuarial Studies (Jun 2004 - Apr 2006); Data Mining Center of Renmin University of China (Jul 2004 - Apr 2006), etc
- The "Great Expectation Society", a student society in Renmin University (Mar 2005 - Jul 2006)

I founded and have been maintaining:

- "[Capital of Statistics](https://cosx.org)", a popular online community for statistics in China (May 2006 - present)

I worked in these web studios:

- The English web studio of Renmin University of China (for the construction of English website of the university) (Sept 2006 - Jun 2009)
- The web club of the School of Statistics (as the founder & leader) (Apr 2006 - 2008)

### Conference Organization

Feb 2005 - Present

I initiated the Chinese R conference in 2008, and organized

- the 1st Chinese R [conference](https://cosx.org/2008/12/1st-chinese-r-conference-summary/) (in Beijing), Dec 13~14, 2008

I helped organize these conferences:

- the 3rd Chinese R [conference](https://cosx.org/chinar/chinar-2010/) (Beijing), Jun 12~13, 2010
- the 2nd Chinese R [conference](https://cosx.org/chinar/chinar-2009/) (Beijing & Shanghai), December 2009
- Second [Conference](http://www.merit.unu.edu/MEIDE/) on Micro Evidence on Innovation in Developing Economies, April 22 ~ 23, 2008 (an international conference; I was also the Chair for the last session on April 22)
- the 2nd Conference on Australia-China Free Trade Agreement (ACFTA): Econometric Modeling and Policy in Trade, Investment and Economic Integration, April 17th ~ 18th, 2006
- the 15th International [Conference](http://stat.ruc.edu.cn/en/21940.html) on Input-Output Techniques, June 27th ~ July 1st, 2005
- the Data Mining and Business Intelligence Conference 2006
- the International Statistics [Forum](http://stat.ruc.edu.cn/en/22120.html) 2006

### Other Work Experience

Sep 2004 - present

Duties in associations & centers:

- Program chair, Section on Statistical Graphics, American Statistical Association (2015)
- Data Sharing and Reproducibility Committee, American Statistical Association (2013)
- Column editor of the [ICSA bulletin](http://icsa.org/bulletin/) for its R column (2012 - 2013)
- Webmaster of the Center for Applied Statistics, Renmin University of China (2004 - 2009)
- Vice-chairman of the "Great Expectation Society" (a student association, Apr 2005 - Jul 2006)

Projects participated:

- Google Summer of Code (as a mentor)
    - [2012](https://www.google-melange.com/archive/gsoc/2012/orgs/rproject/projects/cloud_wei.html): Dynamic report generation on the web with R;
    - [2014](https://www.google-melange.com/archive/gsoc/2014/orgs/rproject/projects/kejun.html): rOptManifold: An R Package for Optimization over Matrix Manifolds;
    - [2017](https://summerofcode.withgoogle.com/projects/#5106168436359168): Noninvasive source code formatting;
- Translation of [R for beginners](http://cran.r-project.org/doc/contrib/Paradis-rdebuts_en.pdf) by Emmanuel Paradis (Collaborated with some colleagues on the translation) (Nov 2005 - Feb 2006);
- Performance Evaluation of Taxation Management of _the China Customs_ (designed several R programs for sampling databases using R) (Sept 2006 - Jun 2009);
- Important Projects in Social Science of _the Ministry of Education_: Research on the Industry Competitiveness of China (Apr 2007 - May 2007);
- A research project on statistical quality control co-operated with _China National Research Institute of Food and Fermentation Industries, National Standardization Centre of Food & Fermentation Industry, P.R.C._; [R (D)COM](http://sunsite.univie.ac.at/rcom/) was used in developing programs (May 2007 - Jun 2009)
- Cooperative project with the Office of 1% Population Sampling Survey of _the State Department_: Research on the National Population Competitiveness of China (Jun 2007 - Nov 2007)

## Presentations & Tutorials

Most of my slides were generated from R Markdown (especially the ones in recent years). To download the R Markdown source documents, simply replace the extension `.html` with `.Rmd` in the address bar of your web browser.

- Yihui Xie, 2024, _Reimagining Literate Programming and Automated Report Generation_, [Ihaka Lecture Series](https://www.auckland.ac.nz/en/science/about-the-faculty/department-of-statistics/ihaka-lecture-series.html), University of Auckland ([slides](https://slides.yihui.org/2024-ihaka-litedown.html); [video](https://www.youtube.com/live/83XxhMIZkiw))
- Yihui Xie, 2024, _litedown: R Markdown Reimagined_, [SOCEIO seminar](https://eventos.urjc.es/110238/detail/i-seminario-soceio-software-y-computacion-en-estadistica-e-investigacion-operativa.html), Madrid, Spain ([slides](https://slides.yihui.org/2024-soceio-litedown.html))
- Yihui Xie, 2024, _Reflections on the 12 Years of R Markdown_, the Inaugural Berkeley-Stanford Workshop on Veridical Data Science, UC Berkeley ([slides](https://slides.yihui.org/2024-berkeley-r-markdown.html); [video](https://youtu.be/PiplQeO_qig))
- Yihui Xie, 2024, _An Introduction to Building Web Applications and Services Using R_, Yale School of Public Health ([slides](https://slides.yihui.org/2024-ysph-r-web.html))
- Yihui Xie, 2023, _On the last step of data science: communication_, Huazhong Agricultural University, Wuhan, China ([slides](https://slides.yihui.org/2023-hzau-rmarkdown.html))
- Yihui Xie, 2023, _Introducing a lightweight version of R Markdown_, an ASA Philly webinar ([slides](https://slides.yihui.org/2023-philly-markdown.html))
- Yihui Xie, 2023, _An anatomy of R Markdown with minimal applications_, an invited talk to ASA Statistical Computing & Graphics Sections ([slides](https://slides.yihui.org/2023-minimal-r-markdown.html); [video](https://youtu.be/fiy32LjgGUE))
- Yihui Xie, 2022, _A graduate student's random walk_, an invited talk at the 75th anniversary of the Department of Statistics, Iowa State University
- Yihui Xie, 2022, _Highlights of the knitr package from the past two years_, rstudio::conf(2022) ([slides](https://slides.yihui.org/2022-rstudio-conf-knitr.html); [video](https://www.rstudio.com/conference/2022/talks/highlights-of-knitr-package-past/))
- Yihui Xie, 2022, _Creating a blog (or website) with blogdown that will not be down_, a talk at the useR! conference ([slides](https://slides.yihui.org/2022-useR-blogdown.html); [video](https://vimeo.com/722781853))
- Yihui Xie, 2022, _A brief history of R Markdown_, Alumni conference at the School of Statistics, Renmin University of China ([slides in Chinese](https://slides.yihui.org/2022-RUC-rmarkdown.html))
- Yihui Xie, 2022, _Creating three types of websites with blogdown_, Department of Statistics, Miami University ([slides](https://slides.yihui.org/2022-Miami-U.html))
- Yihui Xie, 2021, _A Brief History of R Markdown_, the 3rd [Brazilian R-Day](http://rday.leg.ufpr.br/) ([slides](https://slides.yihui.org/2021-Brazilian-R-Day.html))
- Yihui Xie, 2021, _My journey in writing books and blogging about R_, useR! 2021 ([slides](https://slides.yihui.org/2021-useR-journey.html))
- Yihui Xie, 2021, _An introduction to TinyTeX_, [TeX Hour](https://jfine2358.github.io/contact/) organized by Jonathan Fine
- Yihui Xie, 2021, _The fun of cooking_, DahShu ([slides](https://slides.yihui.org/2021-dahshu-kitchen.html); [video](https://youtu.be/JoFroYuajlE))
- Yihui Xie, 2020, _A fool's random walk of 18 years (reflections on the past 18 years of my life and career)_, Renmin University of China ([slides](https://slides.yihui.org/2020-random-walk.html); [video](https://vimeo.com/492610094))
- Yihui Xie, 2020, _One Minute for One R Markdown Recipe_, satRdays Taiwan ([slides](https://slides.yihui.org/2020-taipei-satrday-rmarkdown.html); [video](https://vimeo.com/469252441))
- Yihui Xie, 2020, _Literate Programming, R Markdown, and Reproducible Research_, Panel discussion at the Data Science Conference on COVID-19 ([slides](https://bit.ly/covid-down))
- Yihui Xie, 2020, _Miscellaneous tricks in R Markdown_, a remote talk to the Bear Club in Chinese ([slides](https://slides.yihui.org/2020-bearclub-rmarkdown.html))
- Yihui Xie, 2020, _One R Markdown Document, Fourteen Demos_, a talk at rstudio::conf(2020), San Francisco, CA ([post](/en/2020/02/rstudio-conf-2020/); [video](https://rstudio.com/resources/rstudioconf-2020/one-r-markdown-document-fourteen-demos/))
- Yihui Xie, 2020, _A Bag of R Markdown Tricks_, a talk at Genentech, San Francisco, CA ([slides](http://bit.ly/genen-down))
- Yihui Xie, 2020, _R Markdown Recipes_, a session at the R Markdown workshop at rstudio::conf(2020), San Francisco, CA ([slides](http://bit.ly/down-recipes))
- Yihui Xie, 2019, _15 Tips on Making Better Use of R Markdown_, an online seminar hosted by DahShu ([slides](https://bit.ly/dahshu-down); [video](https://www.youtube.com/watch?v=L5yTrtRdeCI))
- Yihui Xie, 2019, _My failures and perplexities as a former PhD student at Iowa State and later a software engineer at RStudio_, a talk invited by STAT-ers at Iowa State University ([slides](https://bit.ly/isu-talk))
- Yihui Xie, 2019, _The fun with CSS and JavaScript, joined by the simplicity of Markdown_, Statistical Graphics Group, Iowa State University ([slides](https://bit.ly/isu-pagedown))
- Yihui Xie, 2019, _R Markdown: a Software Ecosystem for Reproducible Publications_, [JSM](https://ww2.amstat.org/meetings/jsm/2019/onlineprogram/ActivityDetails.cfm?SessionID=218013), Denver, CO ([slides](https://bit.ly/jsm-rmarkdown))
- Yihui Xie, 2019, _Quick Demos of the R Markdown Ecosystem_, a remote talk for the RaukR Summer School, Visby, Sweden ([slides](https://bit.ly/2019-raukr))
- Yihui Xie and Romain Lesur, 2019, _pagedown: Creating beautiful PDFs with R Markdown and CSS_, rstudio::conf, Austin, TX ([slides](https://bit.ly/pagedown); [video](https://resources.rstudio.com/rstudio-conf-2019/pagedown-creating-beautiful-pdfs-with-r-markdown-and-css))
- Yihui Xie, 2018, _Some Lesser Known Features of knitr_, a remote talk for the RaukR Summer School, Visby, Sweden ([slides](https://bit.ly/2018-raukr))
- Yihui Xie, 2018, _Easy Dashboards with R Markdown_, a talk at the Omaha R User Group, Omaha, NE ([slides](https://bit.ly/2018-dashboard))
- Yihui Xie, 2018, _Creating Websites with R Markdown and blogdown_, a talk at the RStudio Conference 2018, San Diego, CA ([slides](https://bit.ly/2018-blogdown))
- Yihui Xie, 2017, _An R Markdown Tutorial on bookdown, blogdown, and xaringan_, a 3-hour tutorial in the School of Natural Resources, University of Nebraska-Lincoln ([slides](https://slides.yihui.org/2017-rmarkdown-UNL-Yihui-Xie.html))
- Yihui Xie, 2017, _Creating A Static Website with blogdown_, a webinar at the Chinese Genomics Meetup ([slides](https://slides.yihui.org/2017-blogdown-CGM-Yihui-Xie.html) in Chinese; [video](https://www.youtube.com/watch?v=g-UnHlp_IgA))
- Yihui Xie, 2017, _DIY Your Personal Academic Website with blogdown_, a talk in the Department of Statistics, University of Nebraska-Lincoln ([slides](https://slides.yihui.org/2017-blogdown-UNL-Yihui-Xie.html))
- Yihui Xie, 2017, _New Packages in the R Markdown Ecosystem_, a webinar given to the Statistics in Marketing Section, ASA ([slides](https://slides.yihui.org/2017-ASA-Marketing-rmarkdown-Yihui-Xie.html))
- Yihui Xie, 2017, _Towards An Open-access, Fast, and Reproducible Journal_, a keynote talk at the WOMBAT MeDaScIn conference, Melbourne, Australia ([slides](https://slides.yihui.org/2017-DSM-Journal-Yihui-Xie.html))
- Yihui Xie, 2017, _A Tour Through the R Markdown Ecosystem: Creating Documents, Presentations, Papers, Dashboards, Books, and Websites_, a tutorial at the Melbourne Data Science Week, Australia ([slides](https://slides.yihui.org/2017-DSM-rmarkdown-Yihui-Xie.html))
- Yihui Xie, 2017, _Making Websites with R Markdown and blogdown_, RStudio webinar ([slides](https://slides.yihui.org/2017-rstudio-webinar-blogdown-Yihui-Xie.html))
- Yihui Xie, 2017, _The R Markdown Ecosystem: Reproducible Reports, Papers, Books, Websites, and Presentations_, a seminar in the Department of Plant Pathology, Kansas State University, Manhattan, KS ([slides](https://slides.yihui.org/2017-RMD-KSU.html))
- Yihui Xie, 2017, _Customizing & Extending R Markdown_, a talk at rstudio::conf, Kissimmee, FL ([slides](https://slides.yihui.org/2017-rstudio-conf-ext-rmd-Yihui-Xie.html))
- Yihui Xie, 2017, _Making Websites with R Markdown_, a talk at rstudio::conf, Kissimmee, FL ([slides](https://slides.yihui.org/2017-rstudio-conf-blogdown-Yihui-Xie.html))
- Yihui Xie, 2017, _Advanced R Markdown_, a tutorial at rstudio::conf, Kissimmee, FL ([slides](https://slides.yihui.org/2017-rstudio-conf-rmarkdown-Yihui-Xie.html))
- Yihui Xie, 2016, _bookdown: Authoring Books with R Markdown_, Department of Statistics, Colorado State University ([slides](http://slides.yihui.org/2016-CSU-bookdown-Yihui-Xie.html))
- Yihui Xie, 2016, _Sharing the Fun of Using/Developing A Few R Packages_, Department of Statistics, Colorado State University
- Yihui Xie, 2016, _Authoring Books with R Markdown_, a webinar at RStudio ([slides](http://slides.yihui.org/2016-webinar-bookdown-Yihui-Xie.html); [video](https://www.rstudio.com/resources/webinars/introducing-bookdown/))
- Yihui Xie, 2016, _Reproducibility in Statistics and Data Science (Discussion)_, JSM 2016, Chicago ([slides](http://slides.yihui.org/2016-repro-JSM-Yihui-Xie.html))
- Yihui Xie, 2016, _HTML Widgets: Interactive Visualizations from R Made Easy!_, JSM 2016, Chicago ([slides](http://slides.yihui.org/2016-htmlwidgets-JSM-Yihui-Xie.html))
- Yihui Xie and Hadley Wickham, 2016, _Authoring Books with R Markdown_, useR! 2016, Stanford University ([slides](http://slides.yihui.org/2016-useR-bookdown-Yihui-Xie.html))
- Yihui Xie, Karl Broman, and Ian Lyttle, 2016, _Dynamic Documents with R Markdown_, a tutorial at useR! 2016, Stanford University ([slides](http://slides.yihui.org/2016-useR-rmarkdown-Yihui-Xie.html))
- Yihui Xie, 2016, _Pleasant Book Writing with bookdown_, the 9th China-R conference, Beijing ([slides](http://slides.yihui.org/2016-China-R-bookdown-Yihui-Xie.html))
- Yihui Xie, 2016, _CosPlay R_, the 9th China-R conference, Beijing
- Yihui Xie, 2016, _R Markdown: A Convenient Toolset for Academic Writing and Data Analysis_, Ocean University of China, Qingdao ([slides](http://slides.yihui.org/2016-OUC-Yihui-Xie.html))
- Yihui Xie, 2016, _Some Interesting Packages for Interactive Graphics_, School of Economics, Qingdao University, Qingdao
- Yihui Xie, 2016, _Shiny and HTML Widgets in R_, Greater Omaha Tableau User Group, University of Nebraska at Omaha ([slides](http://slides.yihui.org/2016-UNO-Shiny-Yihui-Xie.html))
- Yihui Xie, 2016, _Authoring Books with R Markdown_, the Chicago chapter of ASA, Chicago ([slides](http://slides.yihui.org/2016-ASAChicago-bookdown-Yihui-Xie.html))
- Yihui Xie, 2016, _Get Ready to Write A Book Now_
    - 03/31, University of Chicago ([slides](http://slides.yihui.org/2016-UChicago-bookdown-Yihui-Xie.html))
    - 02/17, Department of Statistics, University of Nebraska at Lincoln ([slides](http://slides.yihui.org/2016-UNL-bookdown-Yihui-Xie.html))
- Yihui Xie, 2016, _Complex Application Layouts with Grid Style Sheets_, Shiny Developer Conference, Stanford University ([slides](http://slides.yihui.org/2016-Shiny-GSS-Yihui-Xie.html))
- Yihui Xie, 2016, _Interfacing DataTables_, Shiny Developer Conference, Stanford University ([slides](http://slides.yihui.org/2016-Shiny-DT-Yihui-Xie.html))
- Yihui Xie, 2015, _Reflections on R Package Development a Software Engineer_, the 8th China-R conference, Nanchang, China ([slides in Chinese](http://slides.yihui.org/2015-Nanchang-R-Yihui-Xie.html))
- Yihui Xie, 2015, _Reproducible Reports with Big Data_, Strata, New York City ([slides](http://conferences.oreilly.com/strata/big-data-conference-ny-2015/public/schedule/detail/44154))
- Yihui Xie, 2015, _A Quick Dream in Ten Years_, Renmin University of China, Beijing ([slides in Chinese](http://slides.yihui.org/2015-RUC-alumni-sympo-Yihui-Xie.html))
- Yihui Xie, 2015, _Escape the Land of LaTeX/Word for Statistical Reporting: The Ecosystem of R Markdown_
    - 03/13, Wright State University, Dayton, Ohio ([slides](http://slides.yihui.org/2015-Wright-State-Yihui-Xie.html))
    - 07/14, Central Iowa R User Group
    - 09/03, ASA webinar ([slides](https://docs.google.com/presentation/d/1RJeypFW1y9vtG_kCoREN5D16jX3KNrc_qzGMGygQs2E/edit?usp=sharing))
    - 10/28, RStudio webinar ([slides](https://github.com/rstudio/webinars/blob/master/13-R-Markdown-Ecosystem); [video](https://vimeo.com/143893476))
- Yihui Xie, 2015, _Boosting R Skills and Automating Statistical Reports_, New England Statistical Symposium, UConn
- Yihui Xie, 2015, _Automatic reporting and interactive applications with R_, 58.com Inc, Beijing ([slides in Chinese](http://slides.yihui.org/2015-58-Yihui-Xie.html))
- Yihui Xie, 2015, _HTML Widgets_, LA R User Group ([slides](http://slides.yihui.org/2015-htmlwidgets-LA-Yihui-Xie.html); [video](http://datascience.la/yihui-xie-presents-html-widgets/))
- Yihui Xie & Dirk Eddelbuettel, 2014, An [R Workshop](http://ditraglia.com/RWorkshop/) at the Warren Center of UPenn, Philadelphia, PA
- JJ Allaire & Yihui Xie, 2014, _Reproducible R Reports with Packrat and Rmarkdown_, [R Day](http://strataconf.com/stratany2014/public/schedule/detail/37037) at Strata New York
- Yihui Xie, 2014, _Reproducible Research Is Dead, Long Live Reproducible Research!_, a talk given at JSM 2014, Boston, MA ([slides](http://slides.yihui.org/2014-JSM-knitr-Yihui-Xie.html))
- Yihui Xie, 2014, _Knitr Ninja_, a talk given at UseR! 2014, UCLA ([slides](https://github.com/yihui/knitr-talks/tree/master/useR2014))
- Yihui Xie, 2014, _Dynamic Documents with R and knitr_, a tutorial given at UseR! 2014, UCLA ([slides](http://slides.yihui.org/2014-useR-knitr-tutorial-Yihui-Xie.html); [examples](https://www.dropbox.com/s/0mabfshkbpe9bp1/2014-useR-knitr-tutorial-examples.zip))
- Yihui Xie, 2014, _The Next Generation of Dynamic Documents with R Markdown_, Great Plains [R-Users Group](http://homepages.dordt.edu/ntintle/gprug/) Conference, Sioux Center, Iowa ([slides](http://slides.yihui.org/2014-Dordt-Yihui-Xie.html))
- Yihui Xie, 2014, _How I Managed to Find Time to Play Badminton Three Times A Week_, a talk in the Department of Animal Science, ISU ([slides](http://slides.yihui.org/2014-ISU-ANS-Yihui-Xie.html))
- Yihui Xie, 2014, _New developments in knitr and R Markdown v2_, LA R user group ([slides](http://slides.yihui.org/LARUG-2014-Yihui-Xie.html))
- Yihui Xie, 2014, _Dynamic and Interactive Statistical Reporting_, a talk in the Department of Statistics, UCLA ([slides](http://slides.yihui.org/UCLA-2014-Yihui-Xie.html))
- Yihui Xie, 2014, _How to Save More Time from Your Homework and Projects_, a guest lecture for Stat 416 at Iowa State University ([slides](http://slides.yihui.org/2014-STAT416-Yihui-Xie.html))
- Yihui Xie, 2014, _An Introduction to knitr_, a remote talk for the Orange County R User Group ([slides](http://slides.yihui.org/2014-OC-RUG-Yihui-Xie.html))
- Yihui Xie, 2014, _R Markdown v2_, Seattle R User Meetup, Seattle, WA ([slides](http://slides.yihui.org/Seattle-useR-2014-Yihui-Xie.html))
- Yihui Xie, 2013, _You Can Save More Time from Homework/Projects/Data Analysis for Beer/Fun/Whatever_, Iowa Chapter of ASA poster session with mixer ([poster](http://slides.yihui.org/2013-ASA-Iowa-knitr-poster.pdf))
- Yihui Xie, 2013, _knitr for ninja_, a distance talk at the New York R Users Group ([slides](https://slides.yihui.org/2013-NYCR-knitr-Yihui-Xie.html))
- Yihui Xie, 2013, _A tour through knitr_, Raphael Gottardo's research lab, Fred Hutchinson Cancer Research Center, Seattle, WA ([slides](http://slides.yihui.org/FHCRC-rglab-2013-Yihui-Xie.html); [same talk given to the stats group](http://slides.yihui.org/FHCRC-VTN-2013-Yihui-Xie.html))
- Yihui Xie, 2013, _An Introduction to knitr_, Bioconductor 2013, Seattle, WA ([slides](http://slides.yihui.org/BioC-2013-Yihui-Xie.html), [R Markdown](http://slides.yihui.org/BioC-2013-Yihui-Xie.Rpres))
- Yihui Xie, 2013, _The Development of R in China, and One Sentence Summaries of My R Projects_, Revolution Analytics, Seattle, WA ([slides](https://bitbucket.org/stat/www/downloads/2013-RevoR-Yihui-Xie.pdf))
- Yihui Xie, 2013, _Doing Reproducible Research Unconsciously: Higher Standard But Less Work_, The 36th annual Midwest Biopharmaceutical Statistics Workshop, Muncie, IN ([slides](http://slides.yihui.org/knitr-MBSW-Yihui-Xie-2013.html))
- Yihui Xie, 2013, _Lessons Learned in Developing R Packages_, The 6th Chinese R Conference, Beijing ([slides](http://slides.yihui.org/ChinaR-2013-Yihui-Xie.html))
- Yihui Xie, 2013, _knitr: A General-purpose Tool for Dynamic Report Generation in R_, [ENAR](http://enar.org) 2013, Orlando, FL ([slides](http://slides.yihui.org/knitr-ENAR-Yihui-Xie-2013.html))
- Yihui Xie, 2013, _Reproducible Research on the Web: From Homework, Blogging to Open Journals_, SIAM [CSE13](http://www.siam.org/meetings/cse13/), Boston, MA ([slides](http://slides.yihui.org/2013-SIAM-CSE13-Yihui-Xie.html))
- Yihui Xie, 2012, _knitr: Starting From Reproducible Homework_, Workshop on Reproducibility in Computational and Experimental Mathematics, [ICERM](http://icerm.brown.edu/tw12-5-rcem), Brown University, Providence, RI ([slides](https://bitbucket.org/stat/www/downloads/ICERMRR-Yihui-Xie-2012.pdf))
- Yihui Xie, 2012, _Can You Reproduce Your Homework?_, Department of Biostatistics, Johns Hopkins Bloomberg School of Public Health, Baltimore, MD ([slides](//slides.yihui.org/2012-reproduce-homework.html))
- Yihui Xie, 2012, _I web, therefore I am_, ISU Computing Working Group ([slides](//slides.yihui.org/2012-stats-web.html))
- Yihui Xie, 2012, _Dynamic Report Generation and Interactive Graphics on the Web_, End of Summer talk at AT&T Labs as a summer intern, Florham Park, NJ
- Yihui Xie, 2012, _cranvas: A New Package for Interactive Statistical Graphics in R_, Joint Statistical Meetings at San Diego, CA
- Yihui Xie, 2012, _cranvas: Interactive statistical graphics in R based on Qt_, [useR! 2012](http://biostat.mc.vanderbilt.edu/wiki/Main/UseR-2012), Nashville, TN ([R code](//slides.yihui.org/2012-useR-cranvas-demo.R))
- [Yihui Xie](https://db.yihui.org/imgur/cs0lG.jpg) and JJ Allaire, 2012, _New Tools for Reproducible Research with R_ ([slides](//slides.yihui.org/2012-knitr-RStudio.html))
    - 05/30 Iowa State University
    - 05/30 Minneapolis UseR Group
    - 06/05 New York UseR Group
    - 06/14 [invited talk](https://db.yihui.org/imgur/GPFxG.jpg) at the 8th International useR! Conference
- Yihui Xie, 2012, _Go social coding! Make open source more open!_, lightning talk at useR! 2012 ([slides](https://db.yihui.org/docs/social-coding-Yihui-Xie-2012.pdf))
- Yihui Xie, 2012, _cranvas: Building from Plumbing and Painting_, [Interface 2012](http://www.interfacesymposia.org/Interface2012/Interface2012.html), Houston TX ([slides](https://db.yihui.org/docs/cranvas-Houston-2012.pdf))
- Yihui Xie, 2012, _Generating beautiful statistical reports quickly and faithfully_, ISU Graphics Working Group ([slides](https://db.yihui.org/docs/knitr-ISU-2012-Yihui-Xie.pdf))
- Yihui Xie, 2011, _How I See Bootstrap, Tests and KDE_, Stat546 presentation at ISU ([slides](//slides.yihui.org/2011-nonparametric.html))
- Yihui Xie, 2011, _An Introduction to R_, tutorial workshops in the Econ department of ISU ([slides](//slides.yihui.org/2011-r-intro-econ.html))
- Yihui Xie, 2011, _Lessons Learned in Developing R Packages_, ISU Computational Statistics working group ([slides](//slides.yihui.org/2011-r-dev-lessons.html))
- Yihui Xie, 2011, _`cranvas`: Interactive Statistical Graphics in R via Qt_, AT&T Research Labs, New Jersey ([slides](https://db.yihui.org/docs/cranvas-ATT-2011-Yihui-Xie.pdf))
- Yihui Xie, 2011, _Interactive Parallel Coordinates Plot Based on Qt_, Joint Statistical Meetings at Miami Beach, Florida ([slides](https://db.yihui.org/docs/cranvas-JSM-2011-Yihui-Xie.pdf))
- Yihui Xie, 2011, _New Features and Enhancements of the `animation` Package_, ISU Graphics Working Group ([slides](https://db.yihui.org/docs/animation-2011-Yihui-Xie.pdf))
- Yihui Xie, 2010, _LaTeX and Sweave without Tears_, ISU Graphics Working Group ([slides](https://db.yihui.org/docs/LaTeX-Sweave-2011-Yihui-Xie.pdf))
- Yihui Xie, 2010, _Creating Animations with R_, the useR! 2010 conference at NIST, Gaithersburg, MD ([slides](https://db.yihui.org/docs/animation-useR2010-Yihui-Xie.pdf); [R code](https://gist.github.com/2166508))
- Yihui Xie, 2010, _Creating GUI with the gWidgets package_, the 3rd Chinese R conference, Beijing ([slides in Chinese](https://db.yihui.org/docs/ChinaR-gWidgets-2010-Yihui-Xie.pdf); [R code](https://gist.github.com/1756480))
- Yihui Xie, 2010, _Modern Statistical Graphics_, tutorial lecture on the 3rd Chinese R conference, Beijing ([slides in Chinese](https://db.yihui.org/docs/ChinaR-MSG-2010-Yihui-Xie.pdf))
- Yihui Xie, 2009, _Creating R Packages_, Working Group in Statistical Computing and Computationally-intensive Statistical Methods, Department of Statistics, ISU ([slides](https://db.yihui.org/docs/Creating-R-packages-2009-Yihui-Xie.pdf); [C code](https://gist.github.com/1756465))
- Yihui Xie, 2009, _R in Stat500: Demonstration, Computing, and Graphics (with An Introduction to the R Package ISU.Stat500)_, RTG Seminar, Department of Statistics, ISU ([slides](https://db.yihui.org/docs/ISU-Stat500-2009-Yihui-Xie.pdf))
- Yihui Xie, 2009, _Turning Statistical Ideas into Animations_, VIGRE Graphics Seminar, Department of Statistics, ISU ([slides](https://db.yihui.org/docs/animation-2009-Yihui-Xie.pdf); [R code](https://db.yihui.org/docs/animation-2009-Yihui-Xie.zip))
- Yihui Xie, 2009, _Reproducible Research and An Introduction to LaTeX, R and Sweave_, a report for PhD students in the School of Statistics, RUC ([slides in Chinese](https://db.yihui.org/docs/Sweave-2008-Yihui-Xie.pdf))
- [Yihui Xie](https://db.yihui.org/imgur/SDtSv.jpg), 2008, (1) _The History of R Language and Current Developments_ ([slides](https://db.yihui.org/docs/R-History-2008-Yihui-Xie.ppt)) (2) _animation: An R Package for Statistical Animations with Applications in Teaching and Data Analysis_ ([slides](https://db.yihui.org/docs/ChinaR-animations-2008-Yihui-Xie.ppt)) (3) _Explore Irregular Data with R_ ([slides](https://db.yihui.org/docs/Irregular-Data-2008-Yihui-Xie.ppt), [R code](https://gist.github.com/1756790#file_china_r_conference_intro_2008_yihui_xie.r)), [the 1st Chinese R Conference](https://cosx.org/2008/12/1st-chinese-r-conference-summary/), Beijing, 2008.12.13~14 ([introduction to the conference](https://db.yihui.org/docs/ChinaR-Conference-Intro-2008-Yihui-Xie.pdf), [R code](https://gist.github.com/1756790#file_irregular_data_2008_yihui_xie.r))
- [Yihui Xie](https://db.yihui.org/imgur/4PXVg.jpg), 2008, _Tutorial Lectures on R Basics_, a four-day tutorial lecture series given at the Institute of Botany, Chinese Academy of Sciences (slides in Chinese: [1](https://db.yihui.org/docs/CAS-R-tutorial1-2008-Yihui-Xie.pdf), [2](https://db.yihui.org/docs/CAS-R-tutorial2-2008-Yihui-Xie.pdf), [3](https://db.yihui.org/docs/CAS-R-tutorial3-2008-Yihui-Xie.pdf), [4](https://db.yihui.org/docs/CAS-R-tutorial4-2008-Yihui-Xie.pdf))
- Yihui Xie, 2008, _See? (escaping the math world via animations...)_, a talk in the School of Statistics, Renmin University of China ([slides](https://db.yihui.org/docs/animation-RUC-2008-Yihui-Xie.pps))
- [Yihui Xie](https://db.yihui.org/imgur/Kujko.jpg), 2008, _Statistical Animations Using R_, [useR! 2008](http://www.statistik.uni-dortmund.de/useR-2008/) in Dortmund ([abstract](http://www.statistik.uni-dortmund.de/useR-2008/abstracts/Xie.pdf); [slides](https://db.yihui.org/docs/animation-useR-2008-Yihui-Xie.ppt); [slides in PDF](http://www.statistik.uni-dortmund.de/useR-2008/slides/Xie.pdf))
- [Yihui Xie](https://db.yihui.org/imgur/OVrlv.jpg), 2008, _Computer Animations for Demonstrating Statistical Procedures: Methods and Implementations_, a talk at the workshop "Statistical Graphics: Data and Information Visualization in Today's Multimedia Society [(Data Viz VI)](http://www.jacobs-university.de/schools/shss/awilhelm/)" in Jacobs University, Bremen, Germany ([slides](https://db.yihui.org/docs/animation-DataViz-2008-Yihui-Xie.pdf))
- [Yihui Xie](https://db.yihui.org/imgur/1Sj0J.jpg), 2008, _The Influence of Population Quality Competitiveness to Regional Innovation: the China Case_, a presentation at the 2nd MEIDE [conference](http://www.merit.unu.edu/MEIDE/) ([slides](https://db.yihui.org/docs/MEIDE-2008-Yihui-Xie.pdf))
- Yihui Xie, 2008, _A Training Course on EViews and Examples in Macroeconomic Statistics_, a lecture in the National Development and Reform Commission (NDRC) of People's Republic of China ([slides in Chinese](https://db.yihui.org/docs/Intro-EViews-2008-Yihui-Xie.pdf))
- [Yihui Xie](https://db.yihui.org/imgur/hf7Gl.jpg), 2007, _[Animation](http://cran.r-project.org/web/packages/animation/index.html) in Statistics: Dynamic Graphics for Statistical Models and Practical Applications_, an invited talk in the 2nd postgraduate forum on statistics for universities in Beijing ([slides](https://db.yihui.org/docs/2nd-Stat-Forum-2007-Yihui-Xie.pdf))
- Yihui Xie, 2007, _Classification Tree Ensembles with Applications to the Prognostic Analysis of Cerebral Infarction_, a report in "The Seminar for the Statistical Methods in Clinical Research" held in Renmin University of China ([slides in Chinese ](https://db.yihui.org/docs/Medicine-2007-Yihui-Xie.pdf))
- [Yihui Xie](https://db.yihui.org/imgur/BE3yw.jpg), 2007, _Jokes in Statistics_, an invited lecture in the Capital University of Economics and Business ([slides](https://db.yihui.org/docs/Jokes-2007-Yihui-Xie.pdf))
- Yihui Xie, 2007, _A Leisure Look on Some Tools for Statistics_, an invited lecture in the Capital University of Economics and Business ([slides in Chinese](https://db.yihui.org/docs/Stat-tools-2007-Yihui-Xie.pdf); [R code](https://gist.github.com/1756901))
- Yihui Xie, 2007, _Bootstrap Methods: A Review_, a report in the class of "Frontiers in Statistics" ([slides](https://db.yihui.org/docs/Bootstrap-2007-Yihui-Xie.pdf))
- Yihui Xie, 2007, _An Introduction to Support Vector Machine and Implementation in R_, an article for a presentation of the class "Data Mining and Machine Learning" ([slides](https://db.yihui.org/docs/SVM-2007-Yihui-Xie.pdf))
- Yihui Xie, 2007, _A Framework for Statistical Programming and An Introduction to Basic Statistical Analysis Using R_, a lecture given to the members of the "Capital of Statistics" ([slides in Chinese](https://db.yihui.org/docs/R-Programming-2007-Yihui-Xie.pdf))
- Yihui Xie, 2007, _A Brief Introduction to Java_, a lecture in the School of Statistics ([slides](https://db.yihui.org/docs/Java-2007-Yihui-Xie.pdf))
- Yihui Xie, 2007, _A Guide to Stata_, a lecture in People's Bank of China ([slides in Chinese](https://db.yihui.org/docs/Stata-2007-Yihui-Xie.pdf))
- [Yihui Xie](https://db.yihui.org/imgur/lB9hL.jpg), 2007, _Visualization of Data and Statistical Models Using R_, 3rd Conference on Australia-China Free Trade Agreement (ACFTA): Econometric Modeling and Policy in Trade, Investment and Economic Integration ([paper](https://db.yihui.org/docs/R-visualization-paper-2007-Yihui-Xie.pdf); [slides](https://db.yihui.org/docs/R-visualization-2007-Yihui-Xie.pdf))
- Yihui Xie, 2006, _Thoughts of Statistics_, an invited talk in the 1st postgraduate forum on statistics for universities in Beijing ([slides](https://db.yihui.org/docs/Thoughts-2006-Yihui-Xie.pdf))
- Yihui Xie, 2006, _Typesetting and LaTeX_, a lecture in the School of Statistics ([slides](https://db.yihui.org/docs/LaTeX-2006-Yihui-Xie.pdf))
- Yihui Xie, 2006, _Statistical Programming & R Basics_, a lecture in the School of Statistics ([slides](https://db.yihui.org/docs/R-Programming-2006-Yihui-Xie.pdf))
- Yihui Xie, 2006, _An Introduction to Structural Equation Modeling_, A small seminar on SEM in Renmin University ([slides](https://db.yihui.org/docs/SEM-2006-Yihui-Xie.pdf))
- Yanyun Zhao, Guirong Li, Xuanxuan Chen, [Yihui Xie](https://db.yihui.org/imgur/0ZURF.jpg), 2006, _The Industrial Structure and Foreign Investment Introduction Policy in Shanghai and Its Adjacency_, 2nd [Conference](http://stat.ruc.edu.cn/en/22077.html) on Australia-China Free Trade Agreement (ACFTA): Econometric Modeling and Policy in Trade, Investment and Economic Integration ([slides](https://db.yihui.org/docs/ACFTA-2006-Yihui-Xie.pdf))

## Computer Skills

I like playing with computer tools for building web pages and statistical computation & graphics. I often try to improve the efficiency of my work by creating software tools (i.e. work hard to be lazy).

- Statistical Packages: [R](http://www.r-project.org) ~~(OpenBUGS, S-Plus, SPSS, Eviews, SAS, MatLab, STATA, AMOS and LISREL)~~
- Languages: R, HTML/CSS, JavaScript, PHP, SQL ~~(Visual Basic, VBA, VBScript, ASP, Java, C)~~
- Applications: LaTeX via [LyX](http://www.lyx.org), Markdown via [Pandoc](http://pandoc.org), databases (e.g. MySQL), ~~SVN and~~ GIT
- Operating Systems: 95% macOS, 2.5% Ubuntu, and 2.5% Windows (the latter two mostly for purposes of testing software)

Listed above are what I'm familiar with, and the ones being crossed out are due to my brain stack overflow and I do garbage collection in my brain once in a while.

## Software Packages

I support open source software, and below is a list of open source packages that I'm involved with.

### R packages:

I'm the creator and main author of:

- [knitr](https://github.com/yihui/knitr): a general-purpose package for dynamic report generation in R
- [bookdown](https://github.com/rstudio/bookdown): authoring books and technical documents with R Markdown
- [xaringan](https://github.com/yihui/xaringan): presentation ninja
- [blogdown](https://github.com/rstudio/blogdown): create blogs and websites with R Markdown
- [pagedown](https://github.com/rstudio/pagedown): typeset HTML documents with CSS and Paged.js and print to PDF
- [tufte](https://github.com/rstudio/tufte): Tufte styles for R Markdown documents
- [servr](https://github.com/yihui/servr): a simple HTTP server to serve static files or dynamic documents
- [animation](https://github.com/yihui/animation): a gallery of animations in statistics and utilities to create animations
- [testit](https://github.com/yihui/testit): a simple package for testing R packages
- [formatR](https://github.com/yihui/formatR): format R code automatically
- [tinytex](https://github.com/rstudio/tinytex): helper functions to install a small version of TeX Live named TinyTeX, and compile LaTeX documents
- [DT](https://github.com/rstudio/DT): a wrapper of the JavaScript library DataTables
- [mime](https://github.com/yihui/mime): map filenames to MIME types
- [highr](https://github.com/yihui/highr): syntax highlighting for R source code
- [printr](https://github.com/yihui/printr): some printing methods for knitr
- [Rd2roxygen](https://github.com/yihui/Rd2roxygen): convert Rd to roxygen documentation
- [xfun](https://github.com/yihui/xfun): my miscellaneous R functions
- [R2SWF](https://github.com/yihui/R2SWF), [MSG](https://github.com/yihui/MSG), [iBUGS](https://github.com/yihui/iBUGS), [fun](https://github.com/yihui/fun), [and so on](http://depsy.org/person/329908)

I have contributed to:

- [rmarkdown](https://github.com/rstudio/rmarkdown): dynamic documents for R
- [shiny](https://github.com/rstudio/shiny): web application framework for R
- [evaluate](https://github.com/hadley/evaluate): parsing and evaluation tools that provide more details than the default
- [htmlwidgets](https://github.com/ramnathv/htmlwidgets): HTML widgets for R
- [leaflet](https://github.com/rstudio/leaflet): create interactive web maps with the JavaScript leaflet library
- [htmltools](https://github.com/rstudio/htmltools): tools for HTML
- [roxygen2](https://github.com/klutometis/roxygen): in-source documentation for R
- [tikzDevice](https://github.com/yihui/tikzDevice): R graphics output in LaTeX format
- [cranvas](https://github.com/ggobi/cranvas/), the next generation of [GGobi](http://www.ggobi.org) for interactive statistical graphics


### PHP applications:

- WordPress plugin [UTF-8 DB Converter](http://wordpress.org/extend/plugins/utf-8-db-converter/) (June 2009)
- DokuWiki plugin [animation](http://www.dokuwiki.org/plugin:animation) to insert animations into wiki pages; written in PHP and JavaScript (Jun 2008)

### Misc

- The Sweave and knitr modules in [LyX](http://www.lyx.org) (with Jean-Marc Lasgouttes)
- The Hugo themes [XMin](https://xmin.yihui.org), [XMag](https://xmag.yihui.org), [Ivy](https://ivy.yihui.org), and [Paged](https://paged.yihui.org)
- [TinyTeX](/tinytex/), a small and easy-to-maintain LaTeX distribution based on TeX Live
