---
title: "About"
slug: "en/about"
---

My name is Yihui Xie. You can know more about me on the [homepage](/) and my
[vitae](../vitae/). This blog is about statistics, R, graphics, life, and fun,
with a special focus on R. I often update my old posts (even after years) to
correct errors and remove outdated information, so please don't take everything
for granted. All opinions expressed here are my own, and I don't represent
anyone else such as my employer.

## Contact me

You can find me on [GitHub](https://github.com/yihui) (where I'm active almost
every day) or Twitter [\@xieyihui](http://twitter.com/xieyihui) or Mastodon
[\@yihui\@mastodon.social](https://mastodon.social/@yihui) (I don't read social
media often, so please don't expect me to respond quickly or at all on social
media). You may subscribe to the RSS feed of [blog posts](../index.xml) or watch
the [comments repository](https://github.com/yihui/yihui.org/discussions) to
stay tuned. I don't like formality, so it is not necessary to call me "Dr Xie"
when you email or introduce me. I'm a software engineer, so please don't call me
professor.

I don't prefer people asking me questions about open-source packages by private
emails. It is not practical for me to answer all of them (not even for the
packages that I maintain). Emails often make me feel stressful in recent years,
and I'm close to the point of [email
bankruptcy](https://en.wikipedia.org/wiki/Email_bankruptcy) from time to time.
I've reached "Inbox Zero" only once in my life. Usually I have about 100 emails
in my inbox to which I haven't been able to reply. However, I'm very happy to
receive emails that don't require replies.

Please don't get me wrong---I do like questions, but I prefer seeing questions
about open-source packages (like R) posted on [Stack
Overflow](https://stackoverflow.com) or [Posit
Community](https://community.rstudio.com), instead of in my inbox. For any
reason, if you have to ask me directly, please post to my public [GitHub
Discussions](https://github.com/yihui/yihui.org/discussions) (you can ask me
anything there if it doesn't involve privacy). Please feel free to email me the
link to your public question if nobody has answered it after a few days, and
I'll try to help you publicly. Knowledge should be open to the public whenever
possible, and I'd like to use emails only for *private* conversations (more
explanations in [this post](/en/2017/08/so-gh-email/)).

In short, I wish I could help you, but practically I cannot do it privately. I
will truly appreciate it if you could use public resources before trying private
emails or messages.

## About this site

This site is created with [**blogdown**](https://github.com/rstudio/blogdown)
(base on [Hugo](https://gohugo.io)) and the theme is
[hugo-paged](https://github.com/yihui/hugo-paged), a Hugo theme that I created
to mimic the paged.js website theme. The Markdown source files are [hosted on
GitHub](https://github.com/yihui/yihui.org). When you read the blog posts, you
can navigate to the previous post by the left-arrow key or next post by
right-arrow. Please hit "Edit this page" in the bottom menu if you find any
mistakes on the page to propose a correction through GitHub.

## Some links

### Statistics

-   [Xi'an's Og](http://xianblog.wordpress.com/): Bayesian, MCMC, R, ...
-   [Normal Deviate](http://normaldeviate.wordpress.com/): Thoughts on
    Statistics and Machine Learning

### R Language

-   [The R Project](http://www.r-project.org/)
-   [R Weekly](https://rweekly.org)

## My projects

Below is an incomplete list of packages and projects I have worked on. For a
full list, please see my [vitae](../vitae).

-   [animation](/animation/): a gallery of animations in statistics and
    utilities to create animations
-   [blogdown](https://github.com/rstudio/blogdown): create blogs and websites
    with R Markdown
-   [bookdown](https://bookdown.org): author books and technical documents with
    R Markdown
-   [DT](https://github.com/rstudio/DT): a wrapper of the JavaScript library
    DataTables
-   [formatR](/formatr/): Format R code automatically
-   [knitr](/knitr/): Dynamic report generation with R
-   [printr](/printr/): Some printing methods for **knitr**
-   [Rd2roxygen](/Rd2roxygen/): Convert Rd to roxygen documentation
-   [rlp](/rlp/): Write an R package using literate programming techniques
-   [servr](https://github.com/yihui/servr): a simple HTTP server to serve
    static files or dynamic documents
-   [testit](https://github.com/yihui/testit): a simple package for testing R
    packages
-   [tinytex](/tinytex/): a lightweight LaTeX distribution based on TeX Live
-   [tufte](https://github.com/rstudio/tufte): Tufte styles for R Markdown
    documents
-   [xaringan](https://github.com/yihui/xaringan): presentation ninja
-   [xfun](/xfun/): miscellaneous functions
