---
title: 中文识字
subtitle: 学习七千通用汉字
date: '2021-02-21'
slug: chars
show_toc: false
customCSS: ["zdict/learn-chars.css"]
customJS: ["zdict/learn-chars.js"]
---

<div id="learn-chars">加载中，请稍候……</div>

## 使用说明

[默认字库](https://github.com/yihui/zdict)来自于汉典网站上的七千字《[现代汉语通用字表](https://www.zdic.net/zd/zb/ty/)》，已经按照常用频度排序。首次打开本页面需要加载字库（大约 1.4 Mb），可能需要等待几秒，加载完成后会先随机显示一个汉字。

### 模式

- 学习：每点击一下字框显示一个字及其读音和释义，供用户学习。

- 复习：显示本批次中学习过的字，以及它们的读音。若点击其中一个字，下方的大字下会显示它的释义。若逐次点击下方的大字，则遍历显示上方学过的字。重复点击这个单选框可以显示或隐藏上一步还没学过的字（以灰色标示）。

- 测验：依次显示本批次所有的字。用户自行输入它们的拼音，可以不用带音调。程序会验证输入的拼音是否正确。多音字输入任意一个音都算对。若拼音输错，则显示红色。若输入正确，则显示绿色。无论对错，都将显示该字的所有正确读音。按回车或点击字块进入下一题。

- 挑战：从全字库中不断随机出一个字，用户输入该字的拼音。根据答对的比例估计用户的识字量。这个估计基于无放回简单随机抽样的原理，置信区间基于正态分布近似。答题量越大，估计越精确；当然，要是有本事把七千字全部挑战完，那也就不用估计了（置信区间宽度将为零）。

### 设置

用户可以从字库中任意选择一部分进行学习，默认从第 1 字向后选择 20 个字。第二个框中的数字若填 0 则表示选取全体集合，默认也就是选取七千字（一口气学七千字那还是人吗？那是牲口啊）。注意，第二个框填 0 时，若重复点击“复习”模式单选框，会将全体字集渲染出来；若全体子集太大，可能会导致浏览器不响应甚至崩溃。

用户也可以自定义字库——将字符集粘贴到文本框中后点击”确定“按钮即可。粘贴的文本不必是单字的集合，也可以是一篇文章。程序会自动将它处理成字符集。七千通用字集之外的字符会被自动删除。

### 待办

- 记录测验模式中的错字，在复习模式中高亮显示

- 存储所有学过的字，错字往前挪，正确的字往后挪；[间隔性复习](https://en.wikipedia.org/wiki/Spaced_repetition)，错字优先，随机混入正确的字

### 致谢

感谢邻居朱馨晨小朋友跪在地板上用平板认真测试，让我发现了一处[程序缺陷](https://github.com/yihui/zdict/commit/2a073fcc)。
