---
title: 丹佛夜影
date: '2022-07-19'
slug: denver-shadow
---

<!--# 这是我生平写的第一篇小说。故事背景取材于我们一个多月前去丹佛的旅游，但情节多为虚构，充满了象征和隐喻。至于隐喻指的是什么，我就不注释了，否则就失去了隐喻的意义。我写这篇小说的一大顾虑是它被同行的朋友们读过后可能会影响到他们对这次旅游的美好回忆，因为前五节全都是恐怖、阴暗、绝望的色调；在结局的第六七节中，我试图把这种色调反转过来，争取给一系列悲观的故事覆上一层乐观和希望的色彩，但不知我是否做到了（这两节是一场自我战斗与成长，因而最难写）。我自认为擅长联想，但不擅长编故事，所以第一篇小说选择了写梦境，这样可以给我荒唐的自由度，不必过度考虑逻辑。我听说过史蒂芬 · 金的恐怖小说《闪灵》，但没读过，据说他写的是他酗酒后的阴暗情绪。我也有一些压抑的负面情绪，于是也将它们以隐喻的形式写进了小说的四个对象。最终我希望能战胜、化解它们。从这个角度来说，虚构小说也是一种自救——现实生活中做不到的事情，不妨先以虚拟的方式做做看，也许能扭转自己的想法。我的这些情绪由来已久，就像一大锅豆浆一直在我面前晃荡。直到最近一位朋友讲了一串逃不脱的噩梦，我听后觉得我终于等到了卤水，于是一锅豆浆凝固成了豆腐，便是这篇小说。以下开头的歌词引子，也碰巧是这位朋友哄睡娃时放的一首歌，传入了我的狗耳朵；我自己很久以前也收藏了这首歌，便以它起头了。得来全不费工夫。 -->

When the night falls  
And you are all alone  
In your deepest sleep  
What are you dreaming of

当你明知自己在一场噩梦中，却无论如何醒不过来，你该如何摆脱或战胜它？

## 一、木屋的人影

车开进科罗拉多州之后，我才领略到什么叫平原。远处的云几乎贴上了地面，我从没见过那样低的云。苍穹之下，除了一望无际的枯黄草原，就只有一条笔直向西的 80 号高速公路。要是梵高在这里那该多好，我想。我用左手一根手指随意勾扶着方向盘，以八十五迈的速度驶向远方那天地夹缝。天地孤影任我行。世上最自由的人，大概也不过如此吧。当时我是这样以为的。

车里的歌放到了《棋子》。有人曾说它是“卑微五重奏”之一。

科州的高速公路上，每隔一段都有一块警示牌，告知司机：科州法律规定左车道只能用于超车，而正常行驶的车必须走右车道。在这通天大道上一共就没几辆车，简直多此一举，我暗笑它迂。我想选哪条道选那条，管那么多干嘛。就算我开在左道上，也不会挡着谁的路或被谁追赶。当时我是这样以为的。

耳边响起《日光机场》的前奏。有人曾说这歌声听起来就像个女鬼。

离目的地还有一个多小时，路上车开始多了，而炙热的夏日空气突然冷了起来，随后阵阵阴风刮得车身有些摇晃，我开始用整只手扶方向盘。没多久，暴雨如注，下午四点多的天空一片昏暗。我稍微减了减速，打开车灯，并把雨刷打到最快档。雨刷快得仿佛落水的人在挥手喊救命，或疯狂摆手、警告人不要继续靠近。不知什么时候起，仪表盘上的胎压指示灯又亮了。真奇怪，明明出行前新换了所有轮胎。莫非是因为丹佛海拔高的缘故？

六点刚过，我下了 34 号公路，到了预订的民宿小区前。八小时车程让我的身体有些僵硬，但想到接下来几天可以远离令人压抑的尘嚣、在此静享山水，一路的劳顿便卸去大半。小区坐落在落基山脉西侧的影山湖边一片土丘上。房东告诉过我，到达那所房子之前需要爬一个大土坡。刚开始我爬错了坡，开到了一条死路上。路尽头是一栋看起来没有人的房子，后院门大敞着。同多数建在山区或郊外的美国房子一样，它打着告示牌：私人宅所，禁止闯入。从这家的后院，我看到我租的房子就在右边一个更高的坡上，但没看到去那儿的路在哪里。

迂回绕了十几分钟，在小区里一个人都没碰到，我终于自己找到了房东说的那个坡。果真很陡，接近四十五度的样子。自从到了丹佛，车油门就变得很疲软，于是我猛踩油门爬上了坡，把车停在车库门口。

我输入密码三七一九，按开启键，车库门没有动静。再试了两遍，还是打不开。我无意间意识到这密码的四个数字连起来正好是一把叉。

这是一栋褐红色的双层木屋，年代似乎有些久远，与周围最近的房子和树林相隔至少有百米。空旷的四周除了大片杂草和黄色的蒲公英点点，就只有右边孤零零一棵云杉，仿佛房子的守卫，静静立在那里。

空林有雪相待，野路无人自还。

我回头看了一眼车，右前轮确实有点瘪。房东还给了前门的密码，于是我走上门廊的楼梯。七八米开外，一只乌鸦落在歪倒的十字木桩上，盯着我，嘴里叼着一根枯枝，又或许是骨头。

外层的玻璃门上是一把密码挂锁，已经有些锈迹，我试了几次才转开它。从大门进去后是宽敞的客厅，客厅的天花板便是屋顶，约八米高，上面两把吊扇兀自嘎吱转着，吹着茶几上两只木雕野鸭。现在我有点后悔当初贪心了一些，订了这么大的一栋房子。客厅的东面、东北、南面都是高大的百叶窗，拉起百叶窗可以清楚看见下面的影山湖以及远处的雪山。东边窗外便是那棵云杉。十字桩上的乌鸦已不知所踪。

我穿过客厅和厨房，找到了车库门的开关，升起车库门，把车开了进来，卸下行李和路上买的菜。凌乱的车库里，我看到了房东之前提到过的烧烤架。烧烤是我的最爱，也是我订这房的原因之一。打开烤架，里面糊满了黑黑的油渍，仿佛几年不曾清理过，有些恶心。我提着大包小包进了厨房，把食物悉数放进冰箱。关上冰箱门后，惊奇地发现窗外开始飘起了雪。丹佛的夏天居然还能下雪。我来到客厅窗前，外面天色已暗下来，云杉的树枝在风中摇摆。房顶的吊扇还转着。下雪天吹风扇未免有点荒谬。我找到开关，但发现吊扇只能调小风速，而无法关死。

先歇口气吧。我取出电脑，一屁股坐进沙发，随意地把脚搭在茶几上、电脑搁在腿上，写了一段游记开头。写完收腿时，不小心踢掉了一只木头鸭子。可能它材质太脆，落地便摔断了脖子。

正当我琢磨怎样粘好它的时候，我听到楼上卧室那边有微弱的流水声，便先放下鸭子，循声上了楼。楼梯尽头的拐角立着一头陶瓷小熊，面无表情地盯着我。我转身进了开着门的卧室，听出来水声是从马桶的蓄水池里传来的。掀开池盖，原来是底下的胶皮阀门被浮力球微微吊着，没有盖严冲水口。我盖好水阀，池内的水位升上来顶住浮力球，水声便停息了。

我下楼回到厨房开始做晚饭。把所有抽屉和柜子翻了一遍，发现炊具都很旧。抽出一口平底不粘锅想简单炒个菜，但锅底的涂层已经很粗糙，于是作罢，把它丢在灶台上，改用自己的高压锅随意煮了一点火锅。红泥小火炉，晚来天已雪，自然要饮几杯。火锅伴着半瓶红酒下肚，酒足饭饱，雪也停了。倦意夹杂着一丝醉意袭来，我刷了锅碗，便准备上楼去睡觉。

确认过客厅的大门已经反锁好后，我关了客厅的灯，转身正要上楼，突然看见地上有个人影正爬上百叶窗，心里不禁一惊，困意都醒了大半，但终于反应过来，这只不过是外面门廊上的灯照出来我自己的影子。我并没有回头确认。

门口似乎有一声轻微的咔哒，也许是屋檐的积雪掉到了地上。

我打算快速冲个澡就睡觉。浴室很狭小，正好我喜欢小浴室，因为我洗澡有些怕冷，而小空间更暖和。水流不是很强，也算够用。我打好洗发水，快冲完泡沫时，觉得喷头的水越来越凉。我把水阀调到最热的那头，加紧冲完头，水已经冰凉。眼见没有希望再出热水，我只好出来擦干、换上睡衣，然后下楼去找锅炉间，看看为什么没了热水。

锅炉间在厨房的背面。右边的一面壁橱加下面的洗衣机和烘干机就占据了一半空间，左边一个洗手池，剩下的就是前面一台大锅炉以及连着它的各种水气管道和电线。锅炉里发出嘶嘶声，仿佛快要断气。面板上闪烁着 E05 的代码，大约是个错误代码，我对锅炉维修一窍不通，只能在网上联系房东。房东连连道歉，说现在已经晚上八点多，今晚不可能找到修理工，建议我出去找个酒店先住一晚，他会报销费用。另外他说锅炉左下方有个黑色的开关，可以试试关掉重启几次。我开开关关好几次，每次锅炉都像要攒足力气吐一口痰一般，发出一声深吼，然后便回到了那断气前的嘶嘶声。

我到车库打开灯，看到那个本来有些瘪的车轮似乎更瘪了，想到外面还有个泥土陡坡，下过雪后恐怕是不容易开下去了。我按下车库门开关，想看一眼门口的雪有多厚，但开关不管用，不知是否是车库门的电路被冻出了毛病。看样子今晚没了选择，只能继续呆在这房子里。

空调面板上显示现在是二十六度。锅炉坏了之后，也就没了暖气。正常情况下，不开暖气的房子室温会每隔一小时大约降半度，这样到明早找来维修工之前，应该还能有十九度，对我来说还不算太冷。

我再次穿过厨房回二楼。这房子的墙上挂着各种饰品，比如客厅墙上有鹿头、弓箭、船桨等等。厨房的墙上有两样饰品让我觉得有些好笑，西墙上一把擦蔬菜丝的金属擦子，东墙上一口铸铁锅。它们算什么饰品嘛。

卧室有一扇天窗在斜面的屋顶，躺在床上便可以看到夜空。我打开《陶庵梦忆》看了两分钟，还不及翻页就昏睡了过去。

## 二、冷酷的熊

在一座杉树林中，有一头小黑熊守在一处水花激荡的山涧边抓鱼。试图洄游的鱼很多，那头熊可以轻松抓到吃不完的鱼，所以每条鱼它只吃一口鱼脑就丢掉，非常惬意。它不停吃啊吃，水流一直冲啊冲。哗啦啦……哗啦啦……最后那些被丢掉的鱼全部排成一个方阵，朝西边的天际飞去，鳞光闪闪。那黑熊吃饱后，躺到满是枯枝败叶的地上，渐渐变成了一头白色的玩偶熊，地上也开始长满青草，满是春天的气息。我走上前去，和白熊躺在一起，感觉到它的皮毛温暖而柔顺。小溪里的水依旧哗啦啦……哗啦啦……

不知道夜里几点，我伸了一下蜷了很久的腿，一脚踢到了床尾一件又硬又冰的物体。我本以为是床头的栏杆，但那冰冷的东西似乎很粗。我缩回脚，正在半睡半醒中思考这到底是怎么回事时，突然后背一凉，好像有什么东西钻进了我的被窝，散发着寒气。随着一股冷气吹到我后颈上，寂静的卧室里响起一个嘶哑的声音，说出一句话：“你为什么把水关掉？”

这下我一把掀开被子，跳到了地上，彻底醒了。

那东西顶着被子慢慢站了起来，一双脚先露了出来。借着天窗的微光，我看到那不像人脚；左脚有白色的皮毛，右脚则是一具白骨。

“你为什么把马桶里的水关掉？”

被子滑落到后面地上，一头白熊站在床上。它除了右耳残缺、头上有个黑疤之外，通体煞白，连眼珠都是白色的，又或许它没有眼珠，我看不清。它跳下床来，又是一阵寒气逼来。我退到墙角的一把扶手沙发上。

“哼，看来你都忘了。十年前你假意接近我，后来却打昏了我，夺走了我的脚掌。为了不被守林人发现，你就把我带回来囚禁在这卧室外面的陶瓷模具里。没想到今天你还会回到这里。”

我的脑袋一片浆糊，问：“你说的都是什么？我只是觉得马桶漏水太吵，还浪费水，所以把它关好了。我不明白你说的，我并没有干过那么残忍的事情啊。”

“害我受如此重伤，又关我十年，现在竟然还狡辩！”白熊伸手一把卡住我的脖子，它像一罐打开阀门的液氮，浑身散发着冷雾。卧室内的气温大约降到了冰点，天窗玻璃嘎嘣一声裂了一道缝。我感到有些窒息，在单薄的睡衣里冻得瑟瑟发抖。

“请松手……”我挤着嗓子恳求道，“让我回想一下……”

它略微松了松手，我可以呼吸了，但空气依然冻得我连鼻毛都粘住了。我似乎想起了那头温暖柔顺的白熊，但后面发生了什么，我真的想不起来了。

“事到如今，残废的我已经无法离开这栋房子，唯一能做的事情就是听马桶传来的流水声，它还能让我想起过去溪边自由自在的日子，而你竟如此铁石心肠地夺走了我最后的慰藉。”它吐着寒气继续说。

“啊，十分抱歉！我立刻去把水重新打开！”我艰难地推开它的手，从沙发上起身逃去卫生间，迅速反锁上门，也不知能否挡住它。不管怎样，先得平息它的怨气。我搬开马桶水池的盖子，发现那个浮力球不见了，只好用手轻提着水阀上的铁链，让水流下去。

透过门底缝，我能看见那双脚的影子。“不够！不够！我要更多的水声！”它嚷道。于是我继续打开洗脸池的水龙头和浴室的淋浴喷头。“马桶的水声怎么停了？”我只好回到马桶前，在水里提着那根铁链。

“水太急了！”……“水太小了！”……

我在它的抱怨下不断调整，但它始终不满意。一小时，两小时，三小时……我在马桶前站得腿脚发麻、又困又累，而空气的寒意丝毫不退，我已经把架子上的浴巾全都裹在身上。马桶水池里的水也越来越冷，最后索性开始结冰。我换了左手去提着铁链，把右手放在脸上捂着，但怎么也捂不热。

门外的埋怨声依旧不停。我想再换一次手，但发现右手粘在脸上拿不开，而左手被冻在了冰里拔不出来。再低头一看，脚也开始变成冰块，接着小腿、大腿都变成了透明的冰柱。门外白熊已经不满至极，它把骨头爪子从门缝底下伸了上来，马上要转开门锁，但我却无法动弹。

正焦急着，我突然想到，腿怎么可能冻成透明冰柱呢？这一定是在做梦！想到这里，我拼尽全力将手从脸上扯开，扯得生疼，仿佛要掉一层皮，才终于醒了过来。睁眼一看，我的脸粘在冰凉的书皮上，而手脚都睡麻木了。

我翻身躺了一会儿才恢复过来。从天窗看出去，外面蒙蒙亮；看一眼时间，才早上四点半。我已经睡不着，便起来打算下楼做早饭。走出卧室，看到那陶瓷小熊依旧立在楼梯口，似乎没什么变化。摸了它一下，凉凉的，只是正常陶瓷的触感。我正下楼梯时，听到下面客厅里咯噔嘣嘣几声，好像是一堆东西掉到了地上。

## 三、断头的鸭子

吊扇依然轻声嘎吱着，扇着似有若无的风。我走到客厅沙发前，看到地上横七竖八散落了一小堆木头鸭子。每一只都断了脖子，断头上黑亮的眼珠仿佛朝我射出憎恨的目光。

昨晚我明明只是摔断了一只鸭子，为什么现在多出来好几只？我困惑地看着这七只断头鸭子，心想不管怎样，要是弄坏了屋里的东西，还不知房东会让我赔多少钱，所以还是想办法把它们粘起来，别让房东看出破绽。

翻遍一楼的大小抽屉和橱子也没找到胶水。不然就像小时候一样，用米饭来粘吧。反正一会儿还要吃早饭，不如就煮一锅稀饭好了，这样吃完还可以用米粒粘鸭子。我在高压锅里加好米和水、定了时，就回到了客厅。

突然我想到昨天买过一瓶蜂蜜，说不定它也足够粘。我再回厨房，从工作台拿了蜂蜜。路过灶台时，我发现昨天那个我没有用的平底锅靠着灶台电源开关、锅把手朝上、立在灶台上。我记得昨晚我只是把它平放着，不知今早它为什么会立着。再朝锅里一看，里面还粘着烧焦的油渣，散发出类似桐油的腥腐味道，就像放了几个月没洗过一样。我想起来车库里的烧烤架上的油渣，有人把它们拿到锅里来了吗？

莫非我还在梦中？我环顾四周，并没有其它特别的异样。或许墙上挂着的那把金属擦子锈得更厉害了，而那口铸铁锅似乎更黑了。

我靠在客厅沙发上，一边隐隐疑惑，一边往断了的鸭脖子上涂蜂蜜，然后把鸭头紧紧压在脖子上。多余的蜂蜜从缝隙里挤出来，就像闭眼挤出来的泪水。

若一个人自幼便被一直灌输“要坚强、要坚持”的观念，那么成年后遇到就算再难承受的事情，他也会死扛到底、绝不掉泪。然而，除非他拥有无比的运气，否则他终将遇到一件生生折断他脊梁、让他不得不掉泪的事情。就算如此，他也会使劲闭眼、迅速将眼泪挤掉、擦干，继续维持他的坚强标签。

我粘好最后一只鸭子，手扶着它半躺在沙发上，等着蜂蜜干，看外面的天慢慢亮起来。云杉依然笔直地站在窗外。远处白了头的高山一座接一座，山下有无数的湖泊，蓄满了白发人无尽的眼泪。眼前这狭长、静谧的影山湖，装的是谁苦涩而绝望的眼泪？……

我的身体迅速膨胀，越来越高大，眼看落基山很快降到了我的膝盖之下，而我的头已经伸出云层。可能是空气太稀薄的缘故，我感到呼吸有些困难。我抬起双手看看，但手是透明的，我看不到，只感觉它们陌生、肿胀、麻木、失了触感。在晕头转向中，我仿佛刑天一般蛮力挥舞着双臂，驱散团团围住我的乌云。很快，云层被我呼呼地全扇开了。夏天的毒日头直射到地上，晒化了所有雪山，晒干了湖泊，最后也晒干了一群野鸭。我蹲下来，看着一片焦土，难以相信这都是我干的。我不是有意的。至少，我没有这么大的恶意。

哔……哔……哔……

高压锅一阵急促的蜂鸣将我拉回现实世界的沙发上，应该是稀饭煮好了。看来起太早还是容易犯困。木头鸭子还在手里握着，然而我低头一看，它的头掉在旁边，断了的脖子里密密麻麻都是蚂蚁，黑压压地不断往外爬。很快有些都爬到了我手上，毛扎扎的。我鸡皮疙瘩都起来了，赶紧扔掉鸭子，跳下沙发，使劲甩手，甩不掉的蚂蚁就用嘴吹掉。

茶几上另外六只我粘好的鸭子也一样，头全部又掉了，茶几上的蚂蚁四面八方乱爬。这么点蜂蜜竟然会招来这么多蚂蚁？

哦，不，不是六只鸭子！茶几四周的地上不知什么时候又多了几十、甚至上百只断头鸭子，黑眼珠都盯着我。

我本来只碰断了一只鸭子，为什么现在出来这么多？这么多断头鸭子，我得粘到什么时候？还有这一地蚂蚁是怎么回事？

莫非我没有真的醒过来？我抬头看了一眼客厅墙上的鹿头。鹿头仿佛看透了我的心思，开始旋转起来，化成一股白烟，从壁炉的烟囱飘走了。对，我一定还在梦中。但那大片的蚂蚁看起来还是令人非常不舒服，于是我从客厅跑进厨房，拉上客厅的滑动门。门上没有锁，于是我将一盏台灯的插电线一头系在餐桌腿上，另一头系在门把手上，这样门便拉不开了。

## 四、灼热的平底锅

可是高压锅的指示灯是亮着的，这说明我刚才确实是煮了稀饭。高压锅的面板上显示着红色的 L0:01 字样，这表示食物已经烹煮完毕，然后保温过了一分钟。

不管怎样，我肯定是不想回客厅了。先填饱肚子吧。只吃点稀饭是吃不饱的，我想还是得烙两张鸡蛋饼。等我去灶台上再一看，那平底锅又平放在了电炉圈上。粗糙的锅底涂层跟昨晚看到的一样，而锅里也干干净净，没有油渍。

烙饼只能用平底锅。我带的高压锅虽然功能很多，但毕竟不是不粘锅，所以没法用它。我用水冲了冲锅，擦干放回电炉圈上，再拿出冰箱里的鸡蛋、地上的面粉和土豆，打算烙几个土豆丝蛋饼。拿一个土豆来削皮，发现土豆皮皱巴巴的，好像不新鲜了。我在沃尔玛买了这么多年土豆，从来没遇到过一夜时间就能变得不新鲜的土豆。一刀下去，看到里面都已经是深褐色，看来已经烂掉。拿了第二个土豆，再削一刀，像脓一样的黑汁流过了我的指缝，从手背上滴进了水池。我看着沾满烂黑汁液的手，心里一惊，突然觉得厨房的空气不太对，有某种腐蚀性的东西充满了厨房。

我已经不想再去思索这到底是梦是真。东坡曾感叹，世事一场大梦；左帅也讲，入世皆幻。我们都逃不出红尘的大梦，又何必在意身处大梦中的哪个小梦或小梦中更深的梦。

所幸鸡蛋看起来还没坏。我把四个鸡蛋打在一个大玻璃盆中，往蛋液里加几小勺面粉、一点盐和一把葱花。烧热油锅、搅匀蛋液，然后右手拿硅胶铲，左手提起笨重的玻璃盆往锅里倒了一些蛋液。我感觉第一次倒的蛋液有点少，于是提起盆，想再添一些蛋液，结果手一滑，盆砸到了锅里，我的左胳膊也跟着在灼热的锅沿上烫了一下。我忍痛把盆从锅里搬出来，然后去水龙头下冲了一下被烫的胳膊。翻过胳膊肘子一看，下面烫出了一道一寸多长的疤。几分钟后，我把鸡蛋饼盛了出来。再看胳膊，这道疤上起了一串小水泡。这是我下厨十几年来烫伤最严重的一次。

“高压锅就那么好吗？”

我正在水池前看着伤疤，身后传来一句话。我忙回头一看，平底锅又立了起来。

“昨天一来你就嫌弃我粗糙破旧，嫌弃地扔下我就抱起你最心爱的高压锅。”平底锅愤愤地说，“它干净漂亮、端庄大气、多才多艺，为你炖肉、煮粥、蒸发糕、烧鸡腿、酿甜酒、发酵酸奶，什么都会，难怪你一天也离不开它。”

我不明白这一番指控。我确实觉得高压锅很好用，是一件趁手的厨具，但只是一件厨具而已。每一件厨具都有它自己的用途，这些用途也没有谁强谁弱之分，或者我会因为某种用途而特别偏心。

“不是啊，昨晚是因为我到这里时就有点晚了，加上太饿太累，我就用高压锅随便煮了点东西吃了。”我讲这个理由时并没有十足的底气，因为赶时间和饥乏只是一部分原因，而确实还有一部分原因是平底锅的涂层看起来不好了。过去我一直被教导说涂层糙了之后就会有毒。尽管我并不太信这说法，但面对陌生厨房里的一口陌生锅时，我还是保险选择用不锈钢的高压锅做饭。“今天做早饭我不赶时间，也有精力，所以我还是用你烙了鸡蛋饼啊。你和高压锅各有各的好用。”

“我不管今早！我只说昨晚。昨晚你用的全部是高压锅，而我呢？你说，用没用？”平底锅纠缠道。

“没用。”我坦承。

“你看你看！你心里想的就是我没用！我是个没用的厨具！”

没想到它竟抓住了这样一个话柄。要是我在别人那里听到这样的对话，会觉得是个很好的冷笑话。可是在这里，我只觉得无言以对。

它大声嚷着，锅身又开始变烫，锅里冒起烟，渐渐析出一撮撮我看到过的黑色油渍，簌簌滑落到灶台上，仿佛一堆死蚂蚁。

它继续说道：“高压锅不仅会做各种饭菜，而且做好了会叫你。刚才稀饭煮好了之后，它见你过来还跟你抛媚眼。我实在无法忍受！”

媚眼？我摸不着头脑。哦，它说的大概是刚才那个 L0:01 的时间指示，两个零像一双眼睛，中间的冒号闪烁着，也许像挤眉弄眼吧。这观察和解读实在出乎我意料，仍然无法接话。

“最后你终于想起了我，却还不小心爱护我，用玻璃盆重重砸了我。我必须给你一点颜色看看。”

原来我烫伤胳膊是这么回事……“是！报告长官！我看到颜色了，是淡红色！”我举起胳膊上淡红色的疤痕，像好兵帅克一样无奈地开个玩笑。

看来地上的土豆也是昨夜被它给腐蚀了，而鸡蛋在冰箱里躲过了一劫。我还没有两叶强大到能够过滤腐气的肺，所以无法在这种空气里久呆。

我没再多说，端着稀饭和蛋饼逃去餐桌上，默默吃完了早饭，望着窗外发了一会儿呆，回想刚才的事情。在这房子里，不管我是否真的睡觉，似乎只要我停下动作，就会陷入新的梦境。

金属擦子在我的手背上擦，我眼见关节处的肉被小块小块擦掉，血像泪珠一样涌出来，填满小坑，再溢出滴下去。我已经知道这是梦，伤口虽然很疼，但不必包扎。只要等一等，时间的庸医就会治愈时间的钝刀割开的伤口。

铸铁锅扣在我头上，越来越厚，越来越重，快要压断我的脊梁。尽管要甩掉它只需要低一下头，可我不能甩掉它，因为这么重的锅掉下来一定会砸坏屋里的家具。我已经弄坏了木头鸭子，不能再损坏更多东西。

从昨晚起就停了暖气的木屋，我只穿着睡衣已经感到很有些凉意。我清醒过来，擦子和铁锅都回到了墙上。已是上午九点，修锅炉的人还没来，我想再去试试锅炉过了一夜能否重启成功。

## 五、狭小的锅炉间

为防止修理工过来敲门时我碰巧在某间内屋听不到，我打算去客厅把大门背后的锁先转开，这样他到了就可以自己开门进来。我解开绑着客厅与厨房之间的门的电线，拉开滑动门。客厅里的蚂蚁已经没了，但一大堆断头鸭子还在。转开锁、打开大门后，我发现大门外层的防风暴玻璃门被锁住了，那把我昨天打开后挂在一边的密码锁又被挂回了锁孔。我拼命地推搡摇晃了半天，也推不开这门。

于是我再去车库，车库门也依然打不开，而我那个车轮胎已经彻底趴平。掏出手机，显示室内的无线网还连着，但上不了网，而这偏远山区又没有手机信号。这下我是真被困死在这木屋里，没了出路，只能寄希望于修理工能早点过来帮我打开大门。

嘎吱一声我推开锅炉间的门，穿过洗手池和洗衣机之间的狭窄通道，来到锅炉前。它依旧低声喘息着，重启的效果也和昨晚差不多，看样子非得专业维修人员过来不可。

洗手池上方有一扇布满灰尘的小窗，角落里还有几张小蜘蛛网。我看到外面的天已经大亮，但这窗户不是特别透光，所以这小间里略有些昏暗。等我再回头看向锅炉这边时，发现黑色和红色交缠的电线都变成了蛇，扭曲着从墙上、天花板上朝门口爬去。顿时我身后的门上就挂满了黑色和红色的群蛇，交缠蠕动着朝我嘶嘶吐着红信子。虽然我一向胆子比较大，但蛇这种丑陋的生物还是让我感到极度厌恶和恐惧的，更不必说当我面对一大群蛇时。

此刻，我残存的一点理智回想到昨天我在 80 号州际高速公路上开车的情形。我曾经是那样自由自在地奔向更广阔的自由，怎料这通往自由的路越走越窄，现在竟被困在了小小的锅炉间里。这究竟是我一直疏忽大意，还是命运的捉弄？我以为所有车道可以任我选择，根本不必理会什么迂腐的交通规则，可当我随意选择了高压锅后，结果便是一道疤痕的惩戒。究竟是谁在冥冥之中为我制定不可忤逆的规则？

“咳……你……就别想……再出去了……”一个虚弱的声音从锅炉中传来，“你……必须……把我修好……咳……”

原来是这锅炉困住了我。“为什么要把我留在这里？我根本不会修锅炉啊！”我委屈地问它。

“你开开关关……已经折腾我死去活来……十几回……我绝不能让你……就这样轻易走掉！”锅炉的语气严厉起来，“我的进气管里堵了干草……吸不进燃气……我的心已经凉透……我需要燃气……不然我的零件要冻坏了……”

“很抱歉，可是我说过了我不会修锅炉，况且我自己现在也很冷。就算你用满屋的蛇把我囚禁住，你要的我也实在没法给你。”我表示无能为力。有几条蛇从我拖鞋的缝隙钻上来，绕着我的脚踝往上爬。我明知这大概不是真的，但皮肤被这些冷血动物的鳞片摩擦过去，真让人难受。若不是忌惮蛇群可能会一起来咬我，我真想一把提起这几条蛇的尾巴，把它们狠狠抽在地上或墙上。

世事就这么奇怪。门没锁，但把手上全是蛇。窗没关，但透不过几束光。冰冷的人，用冰冷的方式，从冰冷的人那里索要能量。

我小心地拿掉腿上的蛇，然后爬上洗衣机，垫一块毛巾在上面，盘腿坐下，缩着身子以维持体温。呆望着窗外，等待不知还会不会来的修理工。

## 六、云杉的救赎

转眼大概已经是下午三点，窗玻璃上浮现出斑驳的影子，似乎是树影，但我记得木屋的西边并没有树。等影子凑近，我看到是一棵朝窗边缓缓移动的云杉。

“你好！我知道你很惊奇，但别慌。”云杉开口道，“我是这木屋东边的那棵云杉。你不认识我，但我已经认识你很久了。”

“你怎么会认识我？”我的确有点惊奇。

“我们前世就是邻居和好朋友，一起从小玩到大的。后来你继续转生做人，所以被抹去了人世记忆，而我变成了一棵树，记忆保留了下来。这些你就先不用管了，我知道你现在遇到了大麻烦，就过来看看情况，但我首先要说明的是，我只是一棵树，没有办法直接救你出来，最多只能在此和你说说话。”

“好的，我知道，真正能救我的只有我自己。不过在这荒郊野岭居然遇到一个前世的旧相识，这也是有点太神奇了。”

“自救是你唯一的路，你明白就好。”云杉点点头，“家家有本难念的经，而且每个人都觉得自己家那本最难念。若你不介意，我给你念念我的经吧。”接下来，云杉给我讲了一些往事。

“我是六年前到这里的。在那之前，我生活在远处那片树林里，终日四处嬉戏，了无牵挂。一天，另一棵树告诉我这边有一栋孤僻的木屋，看起来古怪得很。它还怂恿我、拖着我过来看。当时这木屋四门紧闭、灰头土脸，里面黯淡无光，但我还是隐约看到了它坚实的地基，整个房型也很别致。挺好的一栋房子，只是看起来有些丧气，但丧气中又夹杂着一丝逗比，逗比里还透露出一丝可怜兮兮。当时我内心有点波澜，甚至还有一点想笑。后来我就决定要守护陪伴它，它的窗户也渐渐明亮了起来，但是我很快遇到了两个麻烦。”

“什么麻烦？”我好奇地问这位刚与我重逢的前世好友。

“首先就是我搬到这里没过多久，这木屋可能有些过度依赖我，毕竟它之前已经与世隔绝太久。每次我回到以前的树林玩时，它都有些不高兴，会关掉灯、拉起窗帘、甚至从烟囱冒出浓烟来熏我。它不高兴了好几次之后，我终于问出了原因。原来，它是担心拖我过来的那棵树再把我拖走，因为那棵树看起来高大威风、阅历丰富，而我本性又喜欢到处疯玩。我考虑了很久，决定再也不回树林了。”

“所以你再也没见过那棵带你来的树？”我问它，心底泛起一股佩服之情。

“是的。不光是那棵树，这几年来我就一直站在这里，几乎都没和其它任何树说过一句话。之前我已经玩了好多年，该安定下来了。我不想等将来我离开这个世界时，只留下玩乐一生后的一片空茫。”

我沉默了一会儿。我感到有些不可思议——当它被烟熏、被怀疑时，竟然没有想逃走，反而更坚定地留了下来，那是怎样的胸怀与情感。而我，一旦察觉到那种空气，便只觉得自己被腐蚀着，一心只想逃离。我看着胳膊上的伤疤，想起达里奥那句在我脑中重复过无数遍的话：不要对痛苦感到烦躁或被它压垮；痛苦是上天对你的提醒，提醒你有什么重要的东西等你学习。

或许，这道伤疤不是平底锅给我的，而是上天的一道提醒。只是，我似乎还需要更多时间去领悟，那待我学习的东西是什么。

“现在先不用想太多，以后还多的是时间慢慢想。”云杉察觉到了我的沉思，打断了我说：“其实你也不用太严肃认真的。在我眼里，这木屋有时候生起气来就是个十足的逗比。瞧它头上呼呼冒烟，嘴里还拼命吼着‘没有啊！’‘哪有啊？’‘根本就没有！’否认自己生气。”

我突然意识到我已记不清人生中上一次开怀是何时，大约已经被消极封印太久。听它对负面情绪场景的描述，我惊讶地发现自己居然被逗乐了。过去我特别害怕面对别人的负面情绪、极度厌恶冲突。每当我置身冲突中，我都很难把自己抽离出去、以旁观者的角度看自己和他人，而只会一味被情绪带着转圈、纠缠。也许这就是我要学习克服的。

“再给你讲第二个麻烦吧。”它继续道，“我决心定居这里后，才发现这木屋的建造商非常不喜欢我，她觉得这周围到处都是云杉，在屋前种一棵普通的云杉实在是毫无意义。在很长一段时间里，她对我的态度十分冷酷；今天各种刁难我，明天扬言要把我挖走。她嫌弃云杉太瘦、太高，对这栋木屋没有价值，不如种一棵宽大的柏树，这样室内可以享受更好的隐私，暴风雪来的时候还能帮屋子挡一挡。虽然她那样的态度让我感到伤心，但我并没有怨她。相反，我每天都努力摇摆着树枝向她问好，我会招来各种小鸟在窗前歌唱，有时候我让狐狸、松鼠之类的小动物爬到我的枝头，也为这木屋增添了一些活力与生气。三年后，她终于改变了对我的态度，不仅不再冷若冰霜，而且喜欢我甚至胜过这木屋，没事总是拉着我聊天。”

我又一次被震到。对我而言，以德报怨只存在于传说和故事中，总感觉不那么真实。我很难想象，一个平凡的生物能有毅力付出如此的忍耐与诚意去化开别人的冰霜。我面对冰霜只顾得上自己发抖；别说忍耐三年，就算是三小时，我都感觉自己被冻得支离破碎、痛不欲生。更让我感到敬佩的是，云杉本是无辜的，建造商的冷酷不是它主动造成的，它却能将冰霜最终融化为温泉；我呢，就算清楚冰霜是自己一手造成的，也明白我化解它比云杉要容易得多，但我仍然只会躲藏，陷在冰苦的林野无法自拔。我头一回发现自己其实很懦弱，却自欺地贴了这么多年的“坚强”标签。

“好了，今生的事情我就只讲这些吧。你大约听说过吧：世间所有的相遇，都是久别重逢。我们这次久别，也别得有点太久，一别便是一世。如果你愿意听，我也想给你讲讲前世的一些事情。”

太阳渐渐西斜，窗户上云杉的细影越来越高。

以前我从未想过为什么杉树都那样高而尖，现在我终于隐约体会到，那是它们的坚毅和坚忍。它们把体内那惊人的生命力凝聚于树尖，耐心地等候、等候。终有一天，它们会穿透乌云、刺向夜空，摘取一颗闪亮的星挂在它们的树尖，那是它们努力的终极证明、一生的至高荣耀。它们是平凡的，却也是不可挡的。

停顿了几秒后，云杉继续讲：“小时候你住我家隔壁的小平房里，我家是三层楼房。那时你特别顽皮，又总喜欢干一些冒险的事情。我比你小几岁，胆子也比你小很多，所以经常只能在一边羡慕着看你玩。就比如我家楼顶的天台是奶奶的花果园，四周只围了一圈很矮的砖护栏，你竟敢骑在上面，还往下丢装水的塑料袋子之类的东西玩。水袋啪的一声砸在你家房顶砸开花，然后水从瓦沟里细细流下屋檐，大晴天里就像莫名其妙下了一朵小云的雨。虽然我看着觉得很有趣，但我自己无论如何也不敢那样玩。你带着我上山下河、捞鱼摸虾、放火骑车、弹弓打苍蝇、棉球钓青蛙、鞭炮炸牛粪……一直到你十二岁去了镇上上中学住校，我们才渐渐没在一起玩了。后来你考上大学，去了一千五百公里外的城市。刚开始我们还有书信往来，但也越来越少，慢慢就断了联系。”

它叙旧的这些事情我自然是一丁点都不记得了，但眼前还是浮现出两个充满童趣的小朋友形象。“那再后来呢？我们又重逢了吗？”我问。

“没有。”它笑着回答，“之后我们的人生轨迹完全不同，天各一方，再也没有见过面。不过，你先不要觉得遗憾，故事并没有就此结束。长话短说，我大学毕业后去了一个大城市工作，却不知那将是我一串噩梦的开始。无论是职场还是家庭，都让我伤痕累累。原本天真的我，不知不觉被卷入公司里的权力斗争。我曾经当成亲弟弟妹妹对待的两个同事，暗地里投向了我们的敌对阵营。他们为了打垮我们这方，竟然合伙诱我入圈套，再捏造证据冤枉和污蔑我，以指责攻击我的领导渎职、让公司陷入了巨大风险。我的人生中从未遭受如此的背叛，也从未想过人类竟然可以这样互相欺骗和斗争。一时间，我像一根无根的野草，被一场沙尘飓风狠命拍打、碾擦、撕扯，然后被卷到完全陌生的万米高空，再心惊胆战地被抛下、粉身碎骨地坠地。每天下班后，我都感觉万念俱灰，任凭决堤的眼泪不停奔流。”讲到这里，云杉的语气有些颤抖，没了之前的平静。

我已忘记我在前生是什么样的人，但现在我的心中仍然有很多天真。我也遭遇过一场职场背叛，也曾为之流下委屈的泪水，但与云杉讲的事情相比，我已经算是相当幸运；起码我没有被陷害，我除了遭受精神上的反复折磨，也没有什么其它实质性损失。

“哦，不对，我说错了，我并非无根的野草。”它似乎很快从这段痛苦回忆中跳了出来，纠正补充道：“我是有根的。那时候我马上就要组建家庭，然而因为我整晚整晚地沉浸在痛苦中哭，家里的氛围也渐渐冰冷起来。我不断被数落、呵斥、嫌弃、厌恶、疏离……我受不了耳边一些没完没了的絮叨和对我强行灌注某些偏执的旧观念，一度盯着二十八楼的窗户萌生那可怕的想法。后来我在绝望的悬崖边挣扎，昏头昏脑一把胡乱抓住了一根救命稻草。我满怀希望和喜悦以为那是救命稻草，可是，那只是一根烧焦的木头上冒出来的一缕飘渺的轻烟。很快，烟散了，梦醒了，我头朝下坠入了深渊。在坠落中，我只见自己手心摸了一把焦黑的炭灰。衣服擦不净它，泪水也冲不掉它。就算我离开这人世，也无法再带走这污迹。”

我已经听得目瞪口呆，忘记了周围的一切。那冷酷的熊、粘不好的断头鸭、灼热的平底锅、困住我的锅炉与蛇、逃不出的木屋，仿佛都被暂时收入了另一个时空。在我眼前，只有白茫茫一片大地和高耸的一棵云杉，偶尔有亮晶晶的流星划过夜空。

“过了一些日子，我发现自己又醒了过来，躺在自家的床上，非常虚弱，只能睁眼看看周围，但说不出话。”云杉恢复了一些平静，继续讲。

“然后你的家人应该悉心照顾你到你康复了吧？”我问道，以为这故事差不多讲完了。

“他们是很照顾我，不过我康复是几年后的事情了。”它轻声苦笑着回答，“我逃离了那是非之地，但那个对我絮叨和强灌执念的人没有放过我，而是告诉了我所有家人我手里的污迹。于是我最后的、本来最安全的港湾也变得风雨飘摇。我手心里的炭灰，融进我最后快哭干的眼泪，调成了浓黑的墨汁，一滴滴地滴在我淳朴无辜的家人身上，就像滴在粗糙洁白的宣纸上。我眼见墨汁在他们身上扩散、蔓延，却什么都不能做，也什么都不能说。我觉得我这辈子也无望洗净自己、洗净他们。要洗的太多了，实在太多了……我只是个普通的人，在绝望中犯了一个并非十恶不赦的错，我真的无法承受如此残酷且连绵不断的惩罚。当你不小心踢断一只木头鸭子时，你能料到将来会握着一手的蚂蚁去修复一百只鸭子吗？”讲到这里，它第一次问了我一个问题。

“我不能，我也万万没有料到弥补过失会如此艰难，会像西西弗斯推石头一样，推上滚下怎么也推不完。”我答道。但心想，修复木鸭的断脖应该比修复亲人的碎心容易得多吧。

“是啊，你也是个凡人。你曾是个放牛娃，也是个大学生，是父亲，也是儿子，是引路者，也是打工魂，终归还是个凡人。我们都是凡人，凡人都不完美，都会犯错，都会觉得赎罪之路艰难。”它略微宽慰了我一句，接着讲：“当我失去了世间一切的希望后，不免又想走向那扇窗，只需要一跃三秒，我便可以将一切罪过忘在身后。我知道我的父母一定会万分伤心，但想到我哥已经结婚生子，所以两位白发人还有好好活下去的希望，我可以放心去了。”

我的心提到了嗓子眼，暗喊：“不要啊，千万不要！”但我不可能将我的劝阻挽留之声传到前世之人的耳中。

若你觉得世上已无人在乎自己、在孤独和绝望中想做傻事，请相信远方一定会有人在乎你、有焦急的声音想挽救你，只是他可能离得实在太远，甚至远在来世。无论如何，请保留一丝耐心、一线希望，不要辜负他尚未到来的殷切关怀。

我正这样想着，云杉清清嗓子，语调开始明亮起来：“你知道最后是什么救了我吗？”不等我回答，它说：“我最后整理我的物品时，发现几年前我给你写信的一篇草稿里，曾抄录过一位歌手的一句话：‘没有选择的你，你一定要选择你自己！’它就像冥冥中安排好的一句预言，让我从长达半年的梦魇中重新清醒过来。我不能就这样放弃，决不能放弃！”

我心里一块石头落了地，湿润的眼角充满悲悯和欢喜。

“后面的路也并不轻松。白天我努力地生活、努力地重建对人类的信任，可是夜里还是会被过去的创伤反反复复侵袭，经常噩梦连连，而且无论我怎样想醒来都醒不过来。这种状况持续了几年，我才渐渐学会与噩梦共存。我知道那只是回忆的虫子在啮咬我，并不会真的对我造成伤害。不知道你是否明白，受过重伤的心门一旦紧锁，若再要让它重新敞开，会是一个漫长而痛苦的过程。这个过程中哪怕有人善意轻抚一下这扇门，它还是会吓得立刻重新锁上。不管怎样，走在冬日的阳光下真好。”云杉长呼一口气，“前世的故事就讲到这儿吧。”

我又沉默了一阵，问它：“那时的我知道你这些事情吗？”

“你不知，我没告诉过你。我们已经远隔重洋，我偶尔从我妈——也就是你小时候最喜欢的张阿姨——那里听说你的消息，但我们再也没有联系过。我小心保存着当年我们所有的信件。回想起来，我觉得当时写了那封信实在太幸运了。”

尽管开始的时候云杉叫我不要觉得遗憾，但现在我心头还是掠过一丝遗憾，因为我没能听到它彻底摆脱噩梦、打开心门的消息。它现在结束了这个故事，想必后面依然有多年的辛苦心路历程，只是不想再让我知道而已。

我望着夜空，一边沉思，一边静静等待着。云杉不再打断我。两小时过去，我终于等到最亮的一颗流星出现，赶忙用右手手指在左手的手心写下一个字，握紧它，拿出我平时朝湖里扔石头的劲头，奋力把字抛向天空。我闭上眼睛，祈愿流星把这封一字信带回前世。就让我幼稚一回，相信流星真的管用吧。

## 七、各自的归途

几秒后，流星的尾巴消失在夜空。我睁眼回到了锅炉间。锅炉还在喘息，红色和黑色的蛇依旧满地，但我已经不再恐惧。

“之前我已经说过，你被困在这里，我无法救你出去。”云杉回到了我的困境话题上，“我理解，你是骨子里向往自由的人。你在乡村的池塘里钓到过鲫鱼，也见过白鹤在春天的水稻田里起飞，你至死都会向往自由的生活。你感到束缚，并不全是你自己的问题。”

“可是我以为我进了一栋屋子，就应该既来之、则安之。总是想着看窗外不同的风景、闻闻不同的花香、听听不同的鸟鸣、从一个枝头攀爬到另一个枝头，这样感觉自己似乎像个贪婪的坏人。”我说出自己的一个疑惑。

云杉听到我这样说，噗嗤一声笑了。“别想多了，世间哪有坏人自己觉得自己坏的？”它收起笑声，接着说：“是什么驱策着我们的渴望和痴念？这很难归结为某一个特定的动因，不能以简简单单一个‘坏’字来总结。你不记得了吧？小时候我们家养的母鸡总是喜欢偷跑到屋后的稻田里啄成熟的水稻吃。从人的角度来看，母鸡这样做很‘坏’。但是，从基因的角度来说，母鸡是什么？有人说，一只母鸡只不过是一个鸡蛋用来复制下一代鸡蛋的临时工具，那么它去偷吃稻谷也是‘身不由鸡’的。没有人不渴望自由，但同时所有人都要遵守规则，就像古人说的‘止乎礼’。世上没有绝对的自由，也不应该有太强力的束缚。自由与束缚之间的平衡点在哪里，也因人而异。像你现在被束缚在锅炉间，锅炉不顾一切找你要能量，而你尚在自身难保的状态，我就觉得锅炉的束缚可能有点过度。有一位前苏联作曲家的回忆录中讲了这么一段话：‘若想保住某件东西，最好的办法就是不去理它。爱得太过的东西容易毁灭，要冷眼对待一切，特别是你心爱的事物。那样，它们生存的机会反而多一些。’我想这段话，不妨也请这位锅炉品味一下。”

锅炉终于沉静了。门上、墙上、地上的蛇也都开始往回爬，一条接一条变回了电线。

“我前世的小挚友啊，”云杉呼唤了我一声，“天黑了，我也必须回去了。”

“好的，真的谢谢你啊！”我终于第一次、也是最后一次注视到它的眼睛。

“嗨，谢什么啊？”它觉得我说了句傻话。

“嗯，那么再见！”

“不，我们不会再见了。我没告诉你，我已经用完了灵界允许我与前世转生之故人交谈的所有时间。要是再谈下去，你我都会遭到严厉的惩罚，我们的所有记忆都会被抹掉，从此陌路。别担心，我相信你一定可以走出这重重围困的。要有耐心，别太苛责自己。要知足，要惜福。回去路上专心开车，不要胡思乱想。你要好好的，嗯？”云杉作完最后的叮嘱，便消失在了夜幕中。

“再见！”我对着它的背影默默地说。

现今世上最古老的树是九千五百多岁的云杉。也许我过完我短暂的一生后，很快便能等到来世的下一次交谈机会。或者，来世的来世。让那两个雀跃的小童，世世在记忆中雀跃……

我走出锅炉间，先来到厨房，给平底锅打满洗洁精泡沫，用温水把油渍冲洗干净，收到洗碗机的架子上晾干。高压锅暂时收了起来，这几天不用它也没太大关系。然后我来到客厅，为那些前世被我害得热死的鸭子们重新调大风扇。在呼呼的凉风中，地上的一堆断头鸭子一只接一只消失了，只剩下茶几上原先的两只。我弄断的那只依然是断的，但我打算不再欺骗房东，而是直接告诉他，该赔偿多少赔多少吧。最后我上楼到卧室，在潺潺的水声中，给冰冷的白熊穿上一只白色厚袜子、戴上睡帽、盖上被子。

这一夜我难得睡得相当安稳，睁眼天已经大亮。我起来发现床边有一张纸条，写着：谢谢你重新寻回善意，我已回到溪边，勿念。我感觉室内似乎又暖和起来。下楼一看，原来早上我还没起床时修理工已经来修好了锅炉。它现在像一颗充满活力的心脏，突突跳着，让空调重新开始正常运转。手机叮咚一声，我收到房东的回信，说摔断的鸭子只是不小心的小事故，没关系的，并感谢我告诉他。没想到这么轻松就获得了原谅。我从洗碗机里取出平底锅，锅底竟然已经光滑如新，于是早餐煎了一锅焦脆的土豆丝饼。

收拾行李往车库搬时，我才发现，原来这木屋还有个后门，可以轻松从屋里打开。有时候，人们都觉得自己是被关在牢房里的囚徒，疯狂地推搡摇晃这牢门，想要出去，可是他们不知道，还有很多侧门、后门其实都敞开着。但即便被告知有这些门，他们往往也只是扭头看一眼，还要继续摇晃那扇坚固的“牢门”。因为他们已经摇了太久，坚信那扇门是囚禁他们的唯一障碍。

我按了车库门按钮想打开门，但门还是没动静。这时我试了试另一个按钮，门立刻铛铛地升了起来。弄了半天，我以为这两个按钮的顺序跟自家里的是一样的，这才明白，控制右门的是左开关，而左门那边堆满了杂物，看样子那门已经坏了很久。前天我刚来时成功打开右门，只是歪打正着按到了左开关。生活中我们的恐慌和苦闷，有多少来自小误会和思维惯性？有谁能相信，无比可怕的问题也许存在一个简单的机关去解开？

车轮胎并没有完全瘪掉，跟来时差不多。虽然不是十足饱满，但依旧能开。若待事事圆满才能上路，那我们大概永远也上不了路。

我当然不会忘记到外面再去看一眼云杉。温润的朝阳将它的影子贴上木屋的墙。它静静挺立在窗前，没有动摇。仿佛忘却，前世今生的一切苦难。仿佛，昨夜今朝什么都没发生过。而迎着朝阳的我，却仿佛获得了新生。

离开木屋，坐上车准备出发去下一站时，我感觉扶方向盘的右手中似乎有一股奇异的暖流。车里的音乐放着科尔塔扎献给贝多芬的钢琴曲《Just for You》。幽静的琴键，敲击着我幽静的心弦。

我缓缓翻开右手手心。昨夜扔出去的那个字映入眼帘。一样的温度，一样的十划。

不一样的笔迹！

不一样的笔迹。
