---
title: 季读（六）：不材生长漫婆娑
date: '2022-06-30'
slug: useless-prosper
---

1. 杜甫《恶树》最后一句：方知不材者，生长漫婆娑。我最早知道不材是因为列弛[去年一篇有点烧脑的小说](https://www.liechi.org/cn/2021/05/useless/)。材与不材的平衡，实属人生一大难题。我最终琢磨出来的结论也比较平凡：我觉得人还是应该有材的，因为完全不材好像也没什么存在的意义；只是有材别太招摇，否则容易被砍。在眼球经济和网暴横行的年代，尤该如此。

2. [玛格达 · 狄内斯](https://www.douban.com/note/828888986/)选择当心理医生是因为“幸存者对受过伤害的人有一种认同感，提供帮助是自我疗伤的过程”。这个原因让我竟然感到有一丝共鸣，我对心理学也有浓厚的兴趣，不过我听闻心理咨询师的门槛相当高，估计我这个纯外行应该是不太可能从事这个职业吧（目前我依然对研究下厨更有兴趣）。

1. 我在 R 的邮件列表里混迹十几年，去年[第一次见到](https://stat.ethz.ch/pipermail/r-devel/2021-February/080473.html)锐扑厉教授道歉（我最近清理旧邮件才把它翻了出来）。本能上我有点想吐槽，但转念一想，这事还是展示出了一丝阳光啊：我们一直觉得[最严厉、最硬汉的教授](/cn/2019/04/software-apologies/)，还是会道歉的。

1. 读到[一个有趣的小故事说](https://www.washingtonpost.com/lifestyle/2022/01/31/library-book-idaho-dillon-helbig/)一位小朋友把他自己创作的一本故事书偷偷塞进了图书馆的书架。感觉以后可以鼓励自家娃干这种略带恶作剧的事情。

1. 我从未理解为啥近几年各种图标的扁平化趋势，[原本很醒目的标志，都变成了几乎纯文本](https://velvetshark.com/articles/why-do-brands-change-their-logos-and-look-like-everyone-else)。这到底是一股神马新时尚？几年前 R 的图标从那个充满金属感的立体图标变成了现在这个毫无生气的薄薄一层塑料贴纸（好像是敝厂的人掺和撺掇的）、以及敝厂的 RStudio 水晶图标改成平面蓝圈加字母 R，这两个改动都让我非常不解，刚开始也很难接受，但后来想想算了，你们时尚界的东西，我等粗人大概是永远不懂的。

1. 近几年我提过几次对[新闻的看法](/cn/2018/03/hate-news/)，核心意思也就是《[娱乐至死](/cn/2018/04/amusing-ourselves-to-death/)》中说的：看了那么多新闻，你打算采取、以及能够采取什么行动？答案通常是你在情绪上脑几秒钟之后，什么也不会做，“信息/行动”比无穷大，因为分母行动为零。最近又看了一篇[类似的文章](https://www.raptitude.com/2016/12/five-things-you-notice-when-you-quit-the-news/)，里面我额外注意到这几点：一、[负面偏误](https://zh.wikipedia.org/wiki/%E8%B2%A0%E9%9D%A2%E5%81%8F%E8%AA%A4)（negativity bias），也就是消极负面的东西对心理的影响比正面的东西要大，而不幸的是，新闻似乎是负面居多（我对新闻有这个印象，是不是本身也是负面偏误？即：我记住了更多的负面新闻）；二、作者认为人们信心满满大肆评论刚刚发生的新闻很搞笑——子弹还在飞呢，谁给你的信心下结论？三、积极关注新闻可能是假装宽慰你的良心——世上几乎每天都有惨绝人寰的悲剧发生，每念及此，要是你连关注都不关注一下，岂不是更冷血？所以看新闻吧。反正手机一关后，你依旧是什么都不会做，已经付出过良心的关注了啊。说实话这也是我的一个人生困惑，我有点难以接受看了悲剧之后什么都不做，所以我倾向于干脆不看，接受就是这么冷血的自己。

    文中有个词 indictment（控诉、声讨），刚好我前天在[韦伯词典中](https://www.merriam-webster.com/words-at-play/why-is-debt-spelled-like-that)见过它的动词 indict，说是 c 不发音，当时我还很惊异。英语有时候[真让人头疼](/en/2018/11/english-is-hard/)。

1. 我不是很明白为什么现在人们的观点这么容易极化，觉得有些人真的是完全丧失了理智。下面我说的话可能要一竿子打翻半船人，但我还是很想打。其实 [2014 年我已经打过一次](/cn/2014/11/inequality-in-us/)了，那就是：在美帝的有些华人对中国的攻击简直是丧心病狂。我完全支持对一个国家或政党的批评，也认为批评是绝对有必要的，但这些丧心病狂的人的问题就在于他们是无休止、无差别攻击，从他们嘴里听不到一句没有戾气、不嘲讽的话，似乎中国做的任何一件事情都是错的、都是弄虚作假、都是愚民、中国就是北朝鲜。

    其实我甚至连戾气都能容忍，但我实在无法忍受嘲讽。因为戾气起码还表示是用平等的身份在对话（尽管不好听），而嘲讽则是居高临下、觉得自己无比明智而对方无比愚蠢落后。只不过是生活在美帝而已，到底是哪来的底气觉得自己就已经开了天眼看穿了一切？

    我发这通牢骚的起因是我们有个北美的宜昌老乡微信群，群里有那么几位异常积极的火炮，他们隔三差五竭尽所能嘲讽中国的防疫，往群里发一些视频、照片和文章。若有人提半句对中国表示理解的话，那么他们就会群体而攻之，给对方贴标签（例如小粉红）。而他们散布的那些信息里，有些其实只是谣言，比如一次有一位往群里转发了号称“金山第一群演”的两张照片，又一次竭尽所能嘲讽中国的新闻都是假大空。我看到这没来源的照片之后，通过上面的姓名“寿玲妹”很快搜到了[辟谣的新闻](https://k.sina.com.cn/article_1989020644_v768e0be4019015pr4.html)。若那位兄台发照片前稍微有点考证意识，大约也不至于这么自信地嘲讽吧。可是失去理智的人是不会考证的（考证还需要搜索，多麻烦，而抬手转发照片并嘲讽几句多安逸），他们已经陷入严重的[确认偏误](https://zh.wikipedia.org/zh-cn/%E7%A2%BA%E8%AA%8D%E5%81%8F%E8%AA%A4)，即：一切与他们信念相符的“证据”，都会更加确认他们的偏误。当然，这些人要是看到辟谣的消息，其反应也必然是“辟谣也都是假的”。假的假的，中国的一切都是假的（当然辟谣也确实有假的）。所以我也根本不想在群里回应，省得惹一身骚。

    最让我震惊的是有一次那几位与群里负责侨胞事务的国内工作人员（我且称之为 C 哥吧）辩了起来。C 哥说：我不在美国，没有关于美国抗疫的一手信息，所以不对美国政策作出评论；若你们不在国内，可能需要了解更多关于国内的一手信息，包括国内亲属的感受是不是像你们说的那么糟，毕竟现在我们都难免受到信息茧房的影响。我觉得 C 哥说的非常公平在理，对自己不了解的事情就不要那么硬气地去嘲讽嘛。我震惊的是，一位我以前还比较喜爱的厨子（也是喜欢攻击的人之一）反驳说，我们在美国，不存在信息茧房的。言下之意，他们已经看到了全部真相，只有国内人民都是活在谎言里。美国没有信息茧房……当我看到这句话时，我觉得已经无法对话了。世上还真有人以为自己是上帝。到底是怎么以为的。

    我是颇有些心疼 C 哥的。虽然私下我并不认识他，他只是在政府部门工作的一位小职员，并非政策制定者，却要承受群体暴力攻击。在这个群里，只要眼睛还没瞎、脑袋还没失忆，就应该能看到、记得 C 哥之前是如何尽心尽力服务侨胞的。某位群成员的妈妈在宜昌病重无法就医，C 哥竭尽全力联系领导、为那位妈妈打通了就医通道。而后来呢，这位成员在群里的发言依然是攻击嘲讽式。当然我也得承认她在极其少数的情况下，会公平客观说句话，比如提一下在宜昌办事的便利程度比过去提高很多，不用再为了几个章跑断腿。这样的偶尔一句话，让我觉得还存在对话的曙光，不像另几位成员，这么久以来我真的是一句好话都没从他们嘴里听到过，只是无休止的攻击、攻击、攻击。过河拆桥真的是没良心啊。若是建设性的批评，那是无比珍贵的。若只是发泄自己的情绪、满足虚幻的自我优越感，那是彻底的自私和邪恶。若是为了祖国人民好（你们不是一向爱表达对群众疾苦的关心么），那么建议每次攻击之前先捐两千美元再开口说话，我觉得这样会比较实在。叉腰空谈谁不会呢，爽的只是你自己。

1. 我以前不知道《玫瑰少年》，对周深也不是非常了解，看了[一篇评论](https://www.douban.com/note/828814695/)，感受依然是娱乐圈的事情我不懂。首先，我觉得周深把《玫瑰少年》唱成什么样，是他的自由，当然别人也有评论的自由，但我认为没有必要攻击，更没必要群起攻击。其次，每当看到这种网络暴力现象，我都感觉网络像个斗兽场，我痛恨的是搭建斗兽场的人，而不是在斗兽场里死斗的人（兽），那些死斗的人本可以不必显露他们的野蛮兽性，只是背后有人希望他们死斗。比如社交媒体的发明者、从十多年前《非诚勿扰》以来的娱乐节目策划人，都是[斗兽场的搭建者](/cn/2018/04/amusing-ourselves-to-death/#躲躲猫的世界)，他们就希望人能互相攻击，以便从中渔利。在周深这个事件里，我认为浙江卫视不可原谅，它很可能是故意利用了周深，并且故意把节目剪辑得更有争议性，为了吸引眼球不择手段，简直可耻。最后，对斗兽场上的人，我觉得作者这句话说得非常好：

    > 现在太多这样让人啼笑皆非的指控，对房间里的大象这始作俑者视而不见，只会拿活在大象威胁下的人甚至是受害者开刀，这算什么英雄？

    除非我是太幼稚、被周深的眼泪骗了，否则我觉得那些攻击受害者的吃瓜群众真的是没有良心，他们的暴力行径，跟伤害叶永志、鹿道森、刘学州的人并没有什么本质区别。要骂就骂浙江卫视、骂不择手段的娱乐节目、骂当今的这种流量为王的妖风、骂孜孜不倦关注娱乐圈的我们自己——我们自己的意志软弱就是那青萍之末，促成了眼球经济的妖风。

1. 顺便找到[鹿道森的遗书](https://user-images.githubusercontent.com/163582/180463318-b49b6f6a-62d3-45d4-99a2-7463d51eb89b.jpeg)读了几遍，思绪一言难尽。比如，我们能提前甄别并援助这样的人吗？我估计会很难，因为心理受过重伤的人应该不会轻易向别人开口吐露，否则容易造成二次、三次伤害。他宁愿被噩梦追着逃十几、二十年，也不愿再回忆噩梦的细节。就算他鼓起勇气吐露出自己的自杀倾向，如果没有找对合适的倾听者，别人可能会不理解他的痛苦，反而加剧痛苦、加速他结束自己的生命（比如有人也许会说，哦，就这么点事你至于想自杀吗）。不知道有没有一种类似树洞平台可以提早识别和挽救这样的人；越早发现自杀倾向，应该越容易化解。

    但我有个听起来很缺乏人道主义的问题（天地不仁以万物为刍狗），就是他痛苦绝望到了那个程度，有没有可能离开这个世界真的是更好的选择？要是我们能劝阻他那次放弃投海，后面我们是否能真的帮他卸下各种重担？

    整封遗书，都在重复一个主题，就是缺爱。我觉得非常遗憾的是，要是他生前能多让别人了解一点自己的内心，我相信他会找到爱的。可惜他的心理创伤太重，以至于封闭了自己，别人没有很好的机会走进他的心里。恶性循环下，他也许认为爱是极其难得的东西。越缺爱，越封闭，越绝望。也许厚重、浓烈的爱是很难得，但要想劝人放弃轻生念头，也许一剂普通的爱就够了吧。唉，鹿道森，就算我完全不了解你过去的人生经历，只要我看到一个陌生人提到他还记得小学课文里的凡卡，那就足以让我觉得可以和我交个朋友了，因为在我小学毕业后的人生里，我还没遇到过一个人跟我提起凡卡，而我，这么多年来[一直都记得凡卡](/cn/2019/06/fifteen-dollars/)。只可惜，我第一次看到人提起，却是在你的遗书中。

1. 以前我提过一次[完美主义的危险](/cn/2018/03/perfectionism/)，这次读到一篇讲如何[抛弃完美主义](https://arunkprasad.com/log/unlearning-perfectionism/)的文章。开头作者讲，真正糟糕的不是完美主义追求的结果（那些结果往往是好的），而是完美主义者将这些完美的结果与他的[自我标签](/cn/2018/03/identity/)绑定在了一起，认为只有达到完美的结果，自己才有价值。换句话说，达不到完美，就意味着自己不完美。这是一种病态心理，会带来诸多恶果，如：拖延症（要达到完美太难，所以不想去做）、[冒名顶替症](https://zh.wikipedia.org/wiki/%E5%86%92%E5%90%8D%E9%A0%82%E6%9B%BF%E7%97%87%E5%80%99%E7%BE%A4)（害怕别人发现自己没有那么厉害，所以逼迫自己厉害）、强迫症（害怕面对自己的缺陷，所以漫无目的地持续刷朋友圈以逃避）、倦怠（达不到完美的标准，所以感到受伤、无助、自己无价值）。

    怎么解决？作者说一种办法是将完美换成优秀（这也是我前一篇文章中提到过的）。完美主义是想达到高标准，要得到特定的结果才算完；而优秀只是要追求高标准，活在当下，无论结果如何，追求的过程中有进步即可。

    要戒除已经习得的完美主义，我们需要训练自己正视并容忍现实中不完美的自我，并练习用[自爱](https://en.wikipedia.org/wiki/Self-compassion)替换掉对自我价值的评价。手段可以是[认知行为疗法](https://en.wikipedia.org/wiki/Cognitive_behavioral_therapy)、冥想、[感激日志](https://ggia.berkeley.edu/practice/gratitude_journal)。我顺着感激日志的链接过去瞄了一眼，感觉它的八条小贴士已经点明了快乐的真谛，诸如：不要把“所得”当做“应得”而是当“礼物”（所以感激）、用减法而非加法去思考（从现状中减掉什么会令你多痛苦，而不是在现状中加入什么能令你更快乐，所以要感激现状中你还没有失去的东西）。

    文末作者已经看穿了完美主义者的心思，说多数人看完这篇文章之后什么也不会做，所以他让读者向未知世界迈开第一步，也就是花五分钟时间给他写封邮件。而我估计多数人也不会写……

1. 有人称[思考的技能只可以学而不可以教](https://fs.blog/how-to-think/)。我看到这句话有点疑惑，要是不能教，那怎么学、从哪儿学呢。就算是自然习得，那也是有个自学的过程吧。另外，如果人不能被教会思考，那这篇文章不就是在教么。

    好吧，不抠字眼。文章核心意思就一个词，也是我过去几次[提过](/cn/2019/07/inner-peace/)的：[聚焦](/cn/2019/03/influence-focus/)。有质量的思考需要大块时间，若总是分心，那是思考不出什么有意义的东西的。文中举了几个作家的例子，说他们写得多慢。我有点疑心这些例子是否有代表性，哪怕我自己是深信“慢既是快、少既是多”之类的信条的。我早听闻一本叫《思考，快与慢》的书但还没读过，大概是和书中所说的用“系统 2”思考类似吧。

    作者也声称思考带来更好的决策，而好的决策会带来更多长期回报，比如人会有更多自由时间，而忙人往往因为要花大把时间去修正过去匆匆作出的坏决策。对此我也是表示怀疑，这个逻辑有点过度简化。忙[只是因为](/cn/2020/07/productivity-busy/)我们思考太少、决策太糟吗？

    我自己本就是这篇文章的理念的践行者，会花很多时间思考，也会有意识要求自己专心致志，但目前我还并没有觉得思考让我得到很明显的轻松自由（我确实通过思考摆脱了一些桎梏但这是好事还是坏事也难说）。也许是还没到给我分红的时候？

1. 推特上[有个家伙](https://twitter.com/awilkinson/status/1451256182329548802)读了一本叫《Wanting》的书，感到很兴奋。本佛系中年围观了一下他的读后感（你们特么为什么总爱用推特的节节屎方式写读后感），觉得简直毫无深度和新意。核心意思：搞清楚你的欲望是受他人影响、出于模仿心理的浮浅欲望，还是发自内心的深层欲望。佛系中年的欲望怎么可能受他人的影响嘛，别人的豪宅豪车豪爹豪娃，与我特么有什么关系，我特么为什么要用别人的欲望惩罚我自己（惩罚自己卖命干活，好过上别人的生活，那我岂不是个傻子）。各人喜欢各人自己的生活不香吗。

1. 有人喊，[现在的照片都太美啦](https://www.theatlantic.com/culture/archive/2021/10/internet-lost-bad-photos/620463/)。是啊，我[也这么觉得](/cn/2019/10/child-picture/)。我可能已经是个不中用的爱怀旧的老古董喽，总在惦念不那么漂亮的陈谷子烂芝麻和不那么方便的旧日生活（例如需要等待冲洗的胶卷照片和需要等待邮寄的手写信件）。

    [有人尝试戒除智能手机和社交媒体](https://www.alvarez.io/posts/living-like-its99/)后发现生活轻松多了。他发现罪魁祸首是太过方便的智能手机。文中有[一幅插图](https://www.alvarez.io/img/color/l99-2.jpg)挺有意思的，是一部老电话机的照片，下面写着：“过去电话被拴在电话线上时，人们都是自由的。”我早就觉得无线设备表面上解放了人类，但实质上是更多的束缚。比如无线网络加上移动设备，会让我们强迫症式地低头刷消息；无线耳机让我们可以离开电脑继续开网络会议，但问题首先是为什么我们如今有这么多会要开，其次是无线耳机表面上给予了我们任意空间移动的自由，但实际上是剥夺了移动的自由，因为要是没有无线耳机，我们才会考虑怎样才能避免开这些该死的开不完的会，把时间用在真正没有限制的移动上。作者也说没有智能手机的相机之后，会让你享受当下的时光，而不是强迫症式地拍照（晚饭时认真吃你的狗粮吧，别总想着把它拍下来发到网上）。帕斯卡这句话我最近看到过两遍了：

    > All of humanity's problems stem from man's inability to sit quietly in a room alone.

    一个人安安静静独自坐在房间里，如今是前所未有地难啊。

1. 九年前[我出版第一本英文书](/en/2013/06/tips-for-writing-an-r-book/)的时候，编辑教了我一条我觉得非常奇怪的规则，那就是如果引号引到了句末的词，那么句号要放在引号内。我觉得这种情况下引号引的对象是词而不是整句话，而句号是用来结束一句话的，那么句号应该在引号外才对。当时我也没想太多，以为这是行规，就照她的意见改了。结果现在才看到有人说[这种美式引号规则完全不合理](https://www.erichgrunewald.com/posts/the-american-style-of-quotation-mark-punctuation-makes-no-sense/)，而原本符合我直觉的那种是英式规则（句号在引号外）。

1. [有人提议](https://critter.blog/2021/01/12/if-it-matters-after-today-stop-talking-about-it-in-a-chat-room/)“如果一项讨论到明天依旧重要的话，那么今天就不要用聊天室讨论”。我觉得这是很明智的，但在这个[即时通讯工具](/cn/2017/06/im/)泛滥的时代，人与人都互相绑架，谁能、谁敢率先退出聊天群？我实在是对这种嘈杂、低效、饮鸩止渴、欲速不达、而偏偏又离不开的工具深恶痛绝。

1. 如今的成年人一边怀念自己童年时的自由和独立（独自坐车上学、独自去公园玩、独自去商店打酱油），一边把自己的孩子看得死死的。究竟是当今社会的实质危险变大了，还是我们想象的危险变大了？儿童拐卖、绑架、谋杀的新闻是否过度修改了我们对危险程度的认知？直升机式育儿，剥夺了儿童自己评估风险的能力，以及适应挫折和失败的能力，这都是日后必需的能力。《散养孩子》的作者写了篇文章说[孩子也需要自由](https://www.persuasion.community/p/kids-need-freedom-too)，里面提到儿童的失踪案件多数是孩子离家出走以及监护人争夺监护权时发生的，真正被陌生人诱拐的案件是极少数，也提到我[三年前提过的](/cn/2019/02/helicopter-parenting/)一个案子，就是一家父母特意让两个孩子独自从公园走回家、结果孩子被警察带走、父母还被儿童保护机构告上了法庭。唉，保护，保护，无休止的保护。儿童那边保护到了一个极端，家长这边也到了需要立法保护家长允许孩子自己玩而不被告上法庭的程度。有点荒谬吧。

1. 一篇关于[日本人婚姻的文章](https://www.douban.com/note/831004561/)中有张剧照的台词让我又感到一丝[日式幽默](/cn/2014/01/joke/)：（家庭主妇控诉丈夫）在家吃完饭，说一声真好吃啊，就相当于付钱啊。不过这话也让人感到有一丝心酸。婚姻关系就像计划经济，把很多事情都变成了理所当然、按规则或习俗行事，这大概是一切悲剧的起点，因为理所当然就意味着没了感恩。但如果按市场经济运营婚姻（比如吃饭要像在餐馆一样付钱），那又不禁让人怀疑婚姻的意义是什么。

1. 看到一则“[富足的悖论](https://perell.com/note/the-paradox-of-abundance/)”，大意是富足对多数人来说可能并非好事。例如食物的富足让我们过度肥胖，信息的富足让我们反而更加无知。这是因为太多勾魂的垃圾食物和垃圾信息排挤走了健康食物和严谨信息，而多数人的自制力并没有那么强，只能沦陷其中。富足只是让一小部分有自主选择意识的人受益。文中有句话：

    > Just as you'll improve your food diet if you start cooking, you'll improve your information diet if you start writing.

    这也与我的理念相符：我[一直推崇](/cn/2019/07/inner-peace/)多输出（写）而不要只是胡乱吞咽别人的输出。当然，我也推崇自己做饭、免受餐馆勾引，毕竟餐馆没有动力考虑普罗大众的健康，它只会追求好吃、好吃、更好吃。作为厨子，我说句特别找抽的话：单纯只是把饭做得好吃其实有何难呢，通常的好吃不外乎就几种手段（油、糖、鲜以及重口味）；难做的是加了约束条件的好吃。

    文章最后一段的建议提到要关注正确的人、吸收他们的推荐。我个人不是很喜欢这条建议，因为这听起来有某种洗脑嫌疑。如果是我来给建议的话，我会倾向于用 [Lewis 的建议](/cn/2019/01/confusion-seclusion/)，也就是要留出时间读老书，不要把自己的全部时间都投资在当下的书籍或信息上。尤其是那种作者已经死了千百年的书（比如塞内卡），作者们不会再诈尸喊你在推特上关注他们，千龄万代的读者已经帮你淘洗过他们。不能说老书没有垃圾（甚至若要迅哥儿说，在座的中国古书全都是垃圾），但至少读起来会少很多噪声。

    另外吐个槽，这文章中的两幅折线图我盯着看了好几分钟才明白。他真正想用的应该是直方图，用来表示频数，而横纵坐标轴的标签也太不清楚了，横轴是健康或聪明的程度，纵轴是人数。唉，一言胜二图，这二图还不如不用。

1. [如何才能在不强迫自己的情况下更有生产力](https://www.deprocrastination.co/blog/how-to-be-productive-without-forcing-yourself)？这篇文章不是很有新意，不过我也稍微小结一下。工作不一定意味着干苦力，不然为什么有些人很有生产力并喜欢工作？他们能从工作中得到循环正反馈。如果工作有趣、有意义、任务明晰，那么你就会停不下来工作。

    如何让工作更有趣？首先戒除那些令你上瘾的低投入、高回报的乐趣，比如打游戏、酗酒。有这些唾手可得的快乐源存在，你就会不断被它们吸引，而相比之下工作就乏味得多。也可以尝试盯着墙看一刻钟，故意让自己无聊，方知有点事情干多幸福。体验无聊也是一种重要的能力和策略。

    如何让工作更有意义？想想为什么要做这份工作，找出理由并强化。我觉得这建议有点自我洗脑的嫌疑啊，毕竟也有人说世上多数工作都是[狗屁工作](https://zh.wikipedia.org/wiki/%E7%8B%97%E5%B1%81%E5%B7%A5%E4%BD%9C)，而我也是倾向于相信他的。

    如何让工作明晰？模糊的任务让人有抗拒心理，因为未知总是可怕的。首先确定从哪里开始、然后只开始几分钟、做出来的第一个版本可以是垃圾。这都是为了降低开始任务的门槛。

    我个人觉着吧，还是[外界的正反馈](/cn/2019/07/inner-peace/)更有用。自己督促、对抗、说服自己容易失败。人最难战胜的敌人就是自己。

1. Paul Graham 有一篇《[如何卖命工作](http://paulgraham.com/hwh.html)》的文章，我没仔细读，开头说到伟大的工作需要三要素：天分、练习、努力。就算是天才，也要超常努力。

1. [我的经验是](/cn/2018/02/parenting/)育儿的文章读了通常都白读（若觉得没白读那通常是遇上了忽悠），因为困扰家长的常见问题通常都没有所谓的正确答案，比如[要不要尽早分房睡](https://www.bbc.com/future/article/20210222-the-unusual-ways-western-parents-raise-children)。西方文化会鼓励父母尽早与幼儿分开睡（旨在培养所谓的独立），而亚洲文化里则会与幼儿在同一个房间甚至同一张床上睡好几年。英美儿科学会说同床睡与更大的婴儿猝死风险相关，但相关不意味着因果，仅仅是相关并不能说明任何问题，而且亚洲国家里的婴儿猝死率更低，这又是个反面证据。所以要跟幼儿睡多久呢？木有正确答案，家长看着办。对我而言，两个娃都是从小夜夜几次夜哭到三岁多才消停，在那之前我有很强烈的意愿把他们丢在单独的房间里睡，好让他们少吵我几分钟，然而其实丢走他们也并没什么实际作用，我依然是夜夜被隔壁的哭声哭醒几次；后来终于能睡过夜了，留在我房间里睡我也没意见了，于是现在七岁五岁的娃们还跟我睡同一个房间，他们乐意什么时候搬走就什么时候搬吧。

1. 说到婴儿猝死，我又碰巧读到[一篇文章](https://www.biospace.com/article/researchers-answer-how-and-why-infants-die-from-sids/)号称终于找到了婴儿猝死的真正原因。过去人们通常以为婴儿猝死是因为大人照料不周，而婴儿被衣物被褥憋死或热死，所以大人会感到非常内疚。这篇文章说婴儿猝死是因为他们体内一种叫 BChE 的酶的活性相比其他婴儿要显著地低，导致他们不容易醒来，所以在危险情况下（比如窒息）也会继续昏睡。换句话说，婴儿猝死更多是天灾而非人祸。世上还有多少事情实际上是不可控的天灾而又看起来像是人祸呢？人类在生理层面的谜应该还有很多吧。

1. Mike Bostock 分享了他的十年开源可视化工作经验：一、教人用你的工具是创造工具过程中最有影响力的一面（最好多提供示例，这与我的策略一样，如 [knitr](https://github.com/yihui/knitr-examples) 和 [shiny](https://github.com/rstudio/shiny-examples)；创建一些可以不需要作者持续时间投入的教程、让用户可以自学，这就像被动收入一样可以让你躺着挣钱；教人可以让你站在新手角度不断审视自己已经内化的对自己工具的知识）。二、回答问题能让你更好理解用户的痛苦和疑惑、吸收更好的主意（这也是[我的切身体会](/en/2017/08/so-gh-email/#conclusion)）。三、酷炫都是有代价的，如动画。四、分清探索性可视化和展示性（解释性）可视化，前者是给自己的，后者是给别人的。五、数据清理占了可视化的大部分工作。六、不要在一种特定的图形上吊死。七、多数缺陷是少数代码造成的（感觉这有点废话，世上没多少东西是均匀分布的）。八、因特网让你感觉糟糕，因为坏话可以很快传到你耳朵里（做开源确实需要情绪管理，毒舌的人总是存在，虽然一般来说是少数甚至极少数）。九、别单枪匹马地干，让朋友们提供情绪支持。十、玩得开心。

    个人觉得一、二、八是比较有价值的经验之谈。开源界的新新战士们可以一边战斗一边学习。

1. Paul Graham 谈《[简单地写作](http://paulgraham.com/simply.html)》。为什么用简单的词句？原因包括：读者和作者都可以节省脑力，去理解和表达真正的意思；读者有力气读得更多；英文作者要考虑非英语母语的读者；太华丽的写作不仅会掩藏想法，而且可能还是在试图掩藏作者的空脑瓜；简单文字可以留存更久。作者自认为最看重的原因是，那些复杂、堆砌专业辞藻的句子看起来太笨拙。作者自己把文字写得简单的途径是修改，往往是删减。

    当然凡事都不能极端，作者也说了有时候不可避免需要用复杂句子，只是别故意这样做就好。他列举的原因里，我个人最看重的是别用复杂语言掩盖你的空脑袋，即[道金斯难度守恒定律](https://d.cosx.org/d/421215/4)。

1. [王总真的是](https://mp.weixin.qq.com/s/JSCWfEAfIDcQq9oWCyo8sA)寿司之神的铁杆粉丝，这十几年来已经捧了好多遍了。一生专心致志做一件事，听起来相当动人，我也真心钦佩这样的人，但是我有两个问题。一是我们能将这种职业方式推而广之吗？我疑心这里面有[幸存者偏差](/cn/2017/04/survivorship-bias/)，若所有人都尝试把一件事做到极致而成功，多少人能存活下来呢？二是那寿司真的那么好吃吗？说实话我有点怀疑。我不只是针对这寿司，而是针对广义的美食。可能是因为我个人对食物的要求太低了，而且味觉又不是特别敏感，所以我总觉得对食物做些锦上添花的事情带来的附加值极其有限，与锦上添花需要的付出不成比例。比如为了最好的口感而给章鱼按摩四十分钟对我来说完全是浪费时间，我只需要两勺辣椒酱，章鱼就好吃上天了，完全不介意我的咬肌需要用 1 牛顿的力还是 1.05 牛顿去咀嚼。

    要回答这两个问题，都需要试验数据，而且第一个问题需要几十年的时间，所以可能也不太现实。第二个问题相对容易一些：把寿司之神的寿司和别人家的寿司拿来做个双盲试验，看到底食客能否从知觉上区分出来。没有这样的试验的话，我只能以不锈钢直男兼小人之心想去吃那寿司的人想吃的可能并不是寿司本身，而是去打卡吃个情怀，感动一下自己，假装自己通过吃寿司也获得了坚持一生的能量，而可能吃完嘴巴一抹，发现并没有，只是继续打卡下一家米其林三星店。当然这也无可厚非，就像阿呆小朋友前段时间突然提起说要吃寿司，老父亲就去沃尔玛买了几张海苔回来，煮一锅米饭，用米饭包上几筷子剩菜，卷吧卷吧切了，小朋友就吃得开心坏了。他想吃的是寿司本身吗？可能也不是，只是吃个新鲜感而已。

1. 看[徐新的访谈](https://mp.weixin.qq.com/s/X73UmRkAx2tFqYOy2iw4lA)，我除了非常赞同知识的复利之外，对她分享的智慧并不以为然。其实我也不熟悉这位女王，文章读下来我觉得她非常非常聪明，但一方面我们要考虑幸存者偏差（此处还要特别考虑这位幸存者的背景），另一方面，目前中国商界里我最不钦佩的可能恰恰就是黄峥和张一鸣，而女王觉得错过了投他们还需要反思，大概我和女王的价值观完全相左吧。若我有那么多钱可以投资而错过了那两位，我做梦都会笑醒（太好了哈哈）。此外女王还反复夸赞数据和算法，而我正好认为数据和算法用来解读并勾引人心是邪恶的。然则成王败寇，赚到大钱了就是爷，我要这伦理有何用。

1. [美国的堕胎战](https://www.douban.com/note/831424246/)我是真的有点看不懂。除了愚蠢的宗教因素之外，[我不明白](/cn/2019/09/diversity-consultant/)这到底有什么可辩的，即：为什么一群成年人要为一个成年的怀孕女性做决策、不允许她堕胎。你们替她承受生育的痛苦和负担吗？如果你们无法替她生也无法帮她育，那到底有什么好说的呢？生育是一项重大决策，甚至可能是人生中最重大的决策，岂是一帮不相干的人动动嘴皮子就能替人决策的？

    我说宗教因素愚蠢，是指某些宗教禁止避孕。这除了让本来就不靠谱的男性更不靠谱以及将女性推进火坑之外，究竟有什么实质作用？

1. 时隔一个多月后，[“罗诉韦德案”被推翻](https://www.douban.com/note/833604491/)，这着实让人感到震惊。我看了金斯伯格大法官的[反对观点](https://tcya.xyz/2022/06/24/roe_v_wade.html)之后，觉得她讲得很有道理啊。这个案子的结果是对的，但判决理由是错的，即：不应该从隐私角度判决，而是女性自身的权利；另外，最高院也不该跨这么大的步子，一下子掀翻全国的堕胎相关法律，而是先把矛头明确指向德州当时那毫无人性的法律（除了危及孕妇生命安全的情形之外决不允许堕胎，哪怕是女性被强奸导致怀孕也不行）并废除它。这大概是好心办坏事的绝佳案例，而且恶果竟然过了半个世纪才浮出水面。

    顺手看了一眼关于金斯伯格法官的各种页面，读到[她关于阅读的一句话](https://www.bbc.com/zhongwen/simp/world-54238349)，本书虫自然同意：

    > 阅读为我打开了通往人生中无数美好事物的大门。阅读造就了我的梦想，更多的阅读助我实现自己的梦想。

    另外一句也让人感动：

    > （我希望留在人们记忆中的是）一个竭尽全部智慧、才能尽职工作的人。还有，为修复她所处的社会的撕裂助助力，尽自己的一切所能促成些微的改善。

    自问犬儒主义的我，能为社会的撕裂做什么吗？我得好好想想。

1. 关于修复撕裂，其实我是有一些零碎的想法的。比如我想建一个论坛，用来示范如何在观念不同的情况下依旧可以求同存异、和平共处。虽然这一点连我自己都觉得很难做到，但我相信一定有很多人可以做到，我想请他们来展示一下他们是如何做到的，而我自己也可以顺便学习一下。不必说，这样的一个论坛是绝对不会限制字数的，限制字数是社交媒体发明的最邪恶的斗兽手段。为了求同存异，我们首先需要充分表达自己的观点，这是最基本的前提。否则，连对方的意思都没搞清楚，打架也是打得稀里糊涂。近些年流行一句“一言不合就啥啥”的句式，我觉得它反映了即时通讯工具对我们表达的短平快驯化。就算打仗，我也希望可以退回到上个世纪的传统：用写信或写文章的方式打仗，而不是你说一句我立马顶一句。

    在这样一个论坛上，万一两个人或两群人真的无法求同存异，那么我们可以尝试动用群众力量去劝导，也许能促成双方的和解。我个人依旧相信群众的力量，而且我觉得如今群众善意的力量被严重低估了，导致一些本可以避免的官司或悲剧发生。我不喜欢一切都变得专业化的社会，比如一有纠纷就要请律师、一有心理问题就找心理咨询师，等等。专业人士当然有其用处，但我觉得群众的力量和智慧应该是可以与他们互补的。读一篇[关于严复的文章](https://www.douban.com/note/833342290/)，里面有一句：

    > 严复指出民众本能自己相生相养，却被君主欺夺患害。

    我就特别希望能见到民众在多数情况下能自己相生相养。今昔生活对比，我有一个很深的感触就是如今所谓现代化的生活缺了一个重要组成部分，就是邻居。我们都没了邻居。过去一家发生激烈争执或纠纷时，往往有几家邻居闻声赶来，拉开双方，分别劝解，其实这也算是扮演了一部分心理咨询的角色。很多时候，火大的事情经过旁人换个角度一讲，自己再想想，其实也就是芝麻大点事。这芝麻大点事，要是总是憋在密闭空间里，也是可能爆炸的。

    软件里我依旧相信开源。要是我们把开源的理念（任何人都有机会贡献）和心理咨询结合起来，“开源的心理咨询”会是怎样？要是每个人都有一些“云邻居”可以帮忙疏导自己的心结，会不会为这个社会化解一部分戾气？余秀华的家暴事件有可能远在爆发之前就互相和解谅解吗？我得继续想想。

1. 已经死了近一百万人后，[美国人为什么会对新冠变得麻木](https://www.theatlantic.com/health/archive/2022/03/covid-us-death-rate/626972/)？Ed Yong 说，过去半年新冠每天死一千人，假设过去半年每天都刮一次飓风导致一千人死亡，那么人们的态度肯定不会如此麻木。因为飓风、洪水这些自然灾害都是有形、可见的，而新冠病毒不是人们肉眼可见的，所以要感知它的危害或伤害，仅凭一个死亡数字是很难的。这个类比很好，确实能部分解释人们的麻木，但它也存在夸大的嫌疑，即：重大自然灾害不仅仅是死人，而且会造成其它重大损失；我感觉每天一场能刮死一千人的飓风，其后果应该比新冠死一千人要严重得多吧，比如它会导致相当大批的人流离失所，而新冠死人应该不至于有这么大的牵连。不管怎样，我觉得麻木、躺平的防疫策略绝对是不可取的。

1. 知道世界上有人在受苦时，我们沉浸于个人的幸福是否是一种自私或残忍？[这是个极好的问题](https://www.douban.com/note/830707345/)，也挺困扰我的。莱斯莉 · 贾米森引用了一首诗作答，表明我们应该享受，但这首诗我读来并不感到信服。

    > 但我们享受我们的生活，因为这是上帝想要的。

    > 让不公成为我们注意力的  
      唯一尺度，是在赞美魔鬼。

    我不是很喜欢用宗教词汇来给理由。为什么上帝想要我们享受生活？上帝为什么不帮那些受苦的人？我同意我们不能只注意到不公，但注意不公跟魔鬼有什么关系呢？关注不公不是一种同理心吗？为什么“同理心女王”会觉得这是赞美魔鬼呢？我很疑惑。

1. 偶然读到[后周世宗灭佛事件](https://baike.baidu.com/item/%E6%9F%B4%E8%8D%A3/859387)，我觉得这柴王爷讲得好极了，应该奖励他一盒花生糖：

    > 卿辈勿以毁佛为疑。夫佛，以善道化人，苟志于善，斯奉佛矣。彼铜像岂所谓佛耶？且吾闻佛在利人，虽头、目犹舍以布施。若朕身可以济民，亦非所惜也。

    我[以前提过](/cn/2019/04/sapiens-notes/#%E7%AC%AC%E5%8D%81%E4%BA%8C%E7%AB%A0-%E5%AE%97%E6%95%99%E7%9A%84%E6%B3%95%E5%88%99)丰子恺的《佛无灵》，信佛和信佛像是两码事，应该区分开。把佛像熔化了造铜钱，佛必然会答应的。这位皇帝甚至愿意拿自己的身体救济民众，他自己就已经成佛了。佛来灭佛，甚是有趣。

1. 马凌教授[回忆当年读书的往事](https://www.douban.com/note/832137122/)，说书架是她母亲连接她的精神脐带：

    > 我们母女像那个时代的大部分母女，羞于表达感情，拙于交流思想，惟有书架是她连接我的精神脐带。她从未指导我如何阅读、阅读什么，只是以书插架、默默陪伴，竟也深刻影响了我的一生。人在少年时代，因为没有参照系，不知道自己有多幸福。当我自己为人妻、为人师、为人母，回忆起少时妈妈的“伴读”，感慨良多。父母最难是一个放手，读书尤为如此。
    >
    > 我最感激妈妈的地方，是她本人向往自由，也给了我最大限度的自由。正是自由阅读，使我能够自我成就。

    这一段话对当今父母来说应该是颇有启发意义：与孩子的精神交流不一定需要当面说很多话。我觉得[话说得太多反而可能会阻碍理解](/cn/2021/09/upside-down/)。沟通在质不在量。

1. 列弛发给我一首王维的“[加餐](/cn/2018/11/eat-more/)”诗《[酌酒与裴迪](https://baike.baidu.com/item/%E9%85%8C%E9%85%92%E8%88%87%E8%A3%B4%E8%BF%AA/7344768)》，以前我不知道这首诗，读了几遍非常喜欢。我对王维的刻板印象是“诗佛”，就是“雨中山果落、灯下草虫鸣”的那种，而这首诗的前一半写得非常现实，有点让我意外。可谓一首半人半佛之诗。

    > 酌酒与君君自宽，人情翻覆似波澜。  
    > 白首相知犹按剑，朱门先达笑弹冠。  
    > 草色全经细雨湿，花枝欲动春风寒。  
    > 世事浮云何足问，不如高卧且加餐。

1. [有人解读](https://www.douban.com/note/830461555/)李璟的一句“手卷真珠上玉钩”，说这里用“真珠”比“珠帘”更好。我琢磨了一下，确实感觉如此，用具体的“真珠”写出了触感，而笼统的“珠帘”就不那么细致了，况且卷珠帘已经有点陈词滥调。进而提到杜甫的倒装句“香稻啄残鹦鹉粒，碧梧栖老凤凰枝”，我对这个有点奇怪的倒装没什么特别的感觉，反而觉得倒装过头影响了意思。放狗搜这句的时候顺便[找到了](http://www.wcai.net/poetry/lihua/56.htm)韩愈的一句“舞镜鸾窥沼，行天马渡桥”，这个倒装我倒是觉得比杜甫那句好得多：动作放前面，主体放后面。像武侠里的千里传音，人未到而音先到。至于那些关于倒装之后的平仄优势，我自然是毫不在意的——内容不必迁就形式。一说这里的“舞镜”为“入镜”。若凭欣赏的直觉，“舞”更有诗意和美感，但我用理性想一想，还是“入镜”更好，因为我更喜爱恬静闲适的画面。

1. 大约七年前第一次读到韦应物《初发扬子寄元大校书》，有感于“世事波上舟”的无常与无奈，体味到的情绪有些消极。如今再次读到，仿佛“而今听雨僧庐下”，心里已觉得云淡风轻。

    > 今朝此为别，何处还相遇？  
    > 世事波上舟，沿洄安得住？

    从古至今，人皆伤别离、盼相遇。但世上哪有什么离别？波上一叶叶扁舟，一直都同在天地人间。若湖心依旧荡漾，那么影响过你的人就从未离开过。
