---
title: 存在
date: '2021-07-13'
slug: existence
---

昨晚睡觉之前抬头瞄了一眼后院的夜空，看到一钩新月，略微发红。其尖其长，都超出我以前看过的钩月。看了一下日历，六月初三。

此前读了两遍王建的《[十五夜望月寄杜郎中](https://baike.baidu.com/item/%E5%8D%81%E4%BA%94%E5%A4%9C%E6%9C%9B%E6%9C%88%E5%AF%84%E6%9D%9C%E9%83%8E%E4%B8%AD/9900950)》，其中第一句第二个词“地白”又让我稍微回忆了两分钟儿时的月色。不得不说，我已经多年没有注意过月光照耀下的“地白”这种景象，但小时候的印象是非常深刻的。夏天的夜里，吃完晚饭洗完澡，因为月光照耀下村里的景色都和白天烈日强照时大不一样，真的是月色如水如练，所以让我感到非常新鲜，会开心地四处跑。在前面《[故乡的原风景](/cn/2021/07/hometown-scene/)》中，我便专门写了一段那时候的月色。

为什么长大后很少再注意到月色了呢？

我想这主要是因为长大后的绝大部分时间都住在钢筋水泥、灯火通明的城市里了，人造的灯光掩盖了月光。其次是因为生活节奏变得紧张起来，不紧张的时候夜生活也变得丰富得多。学习、工作、笙歌、饕餮、鸡飞狗跳，让人很难想到外面还有什么月光如练。

如果我们不再注意到月光，那月亮的存在还有意义吗？

思考自己存在的意义这种问题，往往让人感到有些恐慌。害怕答案是没有意义，或找不到意义，或担心现在好不容易找到的意义有一天会消失——相聚离开，都有时候，没有什么会永垂不朽。

前年[我提到](/cn/2019/01/what-is-success/)爱默生关于成功的定义，它的最后一句话是“至少有一个人的生活因为你的存在而变得轻松一点”。这是把存在的意义寄托在他人身上，可能也是最常见的“意义”。我们常常听到“我辛辛苦苦就是[为了你](https://music.163.com/song?id=376824)”这样的话，尤其是家长对孩子。我个人不是很喜欢这种绑架他人的话，尽管我知道它是出于善意。背负另一个人存在的意义，实在让人感到沉重。幸运的是，我成长过程中从没听我爹这样对我说过。我很清楚他辛辛苦苦就是为了我们弟兄二人，但他往往身教而不言传，从不明说。

人的存在是为了孩子，相信大多数家长都是这么想；连[达里奥也不例外](/cn/2020/07/principles-notes/#5-%E7%BB%88%E6%9E%81%E6%81%A9%E6%83%A0-1995-2010%E5%B9%B4)，打拼一生要留下财富保护家人。问题是，这样有没有让孩子因为家长的存在而变得轻松一点？本狗爹并不是传统意义上负责任的爹。至少当前阶段，我在克制要将我的物质财富传递给孩子的想法，也不想将我打下的江山拱手让给他们。我希望他们可以活出他们独立于我的完整精彩人生，即便这样会让他们吃苦。而我的精神财富基本上都是公开的（如果这也算得上财富的话），他们将来是否看得上或是否愿意继承，是他们自己的事，与我无关。当前阶段，我只是教他们[识字](/cn/kids/2021/02/chars/)、为他们[写故事](/cn/kids/2019/11/tale/)，希望他们能养成阅读的习惯，但就算他们走不上这条路，那也无妨；我本来就享受写这些故事，不需要此事有更多的附加在孩子身上的意义。

其实爱默生那句话有一处微妙，那就是它用的是完成时。他列举的种种成功之中，只有这一句的时态是完成时。确切翻译的话，应该加个“曾经”——“至少有一个人的生活曾经因为你的存在而变得轻松一点”。

我觉得有了这个“曾经”的限定后，存在的意义无论对人对己，都会轻松得多。可惜人似乎有一种追求永恒的本能，就像《西方哲学简史》中所说的：

> 不断有人投身哲学领域进行研究的目的之一便是追求永恒。这种追求是一种本能，最早是出于对生活的热爱和灾难的躲避。

若想追求永恒的意义，那大概只能像[保尔柯察金](/cn/2014/12/the-gadfly/)那样“为人类的解放事业奋斗终生”了。

若把存在的意义附加在个人身上，那么这个意义很难永恒，因为没有谁会永垂不朽。我们都会面临不可控的旦夕祸福，最终也不可避免要面临死亡。[2015 年](/cn/2017/01/blog/)我手术那次是我第一次考虑死生之事。近年来，我也有个问题偶尔浮现在脑中：人要怎样活，才能让自己在离开时[不引起他人的悲伤](/cn/2019/08/restless/)？更广义地说，我的人生目标之一是要让我的肉身存在与否没有太大差别。这个意思，其实去年我在《[万言万当，不如一默](/cn/2020/07/silence/)》已经表达过。如果有一个人的生活曾经因为我的存在而变得轻松一点，那我将十分欣慰。如果没有，我也没什么遗憾，因为无论别人是否注意到，我自问都曾经尽力真实存在过、发过光。

月亮需要存在的意义吗？无论[有人赋诗](/cn/2020/07/same-world/)，或无人注意，它永远一成不变地照耀着大地。

过去这一年算是我人生的一个低谷期，我时常感到疲惫和压抑，因此我特别感激一些人的存在，他们向我展示了无比的真诚、真实或天真，也给予了我无条件的信任。有时候我都觉得受之有愧——我何德何能。每当黄沙滚滚睁不开眼，在我心里还涌着甘泉。虽然我很少讲出我的感激，有些人可能也不知道他们曾经的存在对我的意义，但我是真切地重新感受到了月华如练、白地如水。
